/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBEntityResolver;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.service.XMLSchemaParser;
import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class SchemaLocationResolver {
    private String nameSpace = null;
    private String schemaLocation = null;
    private String WHITESPACESTRING = " ";
    private boolean downloadNewSchema = false;
    private static Logger logMetacat = Logger.getLogger(SchemaLocationResolver.class);

    public SchemaLocationResolver() {
    }

    public SchemaLocationResolver(String myNameSpaceAndLocation) {
        this.parse(myNameSpaceAndLocation);
    }

    public SchemaLocationResolver(String myNameSpace, String myLocation) {
        this.nameSpace = myNameSpace;
        this.schemaLocation = myLocation;
    }

    public void resolveNameSpace() {
        if (this.nameSpace != null && this.schemaLocation != null && !XMLSchemaService.getInstance().getNameSpaceList().contains(this.nameSpace)) {
            try {
                String newURLInMetacat = this.uploadSchemaFromURL(this.schemaLocation);
                ServiceService.refreshService("XMLSchemaService");
                if (!XMLSchemaService.getInstance().getNameSpaceList().contains(this.nameSpace)) {
                    this.registerSchema(newURLInMetacat);
                    ServiceService.refreshService("XMLSchemaService");
                }
                this.downloadNewSchema = true;
                String externalBaseURL = XMLSchemaService.getBaseUrlFromSchemaURL(this.schemaLocation);
                this.handleIncludedSchema(newURLInMetacat, externalBaseURL);
            }
            catch (Exception e) {
                logMetacat.error((Object)("Error in SchemaLocation.resolveNameSpace" + e.getMessage()));
            }
        }
    }

    private void handleIncludedSchema(String parentSchemaNewURLInMetacat, String externalBaseURL) throws SAXException, IOException, PropertyNotFoundException {
        if (externalBaseURL != null) {
            InputStream in = DBEntityResolver.checkURLConnection(SystemUtil.getContextURL() + parentSchemaNewURLInMetacat);
            XMLSchemaParser parser = new XMLSchemaParser(in);
            parser.parse();
            Vector<String> includedSchemaPaths = parser.getIncludedSchemaFilePathes();
            if (includedSchemaPaths != null) {
                for (int i = 0; i < includedSchemaPaths.size(); ++i) {
                    String schemaFilePath = includedSchemaPaths.elementAt(i);
                    try {
                        String newShemaURLInMetacat = this.uploadSchemaFromURL(externalBaseURL + schemaFilePath);
                        this.handleIncludedSchema(newShemaURLInMetacat, externalBaseURL);
                        continue;
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)("Warning on SchemaLocationResolver.handleIncludedSchema" + e.getMessage()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadSchemaFromURL(String schemaLocationURL) throws Exception {
        String relativeSchemaPath = "/schema/";
        String fullSchemaPath = SystemUtil.getContextDir() + relativeSchemaPath;
        String schemaURL = SystemUtil.getContextURL() + relativeSchemaPath;
        String filename = XMLSchemaService.getSchemaFileNameFromUri(schemaLocationURL);
        if (filename != null && !filename.trim().equals("")) {
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        } else {
            return null;
        }
        try {
            File f;
            InputStream istream = DBEntityResolver.checkURLConnection(schemaLocationURL);
            BufferedInputStream in = new BufferedInputStream(istream);
            File file = f = new File(fullSchemaPath, filename);
            synchronized (file) {
                int inputByte;
                if (f.exists()) {
                    throw new IOException("File already exist: " + f.getCanonicalFile());
                }
                FileWriter fw = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fw);
                while ((inputByte = in.read()) != -1) {
                    out.write(inputByte);
                }
                in.close();
                out.flush();
                out.close();
                fw.close();
            }
        }
        catch (Exception e) {
            throw new Exception("shemaLocationResolver.uploadSchemaFromURL(): " + e.getMessage());
        }
        logMetacat.warn((Object)("new schema location is: " + schemaURL + filename));
        return relativeSchemaPath + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSchema(String systemId) {
        if (systemId == null || this.nameSpace == null || this.nameSpace.trim().equals("")) {
            return;
        }
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        String sql = "INSERT INTO xml_catalog (entry_type, public_id, system_id) VALUES ('Schema', ?, ?)";
        try {
            conn = DBConnectionPool.getDBConnection("schemaLocation.registerSchema");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, this.nameSpace);
            pstmt.setString(2, systemId);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            logMetacat.error((Object)("SchemaLocation.egisterSchema(): " + e.getMessage()));
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("Error in SchemaLocation.egisterSchema(): " + sqlE.getMessage()));
            }
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
        XMLSchemaService.getInstance().populateRegisteredSchemaList();
    }

    private void parse(String nameSpaceAndLocation) {
        if (nameSpaceAndLocation == null || nameSpaceAndLocation.trim().equals("")) {
            return;
        }
        int indexOfWhiteSpace = nameSpaceAndLocation.lastIndexOf(this.WHITESPACESTRING);
        if (indexOfWhiteSpace != -1) {
            this.nameSpace = nameSpaceAndLocation.substring(0, indexOfWhiteSpace);
            this.schemaLocation = nameSpaceAndLocation.substring(indexOfWhiteSpace + 1);
            logMetacat.info((Object)("Namespace after parsing: " + this.nameSpace));
            logMetacat.info((Object)("Location after parsing: " + this.schemaLocation));
        }
    }

    public static void main(String[] argus) {
        try {
            DBConnectionPool pool = DBConnectionPool.getInstance();
            SchemaLocationResolver schema = new SchemaLocationResolver();
            logMetacat.warn((Object)("Namespace and Location String: " + XMLSchemaService.getInstance().getNameSpaceAndLocationString()));
            SchemaLocationResolver schema2 = new SchemaLocationResolver("eml://ecoinformatics.org/eml-2.0.0 http://dev.nceas.ucsb.edu/tao/schema/eml.xsd");
            schema2.resolveNameSpace();
            SchemaLocationResolver schema3 = new SchemaLocationResolver("http://www.xm.org/schema/stmml http://dev.nceas.ucsb.edu/tao/schema/stmml.xsd");
            schema3.resolveNameSpace();
            SchemaLocationResolver schema4 = new SchemaLocationResolver();
            logMetacat.warn((Object)("Namespace and Location String: " + XMLSchemaService.getInstance().getNameSpaceAndLocationString()));
        }
        catch (Exception e) {
            logMetacat.error((Object)("erorr in Schemalocation.main: " + e.getMessage()));
        }
    }

    public boolean getDownloadNewSchema() {
        return this.downloadNewSchema;
    }
}

