/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class SubTree
implements Comparator {
    protected String docId = null;
    protected String subTreeId = null;
    protected String startElementName = null;
    protected long startNodeId = -1L;
    protected long endNodeId = -1L;
    private Stack<NodeRecord> subTreeNodeStack = null;
    private static Logger logMetacat = Logger.getLogger(SubTree.class);

    public SubTree() {
    }

    public SubTree(String myDocId, String mySubTreeId, long myStartNodeId, long myEndNodeId) {
        this.docId = myDocId;
        logMetacat.info((Object)("Docid of Subtree: " + this.docId));
        this.subTreeId = mySubTreeId;
        logMetacat.info((Object)("id of Subtree: " + this.subTreeId));
        this.startNodeId = myStartNodeId;
        logMetacat.info((Object)("start node id of Subtree: " + this.startNodeId));
        this.endNodeId = myEndNodeId;
        logMetacat.info((Object)("end node id of subtree: " + this.endNodeId));
    }

    public Stack<NodeRecord> getSubTreeNodeStack() throws SAXException {
        try {
            this.subTreeNodeStack = this.getSubTreeNodeListFromDB();
        }
        catch (McdbException e) {
            throw new SAXException(e.getMessage());
        }
        return this.subTreeNodeStack;
    }

    public void setSubTreeNodeStack(Stack myStack) {
        this.subTreeNodeStack = myStack;
    }

    public void setDocId(String myId) {
        logMetacat.info((Object)("set doc id: " + myId));
        this.docId = myId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setSubTreeId(String myId) {
        logMetacat.info((Object)("set sub tree id: " + myId));
        this.subTreeId = myId;
    }

    public String getSubTreeId() {
        return this.subTreeId;
    }

    public void setStartElementName(String elementName) {
        logMetacat.info((Object)("set start elementname: " + elementName));
        this.startElementName = elementName;
    }

    public String getStartElementName() {
        return this.startElementName;
    }

    public void setStartNodeId(long nodeId) {
        logMetacat.info((Object)("set start node id: " + nodeId));
        this.startNodeId = nodeId;
    }

    public long getStartNodeId() {
        return this.startNodeId;
    }

    public void setEndNodeId(long nodeId) {
        logMetacat.info((Object)("set end node id: " + nodeId));
        this.endNodeId = nodeId;
    }

    public long getEndNodeId() {
        return this.endNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Stack getSubTreeNodeListFromDB() throws McdbException {
        Stack<NodeRecord> nodeRecordList = new Stack<NodeRecord>();
        if (this.docId == null) return nodeRecordList;
        if (this.startNodeId == -1L) return nodeRecordList;
        if (this.endNodeId == -1L) {
            return nodeRecordList;
        }
        Statement pstmt = null;
        DBConnection dbconn = null;
        int serialNumber = -1;
        long nodeid = 0L;
        long parentnodeid = 0L;
        long nodeindex = 0L;
        String nodetype = null;
        String nodename = null;
        String nodeprefix = null;
        String nodedata = null;
        String sql = "SELECT nodeid, parentnodeid, nodeindex, nodetype, nodename, nodeprefix, nodedata FROM xml_nodes WHERE docid = ? AND nodeid >= ? AND nodeid <= ? ORDER BY nodeid DESC";
        try {
            dbconn = DBConnectionPool.getDBConnection("SubTree.getSubTreeNodeList");
            serialNumber = dbconn.getCheckOutSerialNumber();
            pstmt = dbconn.prepareStatement(sql);
            pstmt.setString(1, this.docId);
            pstmt.setLong(2, this.startNodeId);
            pstmt.setLong(3, this.endNodeId);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                nodeid = rs.getLong(1);
                parentnodeid = rs.getLong(2);
                nodeindex = rs.getLong(3);
                nodetype = rs.getString(4);
                nodename = rs.getString(5);
                nodeprefix = rs.getString(6);
                nodedata = rs.getString(7);
                nodedata = MetacatUtil.normalize(nodedata);
                NodeRecord currentRecord = new NodeRecord(nodeid, parentnodeid, nodeindex, nodetype, nodename, nodeprefix, nodedata);
                nodeRecordList.push(currentRecord);
                tableHasRows = rs.next();
            }
            pstmt.close();
            return nodeRecordList;
        }
        catch (SQLException e) {
            throw new McdbException("Error in SubTree.getSubTreeNodeList 1 " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("error in SubTree.getSubTreeNodeList 2: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        SubTree tree1 = (SubTree)o1;
        SubTree tree2 = (SubTree)o2;
        if (tree1.getStartNodeId() > tree2.getStartNodeId()) {
            return 1;
        }
        if (tree1.getStartNodeId() < tree2.getStartNodeId()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        SubTree tree = (SubTree)obj;
        return this.startNodeId == tree.getStartNodeId();
    }
}

