/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.annotation;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.tdb.TDBFactory;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.annotation.BioPortalService;
import edu.ucsb.nceas.metacat.annotation.OrcidService;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;

public class DatapackageSummarizer {
    private static Logger logMetacat = Logger.getLogger(DatapackageSummarizer.class);
    public static String rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static String rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    public static String owl = "http://www.w3.org/2002/07/owl#";
    public static String oboe = "http://ecoinformatics.org/oboe/oboe.1.0/oboe.owl#";
    public static String oboe_core = "http://ecoinformatics.org/oboe/oboe.1.0/oboe-core.owl#";
    public static String oboe_characteristics = "http://ecoinformatics.org/oboe/oboe.1.0/oboe-characteristics.owl#";
    public static String oboe_sbc = "http://ecoinformatics.org/oboe-ext/sbclter.1.0/oboe-sbclter.owl#";
    public static String oa = "http://www.w3.org/ns/oa#";
    public static String oa_source = "http://www.w3.org/ns/oa.rdf";
    public static String dcterms = "http://purl.org/dc/terms/";
    public static String dcterms_source = "http://dublincore.org/2012/06/14/dcterms.rdf";
    public static String foaf = "http://xmlns.com/foaf/0.1/";
    public static String foaf_source = "http://xmlns.com/foaf/spec/index.rdf";
    public static String prov = "http://www.w3.org/ns/prov#";
    public static String prov_source = "http://www.w3.org/ns/prov.owl";
    public static String cito = "http://purl.org/spar/cito/";
    public static String OBOE_SBC = "OBOE-SBC";
    private static boolean cacheInitialized;

    private static void initializeCache() {
        if (!cacheInitialized) {
            OntDocumentManager.getInstance().addModel(oboe, ModelFactory.createOntologyModel().read(oboe));
            OntDocumentManager.getInstance().addModel(oboe_sbc, ModelFactory.createOntologyModel().read(oboe_sbc));
            OntDocumentManager.getInstance().addModel(oa, ModelFactory.createOntologyModel().read(oa_source));
            OntDocumentManager.getInstance().addModel(dcterms, ModelFactory.createOntologyModel().read(dcterms_source));
            OntDocumentManager.getInstance().addModel(foaf, ModelFactory.createOntologyModel().read(foaf_source));
            OntDocumentManager.getInstance().addModel(prov, ModelFactory.createOntologyModel().read(prov));
            OntDocumentManager.getInstance().addModel(cito, ModelFactory.createOntologyModel().read(cito));
            cacheInitialized = true;
        }
    }

    public void indexEphemeralAnnotation(Identifier metadataPid) throws Exception {
        String rdfContent = this.generateAnnotation(metadataPid);
        Dataset dataset = TDBFactory.createDataset();
        InputStream source = IOUtils.toInputStream((String)rdfContent, (String)"UTF-8");
        String name = "http://annotation/" + metadataPid.getValue();
        boolean loaded = dataset.containsNamedModel(name);
        if (loaded) {
            dataset.removeNamedModel(name);
            loaded = false;
        }
        OntModel ontModel = null;
        if (!loaded) {
            ontModel = ModelFactory.createOntologyModel();
            ontModel.read(source, name);
            dataset.addNamedModel(name, (Model)ontModel);
        }
        HashMap<String, List<Object>> fields = new HashMap<String, List<Object>>();
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX oboe-core: <http://ecoinformatics.org/oboe/oboe.1.0/oboe-core.owl#> PREFIX oa: <http://www.w3.org/ns/oa#> PREFIX dcterms: <http://purl.org/dc/terms/> SELECT ?standard_sm ?pid FROM <$GRAPH_NAME> WHERE { \t\t?measurement rdf:type oboe-core:Measurement . \t\t?measurement rdf:type ?restriction . \t\t?restriction owl:onProperty oboe-core:usesStandard . \t\t?restriction owl:allValuesFrom ?standard . \t\t?standard rdfs:subClassOf+ ?standard_sm . \t\t?standard_sm rdfs:subClassOf oboe-core:Standard . \t\t?annotation oa:hasBody ?measurement . \t\t?annotation oa:hasTarget ?target . \t\t?target oa:hasSource ?metadata . \t\t?metadata dcterms:identifier ?pid . }");
        queries.add("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX oboe-core: <http://ecoinformatics.org/oboe/oboe.1.0/oboe-core.owl#> PREFIX oa: <http://www.w3.org/ns/oa#> PREFIX dcterms: <http://purl.org/dc/terms/> SELECT ?characteristic_sm ?pid FROM <$GRAPH_NAME>WHERE { \t\t?measurement rdf:type oboe-core:Measurement . \t\t?measurement rdf:type ?restriction . \t\t?restriction owl:onProperty oboe-core:ofCharacteristic . \t\t?restriction owl:allValuesFrom ?characteristic . \t\t?characteristic rdfs:subClassOf+ ?characteristic_sm . \t\t?characteristic_sm rdfs:subClassOf oboe-core:Characteristic . \t\t?annotation oa:hasBody ?measurement .\t\t\t?annotation oa:hasTarget ?target . \t\t?target oa:hasSource ?metadata . \t\t?metadata dcterms:identifier ?pid . }");
        for (String q : queries) {
            q = q.replaceAll("\\$GRAPH_NAME", name);
            Query query = QueryFactory.create((String)q);
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                String id;
                QuerySolution solution = results.next();
                System.out.println(solution.toString());
                if (solution.contains("pid") && !(id = solution.getLiteral("pid").getString()).equals(metadataPid.getValue())) continue;
                Iterator varNameIter = solution.varNames();
                while (varNameIter.hasNext()) {
                    String key = (String)varNameIter.next();
                    if (key.equals("pid")) continue;
                    String value = solution.get(key).toString();
                    ArrayList<String> values = (ArrayList<String>)fields.get(key);
                    if (values == null) {
                        values = new ArrayList<String>();
                    }
                    values.add(value);
                    fields.put(key, values);
                }
            }
        }
        dataset.removeNamedModel(name);
        TDBFactory.release((Dataset)dataset);
        MetacatSolrIndex.getInstance().submit(metadataPid, null, fields, true);
    }

    public String generateAnnotation(Identifier metadataPid) throws Exception {
        DataPackage dataPackage = this.getDataPackage(metadataPid);
        OntModel m = ModelFactory.createOntologyModel();
        Ontology ont = m.createOntology("http://annotation/" + metadataPid.getValue());
        DatapackageSummarizer.initializeCache();
        ont.addImport(m.createResource(oboe));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oboe));
        ont.addImport(m.createResource(oboe_sbc));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oboe_sbc));
        ont.addImport(m.createResource(oa));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oa));
        ont.addImport(m.createResource(dcterms));
        m.addSubModel(OntDocumentManager.getInstance().getModel(dcterms));
        ont.addImport(m.createResource(foaf));
        m.addSubModel(OntDocumentManager.getInstance().getModel(foaf));
        ont.addImport(m.createResource(prov));
        ont.addImport(m.createResource(cito));
        ObjectProperty hasBodyProperty = m.getObjectProperty(oa + "hasBody");
        ObjectProperty hasTargetProperty = m.getObjectProperty(oa + "hasTarget");
        ObjectProperty hasSourceProperty = m.getObjectProperty(oa + "hasSource");
        ObjectProperty hasSelectorProperty = m.getObjectProperty(oa + "hasSelector");
        ObjectProperty annotatedByProperty = m.getObjectProperty(oa + "annotatedBy");
        Property identifierProperty = m.getProperty(dcterms + "identifier");
        Property conformsToProperty = m.getProperty(dcterms + "conformsTo");
        Property wasAttributedTo = m.getProperty(prov + "wasAttributedTo");
        Property nameProperty = m.getProperty(foaf + "name");
        Property rdfValue = m.getProperty(rdf + "value");
        ObjectProperty ofCharacteristic = m.getObjectProperty(oboe_core + "ofCharacteristic");
        ObjectProperty usesStandard = m.getObjectProperty(oboe_core + "usesStandard");
        ObjectProperty ofEntity = m.getObjectProperty(oboe_core + "ofEntity");
        ObjectProperty hasMeasurement = m.getObjectProperty(oboe_core + "hasMeasurement");
        OntClass entityClass = m.getOntClass(oboe_core + "Entity");
        OntClass observationClass = m.getOntClass(oboe_core + "Observation");
        OntClass measurementClass = m.getOntClass(oboe_core + "Measurement");
        OntClass characteristicClass = m.getOntClass(oboe_core + "Characteristic");
        OntClass standardClass = m.getOntClass(oboe_core + "Standard");
        OntClass annotationClass = m.getOntClass(oa + "Annotation");
        OntClass specificResourceClass = m.getOntClass(oa + "SpecificResource");
        OntClass fragmentSelectorClass = m.getOntClass(oa + "FragmentSelector");
        Resource provEntityClass = m.getResource(prov + "Entity");
        Resource personClass = m.getResource(prov + "Person");
        Individual meta1 = m.createIndividual(ont.getURI() + "#meta", provEntityClass);
        meta1.addProperty(identifierProperty, metadataPid.getValue());
        Individual p1 = null;
        List creators = dataPackage.getCreators();
        if (creators != null && creators.size() > 0) {
            String orcidUri = OrcidService.lookupOrcid(((Party)creators.get(0)).getOrganization(), ((Party)creators.get(0)).getSurName(), ((Party)creators.get(0)).getGivenNames(), null);
            if (orcidUri != null) {
                p1 = m.createIndividual(orcidUri, personClass);
                p1.addProperty(identifierProperty, orcidUri);
            } else {
                p1 = m.createIndividual(ont.getURI() + "#person", personClass);
            }
            if (((Party)creators.get(0)).getSurName() != null) {
                p1.addProperty(nameProperty, ((Party)creators.get(0)).getSurName());
            } else if (((Party)creators.get(0)).getOrganization() != null) {
                p1.addProperty(nameProperty, ((Party)creators.get(0)).getOrganization());
            }
        }
        if (p1 != null) {
            meta1.addProperty(wasAttributedTo, p1);
        }
        int entityCount = 1;
        Entity[] entities = dataPackage.getEntityList();
        if (entities != null) {
            for (Entity entity : entities) {
                String entityName = entity.getName();
                Individual o1 = m.createIndividual(ont.getURI() + "#observation" + entityCount, (Resource)observationClass);
                Resource entityConcept = this.lookupEntity(entityClass, entity);
                if (entityConcept != null) {
                    AllValuesFromRestriction avfr = m.createAllValuesFromRestriction(null, (Property)ofEntity, entityConcept);
                    o1.addOntClass((Resource)avfr);
                }
                logMetacat.debug((Object)("Entity name: " + entityName));
                Attribute[] attributes = entity.getAttributeList().getAttributes();
                int attributeCount = 1;
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        String cnt = entityCount + "_" + attributeCount;
                        String attributeName = attribute.getName();
                        String attributeLabel = attribute.getLabel();
                        String attributeDefinition = attribute.getDefinition();
                        String attributeType = attribute.getAttributeType();
                        String attributeScale = attribute.getMeasurementScale();
                        String attributeUnitType = attribute.getUnitType();
                        String attributeUnit = attribute.getUnit();
                        String attributeDomain = attribute.getDomain().getClass().getSimpleName();
                        logMetacat.debug((Object)("Attribute name: " + attributeName));
                        logMetacat.debug((Object)("Attribute label: " + attributeLabel));
                        logMetacat.debug((Object)("Attribute definition: " + attributeDefinition));
                        logMetacat.debug((Object)("Attribute type: " + attributeType));
                        logMetacat.debug((Object)("Attribute scale: " + attributeScale));
                        logMetacat.debug((Object)("Attribute unit type: " + attributeUnitType));
                        logMetacat.debug((Object)("Attribute unit: " + attributeUnit));
                        logMetacat.debug((Object)("Attribute domain: " + attributeDomain));
                        Resource standard = this.lookupStandard(standardClass, attribute);
                        Resource characteristic = this.lookupCharacteristic(characteristicClass, attribute);
                        if (standard != null || characteristic != null) {
                            AllValuesFromRestriction avfr;
                            Individual m1 = m.createIndividual(ont.getURI() + "#measurement" + cnt, (Resource)measurementClass);
                            Individual a1 = m.createIndividual(ont.getURI() + "#annotation" + cnt, (Resource)annotationClass);
                            Individual t1 = m.createIndividual(ont.getURI() + "#target" + cnt, (Resource)specificResourceClass);
                            String xpointer = "xpointer(/eml/dataSet/dataTable[" + entityCount + "]/attributeList/attribute[" + attributeCount + "])";
                            Individual s1 = m.createIndividual(ont.getURI() + "#" + xpointer, (Resource)fragmentSelectorClass);
                            s1.addLiteral(rdfValue, (Object)xpointer);
                            s1.addProperty(conformsToProperty, "http://tools.ietf.org/rfc/rfc3023");
                            a1.addProperty((Property)hasBodyProperty, (RDFNode)m1);
                            a1.addProperty((Property)hasTargetProperty, (RDFNode)t1);
                            t1.addProperty((Property)hasSourceProperty, (RDFNode)meta1);
                            t1.addProperty((Property)hasSelectorProperty, (RDFNode)s1);
                            if (standard != null) {
                                avfr = m.createAllValuesFromRestriction(null, (Property)usesStandard, standard);
                                m1.addOntClass((Resource)avfr);
                            }
                            if (characteristic != null) {
                                avfr = m.createAllValuesFromRestriction(null, (Property)ofCharacteristic, characteristic);
                                m1.addOntClass((Resource)avfr);
                            }
                            o1.addProperty((Property)hasMeasurement, (RDFNode)m1);
                        }
                        ++attributeCount;
                    }
                }
                ++entityCount;
            }
        }
        StringWriter sw = new StringWriter();
        m.write((Writer)sw, null);
        return sw.toString();
    }

    private Resource lookupStandard(OntClass standardClass, Attribute attribute) {
        String unit = attribute.getUnit().toLowerCase();
        return BioPortalService.lookupAnnotationClass(standardClass, unit, OBOE_SBC);
    }

    private Resource lookupCharacteristic(OntClass characteristicClass, Attribute attribute) {
        String label = attribute.getLabel().toLowerCase();
        String definition = attribute.getDefinition();
        String text = label + " " + definition;
        return BioPortalService.lookupAnnotationClass(characteristicClass, text, OBOE_SBC);
    }

    private Resource lookupEntity(OntClass entityClass, Entity entity) {
        String name = entity.getName();
        String definition = entity.getDefinition();
        return BioPortalService.lookupAnnotationClass(entityClass, definition, OBOE_SBC);
    }

    private DataPackage getDataPackage(Identifier pid) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
        Session session = new Session();
        Subject subject = MNodeService.getInstance((HttpServletRequest)request).getCapabilities().getSubject(0);
        session.setSubject(subject);
        InputStream emlStream = MNodeService.getInstance((HttpServletRequest)request).get(session, pid);
        Eml200DataPackageParser parser = new Eml200DataPackageParser();
        parser.parse(emlStream);
        DataPackage dataPackage = parser.getDataPackage();
        return dataPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void summarize(List<Identifier> identifiers) throws SQLException {
        DBConnection dbconn = null;
        int serialNumber = -1;
        Statement dropStatement = null;
        Statement createStatement = null;
        Statement insertStatement = null;
        try {
            dbconn = DBConnectionPool.getDBConnection("DatapackageSummarizer.summarize");
            serialNumber = dbconn.getCheckOutSerialNumber();
            dropStatement = dbconn.prepareStatement("DROP TABLE IF EXISTS entity_summary");
            dropStatement.execute();
            createStatement = dbconn.prepareStatement("CREATE TABLE entity_summary (guid text, title text, entity text,attributeName text,attributeLabel text,attributeDefinition text,attributeType text,attributeScale text,attributeUnitType text,attributeUnit text,attributeDomain text)");
            createStatement.execute();
            insertStatement = dbconn.prepareStatement("INSERT INTO entity_summary VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (Identifier pid : identifiers) {
                logMetacat.debug((Object)("Parsing pid: " + pid.getValue()));
                try {
                    DataPackage dataPackage = this.getDataPackage(pid);
                    String title = dataPackage.getTitle();
                    logMetacat.debug((Object)("Title: " + title));
                    Entity[] entities = dataPackage.getEntityList();
                    if (entities == null) continue;
                    for (Entity entity : entities) {
                        Attribute[] attributes;
                        String entityName = entity.getName();
                        logMetacat.debug((Object)("Entity name: " + entityName));
                        for (Attribute attribute : attributes = entity.getAttributeList().getAttributes()) {
                            String attributeName = attribute.getName();
                            String attributeLabel = attribute.getLabel();
                            String attributeDefinition = attribute.getDefinition();
                            String attributeType = attribute.getAttributeType();
                            String attributeScale = attribute.getMeasurementScale();
                            String attributeUnitType = attribute.getUnitType();
                            String attributeUnit = attribute.getUnit();
                            String attributeDomain = attribute.getDomain().getClass().getSimpleName();
                            logMetacat.debug((Object)("Attribute name: " + attributeName));
                            logMetacat.debug((Object)("Attribute label: " + attributeLabel));
                            logMetacat.debug((Object)("Attribute definition: " + attributeDefinition));
                            logMetacat.debug((Object)("Attribute type: " + attributeType));
                            logMetacat.debug((Object)("Attribute scale: " + attributeScale));
                            logMetacat.debug((Object)("Attribute unit type: " + attributeUnitType));
                            logMetacat.debug((Object)("Attribute unit: " + attributeUnit));
                            logMetacat.debug((Object)("Attribute domain: " + attributeDomain));
                            insertStatement.setString(1, pid.getValue());
                            insertStatement.setString(2, title);
                            insertStatement.setString(3, entityName);
                            insertStatement.setString(4, attributeName);
                            insertStatement.setString(5, attributeLabel);
                            insertStatement.setString(6, attributeDefinition);
                            insertStatement.setString(7, attributeType);
                            insertStatement.setString(8, attributeScale);
                            insertStatement.setString(9, attributeUnitType);
                            insertStatement.setString(10, attributeUnit);
                            insertStatement.setString(11, attributeDomain);
                            insertStatement.execute();
                        }
                    }
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("error parsing metadata for: " + pid.getValue()), (Throwable)e);
                }
            }
            return;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                if (dropStatement != null) {
                    dropStatement.close();
                }
                if (createStatement != null) {
                    createStatement.close();
                }
                if (insertStatement != null) {
                    insertStatement.close();
                }
            }
            catch (Exception e) {
                logMetacat.warn((Object)("couldn't close the prepared statement " + e.getMessage()));
            }
            finally {
                if (dbconn != null) {
                    DBConnectionPool.returnDBConnection(dbconn, serialNumber);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        SortedProperties testProperties = new SortedProperties("test/test.properties");
        testProperties.load();
        String metacatContextDir = testProperties.getProperty("metacat.contextDir");
        PropertyService.getInstance(metacatContextDir + "/WEB-INF");
        DatapackageSummarizer.testGenerate();
        System.exit(0);
    }

    public static void testGenerate() throws Exception {
        Identifier metadataPid = new Identifier();
        metadataPid.setValue("tao.1.4");
        DatapackageSummarizer ds = new DatapackageSummarizer();
        String rdfString = ds.generateAnnotation(metadataPid);
        logMetacat.info((Object)("RDF annotation: \n" + rdfString));
    }

    public static void testSummary() throws Exception {
        DatapackageSummarizer ds = new DatapackageSummarizer();
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        Map<Integer, String> serverCodes = ReplicationService.getServerCodes();
        boolean includeReplicas = true;
        Iterator<Integer> codeIter = Arrays.asList(1).iterator();
        if (includeReplicas) {
            codeIter = serverCodes.keySet().iterator();
        }
        Vector<String> idList = new Vector<String>();
        while (codeIter.hasNext()) {
            int serverLocation = codeIter.next();
            Vector<String> idList0 = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_0NAMESPACE, false, serverLocation);
            Vector<String> idList1 = DBUtil.getAllDocidsByType(DocumentImpl.EML2_0_1NAMESPACE, false, serverLocation);
            Vector<String> idList2 = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_0NAMESPACE, false, serverLocation);
            Vector<String> idList3 = DBUtil.getAllDocidsByType(DocumentImpl.EML2_1_1NAMESPACE, false, serverLocation);
            idList.addAll(idList0);
            idList.addAll(idList1);
            idList.addAll(idList2);
            idList.addAll(idList3);
        }
        for (String localId : idList) {
            try {
                String guid = IdentifierManager.getInstance().getGUID(DocumentUtil.getDocIdFromAccessionNumber(localId), DocumentUtil.getRevisionFromAccessionNumber(localId));
                Identifier pid = new Identifier();
                pid.setValue(guid);
                identifiers.add(pid);
            }
            catch (McdbDocNotFoundException nfe) {}
        }
        ds.summarize(identifiers);
        System.exit(0);
    }
}

