/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.database;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBConnection {
    private Connection conn;
    private String tag;
    private int status;
    private long age;
    private long createTime;
    private long connectionTime;
    private long checkOutTime;
    private int usageCount;
    private int checkOutSerialNumber;
    private SQLWarning warningMessage;
    private String checkOutMethodName;
    private static String DBDriver;
    private static String DBConnectedJDBC;
    private static String userName;
    private static String passWord;
    private static Logger logMetacat;

    public DBConnection() throws SQLException {
        try {
            DBDriver = PropertyService.getProperty("database.driver");
            DBConnectedJDBC = PropertyService.getProperty("database.connectionURI");
            userName = PropertyService.getProperty("database.user");
            passWord = PropertyService.getProperty("database.password");
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get property in static block: " + pnfe.getMessage());
        }
        this.conn = DBConnection.openConnection();
        if (this.conn == null) {
            System.out.println("connection is null.");
        }
        this.tag = this.conn.toString();
        this.status = 0;
        this.age = 0L;
        this.createTime = System.currentTimeMillis();
        this.connectionTime = 0L;
        this.checkOutTime = 0L;
        this.usageCount = 0;
        this.checkOutSerialNumber = 0;
        this.warningMessage = null;
        this.checkOutMethodName = null;
    }

    public Connection getConnections() {
        return this.conn;
    }

    public void setConnections(Connection myConnection) {
        this.conn = myConnection;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String myTag) {
        this.tag = myTag;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int myStatus) {
        this.status = myStatus;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.createTime;
    }

    public void setAge(long myAge) {
        this.age = myAge;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long myCreateTime) {
        this.createTime = myCreateTime;
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    public void setConnectionTime(long myConnectionTime) {
        this.connectionTime += myConnectionTime;
    }

    public long getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(long myCheckOutTime) {
        this.checkOutTime = myCheckOutTime;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public void setUsageCount(int myUsageCount) {
        this.usageCount = myUsageCount;
    }

    public void increaseUsageCount(int myUsageCount) {
        this.usageCount += myUsageCount;
    }

    public int getCheckOutSerialNumber() {
        return this.checkOutSerialNumber;
    }

    public void setCheckOutSerialNumber(int myCheckOutSerialNumber) {
        this.checkOutSerialNumber = myCheckOutSerialNumber;
    }

    public void increaseCheckOutSerialNumber(int myCheckOutSerialNumber) {
        this.checkOutSerialNumber += myCheckOutSerialNumber;
    }

    public SQLWarning getWarningMessage() throws SQLException {
        this.increaseUsageCount(1);
        return this.conn.getWarnings();
    }

    public void setWarningMessage(SQLWarning myWarningMessage) {
        this.warningMessage = myWarningMessage;
    }

    public String getCheckOutMethodName() {
        return this.checkOutMethodName;
    }

    public void setCheckOutMethodName(String myCheckOutMethodName) {
        this.checkOutMethodName = myCheckOutMethodName;
    }

    public void close() throws SQLException {
        this.conn.close();
        this.tag = null;
        this.status = 0;
        this.age = 0L;
        this.createTime = System.currentTimeMillis();
        this.connectionTime = 0L;
        this.checkOutTime = 0L;
        this.usageCount = 0;
        this.warningMessage = null;
    }

    public static Connection openConnection() throws SQLException {
        return DBConnection.openConnection(DBDriver, DBConnectedJDBC, userName, passWord);
    }

    private static Connection openConnection(String dbDriver, String connection, String user, String password) throws SQLException {
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            logMetacat.error((Object)("DBConnectionPool.openConnection - Class not found:  " + e.getMessage()));
            return null;
        }
        Connection connLocal = null;
        connLocal = DriverManager.getConnection(connection, user, password);
        return connLocal;
    }

    public static void testConnection(String dbDriver, String connection, String user, String password) throws SQLException {
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage());
        }
        Connection connLocal = null;
        connLocal = DriverManager.getConnection(connection, user, password);
        connLocal.close();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    static {
        logMetacat = Logger.getLogger(DBConnection.class);
    }
}

