/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.replication;

import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;

public class ReplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = -2898600143193513155L;
    private static Logger logReplication = Logger.getLogger((String)"ReplicationLogging");
    private static Logger logMetacat = Logger.getLogger(ReplicationServlet.class);

    public void init(ServletConfig config) throws ServletException {
        try {
            ServiceService.registerService("ReplicationService", ReplicationService.getInstance());
        }
        catch (ServiceException se) {
            String errorMessage = "ReplicationServlet.init - Service problem while intializing Replication Servlet: " + se.getMessage();
            logMetacat.error((Object)("ReplicationServlet.init - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        Enumeration paramlist = request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            String name = (String)paramlist.nextElement();
            String[] value = request.getParameterValues(name);
            params.put(name, value);
        }
        String action = "";
        if (!params.isEmpty() && params.get("action") != null) {
            action = ((String[])params.get("action"))[0];
        }
        String server = null;
        try {
            server = ((String[])params.get("server"))[0];
            boolean isValid = false;
            String msg = "Client certificate is invalid";
            try {
                isValid = this.hasValidCertificate(request, server);
            }
            catch (Exception e) {
                msg = "Could not verify client certificate: " + e.getMessage();
                logMetacat.error((Object)msg, (Throwable)e);
                logReplication.error((Object)msg, (Throwable)e);
            }
            if (!isValid) {
                out = response.getWriter();
                out.print("<error>");
                out.print(msg);
                out.print("</error>");
                out.close();
                return;
            }
            if (ReplicationService.getServerCodeForServerName(server) == 0) {
                logReplication.debug((Object)("ReplicationServlet.handleGetOrPost - Action \"" + action + "\" rejected for server: " + server));
                return;
            }
            logReplication.debug((Object)("ReplicationServlet.handleGetOrPost - Action \"" + action + "\" accepted for server: " + server));
            if (action.equals("readdata")) {
                ServletOutputStream outStream = response.getOutputStream();
                ReplicationService.handleGetDataFileRequest((OutputStream)outStream, params, response);
                outStream.close();
            } else if (action.equals("forcereplicatedatafile")) {
                ReplicationService.handleForceReplicateDataFileRequest(params, request);
            } else if (action.equals("forcereplicate")) {
                ReplicationService.handleForceReplicateRequest(params, response, request);
            } else if (action.equals("forcereplicatesystemmetadata")) {
                ReplicationService.handleForceReplicateSystemMetadataRequest(params, response, request);
            } else if (action.equals("forcereplicatedelete")) {
                ReplicationService.handleForceReplicateDeleteRequest(params, response, request, false);
            } else if (action.equals("forcereplicatedeleteall")) {
                ReplicationService.handleForceReplicateDeleteRequest(params, response, request, true);
            } else if (action.equals("update")) {
                ReplicationService.handleUpdateRequest(params, response);
            } else if (action.equals("read")) {
                ReplicationService.handleGetDocumentRequest(params, response);
            } else if (action.equals("getlock")) {
                ReplicationService.handleGetLockRequest(params, response);
            } else if (action.equals("getdocumentinfo")) {
                ReplicationService.handleGetDocumentInfoRequest(params, response);
            } else if (action.equals("getsystemmetadata")) {
                ReplicationService.handleGetSystemMetadataRequest(params, response);
            } else if (action.equals("gettime")) {
                ReplicationService.handleGetTimeRequest(params, response);
            } else if (action.equals("getcatalog")) {
                ReplicationService.handleGetCatalogRequest(params, response, true);
            } else if (action.equals("test")) {
                response.setContentType("text/html");
                out = response.getWriter();
                out.println("<html><body>Test successfully</body></html>");
            }
        }
        catch (ServiceException e) {
            logMetacat.error((Object)("ReplicationServlet.handleGetOrPost - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationServlet.handleGetOrPost - Error in ReplicationServlet.handleGetOrPost: " + e.getMessage()));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private boolean hasValidCertificate(HttpServletRequest request, String server) throws InvalidNameException, URISyntaxException, ServiceException {
        X509Certificate certificate = CertificateManager.getInstance().getCertificate(request);
        if (certificate != null) {
            int serverCode;
            String givenSubject = CertificateManager.getInstance().getSubjectDN(certificate);
            logMetacat.debug((Object)("Given certificate subject: " + givenSubject));
            String givenServerCN = null;
            LdapName ldapName = new LdapName(givenSubject);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                givenServerCN = (String)rdn.getValue();
                logMetacat.debug((Object)("Given server CN: " + givenServerCN));
                break;
            }
            if ((serverCode = ReplicationService.getServerCodeForServerName(server)) != 0) {
                URI serverURI = new URI("https://" + server);
                String serverHost = serverURI.getHost();
                logMetacat.debug((Object)("Checking against registerd replication server host name: " + serverHost));
                givenServerCN = givenServerCN.replace("*", "");
                return serverHost.endsWith(givenServerCN);
            }
        }
        return false;
    }
}

