/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.MetaCatServlet;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.XMLSchema;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class XMLSchemaService
extends BaseService {
    public static final String NAMESPACEKEYWORD = "xmlns";
    public static final String SCHEMA_DIR = "/schema/";
    private static XMLSchemaService xmlSchemaService = null;
    private static Logger logMetacat = Logger.getLogger(XMLSchemaService.class);
    private static boolean useFullSchemaValidation = false;
    private static Vector<XMLSchema> registeredSchemaList = new Vector();
    private static Vector<String> nameSpaceList = new Vector();
    private static String nameSpaceAndLocationString = "";

    private XMLSchemaService() {
        this._serviceName = "XMLSchemaService";
        try {
            this.doRefresh();
        }
        catch (ServiceException e) {
            logMetacat.debug((Object)e.getMessage());
        }
    }

    public static XMLSchemaService getInstance() {
        if (xmlSchemaService == null) {
            xmlSchemaService = new XMLSchemaService();
        }
        return xmlSchemaService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        logMetacat.debug((Object)"XMLService.doRefresh - refreshing the schema service.");
        try {
            this.populateRegisteredSchemaList();
            this.setUseFullSchemaValidation();
            XMLSchemaService.createRegisteredNameSpaceList();
            XMLSchemaService.createRegisteredNameSpaceAndLocationString();
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)"XMLService.doRefresh - Could not find property: xml.useFullSchemaValidation. Setting to false.");
        }
    }

    @Override
    public void stop() throws ServiceException {
    }

    public Vector<XMLSchema> getRegisteredSchemaList() {
        return registeredSchemaList;
    }

    public String getNameSpaceAndLocationString() {
        return nameSpaceAndLocationString;
    }

    public Vector<String> getNameSpaceList() {
        return nameSpaceList;
    }

    public boolean useFullSchemaValidation() {
        return useFullSchemaValidation;
    }

    private void setUseFullSchemaValidation() throws PropertyNotFoundException {
        String strUseFullSchemaValidation = PropertyService.getProperty("xml.useFullSchemaValidation");
        useFullSchemaValidation = Boolean.valueOf(strUseFullSchemaValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateRegisteredSchemaList() {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet resultSet = null;
        registeredSchemaList = new Vector();
        String sql = "SELECT public_id, system_id FROM xml_catalog where entry_type ='Schema'";
        try {
            conn = DBConnectionPool.getDBConnection("XMLService.populateRegisteredSchemaList");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement(sql);
            logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Selecting schemas: " + pstmt.toString()));
            pstmt.execute();
            resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                String fileNamespace = resultSet.getString(1);
                String fileLocation = resultSet.getString(2);
                logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Registering schema: " + fileNamespace + " " + fileLocation));
                XMLSchema xmlSchema = new XMLSchema(fileNamespace);
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) {
                    logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Processing http schema location: " + fileLocation));
                    xmlSchema.setExternalFileUri(fileLocation);
                    try {
                        URL u = new URL(fileLocation);
                        logMetacat.debug((Object)"XMLService.populateRegisteredSchemaList - Downloading http based schema...");
                        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestMethod("GET");
                        connection.setReadTimeout(5000);
                        connection.connect();
                        String schema = IOUtils.toString((InputStream)connection.getInputStream());
                        String deployDir = PropertyService.getProperty("application.deployDir");
                        String contextName = PropertyService.getProperty("application.context");
                        String filename = fileLocation.substring(fileLocation.lastIndexOf("/"), fileLocation.length());
                        File schemaFile = new File(deployDir + "/" + contextName + "/" + "schema/" + filename);
                        FileWriter fw = new FileWriter(schemaFile);
                        fw.write(schema);
                        fw.flush();
                        fw.close();
                        logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - Schema downloaded to " + schemaFile.getAbsolutePath()));
                        fileLocation = SCHEMA_DIR + filename;
                        logMetacat.debug((Object)("XMLService.populateRegisteredSchemaList - fileLocation set to " + fileLocation));
                        xmlSchema.setFileName(fileLocation);
                    }
                    catch (MalformedURLException me) {
                        logMetacat.warn((Object)("Could not cache a registered schema at " + fileLocation + " because a connection could not be made to the given url: " + me.getMessage()));
                    }
                    catch (IOException ioe) {
                        logMetacat.warn((Object)("Could not cache a registered schema at " + fileLocation + " because an IOException occured: " + ioe.getMessage()));
                    }
                    catch (PropertyNotFoundException pnfe) {
                        logMetacat.warn((Object)("Could not cache a registered schema at " + fileLocation + " because the property 'application.tempDir' could not be found."));
                    }
                    xmlSchema.setFileName(fileLocation);
                } else {
                    xmlSchema.setFileName(fileLocation);
                }
                if (FileUtil.getFileStatus((String)xmlSchema.getLocalFileDir()) >= FileUtil.EXISTS_READABLE) {
                    registeredSchemaList.add(xmlSchema);
                    continue;
                }
                if (fileLocation.startsWith("http://") || fileLocation.startsWith("https://")) {
                    registeredSchemaList.add(xmlSchema);
                    continue;
                }
                logMetacat.warn((Object)("XMLService.populateRegisteredSchemaList - Schema file: " + xmlSchema.getLocalFileDir() + " is registered " + " in the database but does not exist on the file system."));
            }
        }
        catch (SQLException e) {
            logMetacat.error((Object)("XMLService.populateRegisteredSchemaList - SQL Error: " + e.getMessage()));
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("XMLSchemaService.populateRegisteredSchemaList - Error in XMLService.populateRegisteredSchemaList(): " + sqlE.getMessage()));
            }
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    private static void createRegisteredNameSpaceAndLocationString() {
        boolean firstRow = true;
        nameSpaceAndLocationString = "";
        for (XMLSchema xmlSchema : registeredSchemaList) {
            if (!firstRow) {
                nameSpaceAndLocationString = nameSpaceAndLocationString + " ";
            }
            nameSpaceAndLocationString = nameSpaceAndLocationString + xmlSchema.getFileNamespace() + " " + xmlSchema.getLocalFileUri();
            firstRow = false;
        }
    }

    private static void createRegisteredNameSpaceList() {
        nameSpaceList = new Vector();
        for (XMLSchema xmlSchema : registeredSchemaList) {
            nameSpaceList.add(xmlSchema.getFileNamespace());
        }
    }

    public static boolean areAllSchemasRegistered(Vector<XMLSchema> schemaList) {
        for (XMLSchema xmlSchema : schemaList) {
            if (XMLSchemaService.isSchemaRegistered(xmlSchema)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSchemaRegistered(XMLSchema xmlSchema) {
        for (XMLSchema registeredXmlSchema : registeredSchemaList) {
            if (!registeredXmlSchema.getLocalFileUri().equals(xmlSchema.getLocalFileUri()) || !registeredXmlSchema.getFileNamespace().equals(xmlSchema.getFileNamespace())) continue;
            return true;
        }
        return false;
    }

    public static Vector<XMLSchema> findSchemasInXML(StringReader xml) throws IOException {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        Vector<XMLSchema> schemaList = new Vector<XMLSchema>();
        if (xml == null) {
            logMetacat.debug((Object)"XMLSchemaService.findSchemasInXML - Returning empty schemaList.");
            return schemaList;
        }
        String targetLine = XMLSchemaService.getSchemaLine(xml);
        if (targetLine != null) {
            String regex = "(\\p{Graph}*):schemaLocation=\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(regex, 34);
            Matcher matcher = pattern.matcher(targetLine);
            int i = 0;
            while (i < targetLine.length() && matcher.find(i)) {
                String uri = matcher.group(2);
                uri = StringUtil.replaceTabsNewLines((String)uri);
                uri = StringUtil.replaceDuplicateSpaces((String)uri);
                Vector parsedUri = StringUtil.toVector((String)uri, (char)' ');
                for (int j = 0; j < parsedUri.size(); j += 2) {
                    if (j + 1 >= parsedUri.size()) {
                        throw new IOException("Odd number of elements found when parsing schema location: " + targetLine + ". There should be an even number of uri/files in location.");
                    }
                    XMLSchema xmlSchema = new XMLSchema((String)parsedUri.get(j), (String)parsedUri.get(j + 1));
                    schemaList.add(xmlSchema);
                }
                i = matcher.end();
            }
        }
        logMetacat.debug((Object)("XMLSchemaService.findSchemasInXML - Schemas for eml are " + schemaList.toString()));
        return schemaList;
    }

    public static String findDocumentNamespace(StringReader xml) throws IOException {
        String regex2;
        Pattern pattern2;
        Matcher matcher2;
        String namespace = null;
        String eml2_0_0NameSpace = DocumentImpl.EML2_0_0NAMESPACE;
        String eml2_0_1NameSpace = DocumentImpl.EML2_0_1NAMESPACE;
        String eml2_1_0NameSpace = DocumentImpl.EML2_1_0NAMESPACE;
        String eml2_1_1NameSpace = DocumentImpl.EML2_1_1NAMESPACE;
        if (xml == null) {
            logMetacat.debug((Object)"XMLSchemaService.findDocumentNamespace - XML doc is null.  There is no namespace.");
            return namespace;
        }
        String targetLine = XMLSchemaService.getSchemaLine(xml);
        String prefix = null;
        String regex1 = "^\\s*(\\p{Graph}+):\\p{Graph}* ";
        Pattern pattern = Pattern.compile(regex1, 2);
        Matcher matcher = pattern.matcher(targetLine);
        if (matcher.find()) {
            prefix = matcher.group(1).trim();
        }
        if ((matcher2 = (pattern2 = Pattern.compile(regex2 = prefix != null ? "xmlns:" + prefix + "=['\"](.*)['\"]" : "xmlns:.*=['\"](.*)['\"]", 2)).matcher(targetLine)).find()) {
            namespace = matcher2.group(1);
            if (namespace.indexOf(eml2_0_0NameSpace) != -1) {
                namespace = eml2_0_0NameSpace;
            } else if (namespace.indexOf(eml2_0_1NameSpace) != -1) {
                namespace = eml2_0_1NameSpace;
            } else if (namespace.indexOf(eml2_1_0NameSpace) != -1) {
                namespace = eml2_1_0NameSpace;
            } else if (namespace.indexOf(eml2_1_1NameSpace) != -1) {
                namespace = eml2_1_1NameSpace;
            }
        }
        return namespace;
    }

    private static String getSchemaLine(StringReader xml) throws IOException {
        Logger logMetacat = Logger.getLogger(MetaCatServlet.class);
        String secondLine = null;
        int count = 0;
        boolean TARGETNUM = true;
        StringBuffer buffer = new StringBuffer();
        boolean comment = false;
        boolean processingInstruction = false;
        int thirdPreviousCharacter = 63;
        int secondPreviousCharacter = 63;
        int previousCharacter = 63;
        int currentCharacter = 63;
        int tmp = xml.read();
        while (tmp != -1) {
            currentCharacter = (char)tmp;
            if (currentCharacter == 45 && previousCharacter == 45 && secondPreviousCharacter == 33 && thirdPreviousCharacter == 60) {
                comment = true;
            }
            if (comment && currentCharacter == 62 && previousCharacter == 45 && secondPreviousCharacter == 45) {
                comment = false;
            }
            if (currentCharacter == 63 && previousCharacter == 60) {
                processingInstruction = true;
            }
            if (processingInstruction && currentCharacter == 62 && previousCharacter == 63) {
                processingInstruction = false;
            }
            if (currentCharacter != 33 && previousCharacter == 60 && !comment && !processingInstruction) {
                ++count;
            }
            if (count == 1 && currentCharacter != 62) {
                buffer.append((char)currentCharacter);
            }
            if (count == 1 && currentCharacter == 62) break;
            thirdPreviousCharacter = secondPreviousCharacter;
            secondPreviousCharacter = previousCharacter;
            previousCharacter = currentCharacter;
            tmp = xml.read();
        }
        secondLine = buffer.toString();
        logMetacat.debug((Object)("XMLSchemaService.getSchemaLine - the second line string is: " + secondLine));
        xml.reset();
        return secondLine;
    }

    public static String getSchemaFileNameFromUri(String uri) {
        int slash;
        String filename = uri;
        if (filename != null && !filename.trim().equals("") && (slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92))) > -1) {
            filename = filename.substring(slash + 1);
        }
        return filename;
    }

    public static String getBaseUrlFromSchemaURL(String url) {
        int slash;
        String baseURL = null;
        if (url != null && (url.indexOf("http://") != -1 || url.indexOf("https://") != -1) && (slash = url.lastIndexOf(47)) > -1) {
            baseURL = url.substring(0, slash + 1);
        }
        return baseURL;
    }
}

