/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.queryservice.util;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.types.URI;
import org.apache.xpath.XPathAPI;
import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EcogridQueryParser {
    private QueryType _ecogridQuery = new QueryType();
    private Node _queryNode;
    private static final String QUERYIDATTRIBUTE = "@queryId";
    private static final String SYSTEMATTRIBUTE = "@system";
    private static final String NAMESPACE = "namespace";
    private static final String PREFIX = "prefix";
    private static final String RETURNFIELD = "returnField";
    private static final String TITLE = "title";
    private static final String FIRSTAND = "AND";
    private static final String FIRSTOR = "OR";
    private static final String FIRSTCONDITION = "condition";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String CON = "condition";
    private static final String OPERATOR = "operator";
    private static final String CONCEPT = "concept";

    public static QueryType readEcogridXMLQuery(String string) {
        QueryType queryType = null;
        try {
            File file = new File(string);
            if (file != null) {
                FileReader fileReader = new FileReader(file);
                if (fileReader != null) {
                    EcogridQueryParser ecogridQueryParser = new EcogridQueryParser(fileReader);
                    if (ecogridQueryParser != null) {
                        ecogridQueryParser.parseXML();
                        queryType = ecogridQueryParser.getEcogridQuery();
                    } else {
                        System.err.println("EcogridQueryParser was null.");
                    }
                } else {
                    System.err.println("Couldn't create xmlReader.");
                }
            } else {
                System.err.println("Couldn't open file[" + string + "]");
            }
        }
        catch (Exception exception) {
            System.err.println("readEcogridXMLQuery exception: " + exception);
            exception.printStackTrace();
        }
        return queryType;
    }

    public EcogridQueryParser(Reader reader) throws Exception {
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
        NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/query");
        this._queryNode = nodeList.item(0);
    }

    public EcogridQueryParser(Node node) {
        this._queryNode = node;
    }

    public QueryType getEcogridQuery() {
        return this._ecogridQuery;
    }

    public void setEcogridQuery(QueryType queryType) {
        this._ecogridQuery = queryType;
    }

    public void parseXML() throws Exception {
        this.setupQueryIdAndSystem();
        this.setupNamespace();
        this.setupReturnField();
        this.setupTitle();
        this.setupFirstRelation();
    }

    private Node getAttrNode(String string, String string2) {
        Node node = this._queryNode;
        try {
            if (this._queryNode.getNodeType() == 9) {
                NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)string);
                node = nodeList.item(0);
            } else {
                NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)string2);
                node = nodeList.item(0);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return node;
    }

    private void setupQueryIdAndSystem() throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)QUERYIDATTRIBUTE);
        String string = nodeList.item(0).getNodeValue();
        this._ecogridQuery.setQueryId(string);
        NodeList nodeList2 = XPathAPI.selectNodeList((Node)this._queryNode, (String)SYSTEMATTRIBUTE);
        String string2 = nodeList2.item(0).getNodeValue();
        URI uRI = new URI(string2);
        this._ecogridQuery.setSystem(uRI);
    }

    private void setupNamespace() throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)NAMESPACE);
        int n = nodeList.getLength();
        if (n != 0) {
            Element element = (Element)nodeList.item(0);
            String string = element.getFirstChild().getNodeValue();
            QueryTypeNamespace queryTypeNamespace = new QueryTypeNamespace(string);
            String string2 = element.getAttribute(PREFIX);
            queryTypeNamespace.setPrefix(string2);
            this._ecogridQuery.setNamespace(queryTypeNamespace);
        }
    }

    private void setupReturnField() throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)RETURNFIELD);
        int n = nodeList.getLength();
        if (n != 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string;
                Node node = nodeList.item(i);
                stringArray[i] = string = node.getFirstChild().getNodeValue();
            }
            this._ecogridQuery.setReturnField(stringArray);
        }
    }

    private void setupTitle() throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)TITLE);
        int n = nodeList.getLength();
        if (n != 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string;
                Node node = nodeList.item(i);
                stringArray[i] = string = node.getFirstChild().getNodeValue();
            }
            this._ecogridQuery.setTitle(stringArray);
        }
    }

    private void setupFirstRelation() throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)this._queryNode, (String)"AND");
        NodeList nodeList2 = XPathAPI.selectNodeList((Node)this._queryNode, (String)"OR");
        NodeList nodeList3 = XPathAPI.selectNodeList((Node)this._queryNode, (String)"condition");
        int n = nodeList.getLength();
        int n2 = nodeList2.getLength();
        int n3 = nodeList3.getLength();
        if (n != 0 && n2 == 0 && n3 == 0) {
            ANDType aNDType = new ANDType();
            this.handleANDType(aNDType, nodeList.item(0));
            this._ecogridQuery.setAND(aNDType);
        } else if (n2 != 0 && n == 0 && n3 == 0) {
            ORType oRType = new ORType();
            this.handleORType(oRType, nodeList2.item(0));
            this._ecogridQuery.setOR(oRType);
        } else if (n3 != 0 && n2 == 0 && n == 0) {
            ConditionType conditionType = this.handleConditionType(nodeList3.item(0));
            this._ecogridQuery.setCondition(conditionType);
        } else {
            throw new Exception("Invalid ecogrid query!");
        }
    }

    private void handleANDType(ANDType aNDType, Node node) throws Exception {
        Object object;
        Object object2;
        int n;
        Serializable[] serializableArray;
        if (aNDType == null || node == null) {
            return;
        }
        NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)"AND");
        NodeList nodeList2 = XPathAPI.selectNodeList((Node)node, (String)"OR");
        NodeList nodeList3 = XPathAPI.selectNodeList((Node)node, (String)"condition");
        int n2 = nodeList.getLength();
        int n3 = nodeList2.getLength();
        int n4 = nodeList3.getLength();
        if (n2 != 0) {
            serializableArray = new ANDType[n2];
            for (n = 0; n < n2; ++n) {
                object2 = new ANDType();
                serializableArray[n] = object2;
                object = nodeList.item(n);
                this.handleANDType((ANDType)object2, (Node)object);
            }
            aNDType.setAND((ANDType[])serializableArray);
        }
        if (n3 != 0) {
            serializableArray = new ORType[n3];
            for (n = 0; n < n3; ++n) {
                serializableArray[n] = object2 = new ORType();
                object = nodeList2.item(n);
                this.handleORType((ORType)object2, (Node)object);
            }
            aNDType.setOR((ORType[])serializableArray);
        }
        if (n4 != 0) {
            serializableArray = new ConditionType[n4];
            for (n = 0; n < n4; ++n) {
                object2 = nodeList3.item(n);
                serializableArray[n] = object = this.handleConditionType((Node)object2);
            }
            aNDType.setCondition((ConditionType[])serializableArray);
        }
    }

    private void handleORType(ORType oRType, Node node) throws Exception {
        Object object;
        Object object2;
        int n;
        Serializable[] serializableArray;
        if (oRType == null || node == null) {
            return;
        }
        NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)"AND");
        NodeList nodeList2 = XPathAPI.selectNodeList((Node)node, (String)"OR");
        NodeList nodeList3 = XPathAPI.selectNodeList((Node)node, (String)"condition");
        int n2 = nodeList.getLength();
        int n3 = nodeList2.getLength();
        int n4 = nodeList3.getLength();
        if (n2 != 0) {
            serializableArray = new ANDType[n2];
            for (n = 0; n < n2; ++n) {
                object2 = new ANDType();
                serializableArray[n] = object2;
                object = nodeList.item(n);
                this.handleANDType((ANDType)object2, (Node)object);
            }
            oRType.setAND((ANDType[])serializableArray);
        }
        if (n3 != 0) {
            serializableArray = new ORType[n3];
            for (n = 0; n < n3; ++n) {
                serializableArray[n] = object2 = new ORType();
                object = nodeList2.item(n);
                this.handleORType((ORType)object2, (Node)object);
            }
            oRType.setOR((ORType[])serializableArray);
        }
        if (n4 != 0) {
            serializableArray = new ConditionType[n4];
            for (n = 0; n < n4; ++n) {
                object2 = nodeList3.item(n);
                serializableArray[n] = object = this.handleConditionType((Node)object2);
            }
            oRType.setCondition((ConditionType[])serializableArray);
        }
    }

    private ConditionType handleConditionType(Node node) throws Exception {
        String string;
        ConditionType conditionType = new ConditionType();
        Object var3_3 = null;
        Object var4_4 = null;
        OperatorType operatorType = null;
        String string2 = new String();
        if (node == null) {
            return conditionType;
        }
        Element element = (Element)node;
        String string3 = element.getAttribute(OPERATOR);
        operatorType = OperatorType.fromString(string3);
        string2 = string = element.getAttribute(CONCEPT);
        String string4 = element.getFirstChild().getNodeValue();
        conditionType.set_value(string4);
        conditionType.setOperator(operatorType);
        conditionType.setConcept(string2);
        return conditionType;
    }

    public static void main(String[] stringArray) {
        System.out.println("Processing file: " + stringArray[0]);
        QueryType queryType = EcogridQueryParser.readEcogridXMLQuery(stringArray[0]);
        System.out.println("Result: ");
        System.out.println(EcogridQueryTransformer.toXMLString(queryType));
    }
}

