/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.SimpleEntryImpl;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLDatabase;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptorEntry;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public abstract class SQLStore<V extends Identifiable>
extends SQLDatabase
implements Store<V> {
    protected Provider<V> identifiableProvider;
    protected MapConverter<V> converter;
    Table table;

    protected SQLStore(ConnectionPool connectionPool, Table table, Provider<V> identifiableProvider, MapConverter<V> converter) {
        super(connectionPool);
        this.table = table;
        this.identifiableProvider = identifiableProvider;
        this.converter = converter;
    }

    public SQLStore() {
    }

    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }

    public void update(V value) {
        if (!this.containsValue(value)) {
            throw new GeneralException("Error: cannot update non-existent entry for\"" + value.getIdentifierString() + "\". Register it first or call save.");
        }
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createUpdateStatement());
            ColumnMap map = this.depopulate(value);
            int i = 1;
            for (ColumnDescriptorEntry cde : this.getTable().getColumnDescriptor()) {
                if (cde.isPrimaryKey()) continue;
                Object obj = map.get(cde.getName());
                if (obj instanceof Date) {
                    obj = new Timestamp(((Date)obj).getTime());
                }
                if (obj instanceof BasicIdentifier) {
                    stmt.setString(i++, obj.toString());
                    continue;
                }
                stmt.setObject(i++, obj);
            }
            stmt.setString(i++, value.getIdentifierString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error updating approval with identifier = \"" + value.getIdentifierString(), (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public void populate(ColumnMap map, V t) {
        this.converter.fromMap(map, t);
    }

    public ColumnMap depopulate(V t) throws SQLException {
        ColumnMap map = new ColumnMap();
        this.converter.toMap(t, map);
        return map;
    }

    public void save(V value) {
        if (this.containsKey(value.getIdentifier())) {
            this.update(value);
        } else {
            this.register(value);
        }
    }

    public void register(V value) {
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createInsertStatement());
            ColumnMap map = this.depopulate(value);
            int i = 1;
            for (ColumnDescriptorEntry cde : this.getTable().getColumnDescriptor()) {
                stmt.setObject(i++, map.get(cde.getName()), cde.getType());
            }
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not register object with id \"" + value.getIdentifierString() + "\"", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public V get(Object o) {
        if (o == null) {
            throw new IllegalStateException("Error: a null identifier was supplied");
        }
        Identifier key = null;
        try {
            key = (Identifier)o;
        }
        catch (ClassCastException c) {
            throw new IllegalStateException("Error casting object of type \"" + o.getClass().getName() + "\" to an Identifier.\nThis is an implementation error", c);
        }
        Connection c = this.getConnection();
        V t = null;
        try {
            PreparedStatement stmt = c.prepareStatement("SELECT * from " + this.getTable().getFQTablename() + " where " + this.getTable().getPrimaryKeyColumnName() + " =?");
            stmt.setString(1, key.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                V v = null;
                return v;
            }
            ColumnMap map = this.rsToMap(rs);
            rs.close();
            stmt.close();
            t = this.create();
            this.populate(map, t);
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting object with identifier \"" + key + "\"", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return t;
    }

    protected ColumnMap rsToMap(ResultSet rs) throws SQLException {
        ColumnMap map = new ColumnMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        for (int i = 1; i <= numberOfColumns; ++i) {
            String colName = rsmd.getColumnName(i);
            Object obj = null;
            obj = rs.getObject(colName);
            map.put(colName, obj);
        }
        return map;
    }

    public Table getTable() {
        return this.table;
    }

    public int size() {
        return this.size(this.getTable().getFQTablename());
    }

    protected int size(String tablename) {
        String query = "SELECT COUNT(*)  from " + tablename;
        Connection c = this.getConnection();
        int rowCount = 0;
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting the size.", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return rowCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Connection c = this.getConnection();
        boolean rc = false;
        try {
            PreparedStatement stmt = c.prepareStatement("SELECT * FROM " + this.getTable().getFQTablename() + " WHERE " + this.getTable().getPrimaryKeyColumnName() + " =?");
            stmt.setString(1, key.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            rc = rs.next();
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            e.printStackTrace();
        }
        finally {
            this.releaseConnection(c);
        }
        return rc;
    }

    public boolean containsValue(Object o) {
        Identifiable foo;
        try {
            foo = (Identifiable)o;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.containsKey(foo.getIdentifier());
    }

    public V put(Identifier k, V v) {
        if (v.getIdentifier().equals(k)) {
            this.save(v);
        }
        return null;
    }

    public V remove(Object key) {
        V oldObject = null;
        try {
            oldObject = this.get(key);
        }
        catch (GeneralException x) {
            // empty catch block
        }
        String query = "DELETE FROM " + this.getTable().getFQTablename() + " WHERE " + this.getTable().getPrimaryKeyColumnName() + "=?";
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.setString(1, key.toString());
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting identity providers", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return oldObject;
    }

    public void putAll(Map<? extends Identifier, ? extends V> m) {
        for (Map.Entry<Identifier, V> e : m.entrySet()) {
            this.register((Identifiable)e.getValue());
        }
    }

    public void clear() {
        String query = "DELETE FROM " + this.getTable().getFQTablename();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting identity providers", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public Set<Identifier> keySet() {
        HashSet<Identifier> keys = new HashSet<Identifier>();
        String query = "Select " + this.getTable().getPrimaryKeyColumnName() + " from " + this.getTable().getFQTablename();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                keys.add((Identifier)new BasicIdentifier(rs.getString(1)));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting the user ids", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return keys;
    }

    public Collection<V> values() {
        ArrayList<V> allOfThem = new ArrayList<V>();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                V newOne = this.create();
                ColumnMap map = this.rsToMap(rs);
                this.populate(map, newOne);
                allOfThem.add(newOne);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return allOfThem;
    }

    public Set<Map.Entry<Identifier, V>> entrySet() {
        HashSet<Map.Entry<Identifier, V>> entries = new HashSet<Map.Entry<Identifier, V>>();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                V newOne = this.create();
                ColumnMap map = this.rsToMap(rs);
                this.populate(map, newOne);
                entries.add((Map.Entry<Identifier, V>)new SimpleEntryImpl((Object)newOne.getIdentifier(), newOne));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return entries;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[table=" + this.getTable() + "]";
    }
}

