/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v1.impl;

import java.net.URI;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.NodeLocator;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v1.CNode;
import org.dataone.client.v1.MNode;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeList;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.util.NodelistUtil;

public class NodeListNodeLocator
extends NodeLocator {
    protected NodeList nodeList;
    protected MultipartRestClient client;
    protected Deque<CNode> cnList;

    public NodeListNodeLocator(NodeList nl, MultipartRestClient mrc) throws ClientSideException {
        this.nodeList = nl;
        this.client = mrc;
        if (this.nodeList != null) {
            for (Node node : nl.getNodeList()) {
                if (node.getType().equals((Object)NodeType.MN)) {
                    super.putNode(node.getIdentifier(), D1NodeFactory.buildNode(MNode.class, this.client, URI.create(node.getBaseURL())));
                    continue;
                }
                if (!node.getType().equals((Object)NodeType.CN)) continue;
                super.putNode(node.getIdentifier(), D1NodeFactory.buildNode(CNode.class, this.client, URI.create(node.getBaseURL())));
            }
            this.initCnList();
        }
    }

    @Override
    public CNode getCNode() throws ClientSideException {
        if (this.cnList == null) {
            throw new ClientSideException("Error: The CnList has not been initialized!!!");
        }
        if (this.cnList.size() == 1) {
            return this.cnList.getLast();
        }
        if (this.cnList.size() == 0) {
            throw new ClientSideException("No CNs are registered in the NodeLocator");
        }
        CNode nextCN = this.cnList.removeFirst();
        this.cnList.addLast(nextCN);
        return nextCN;
    }

    public void initCnList() throws ClientSideException {
        if (this.nodeList != null) {
            Set cnSet = NodelistUtil.selectNodes((NodeList)this.nodeList, (NodeType)NodeType.CN);
            Node rrCN = null;
            for (Node cn : cnSet) {
                if (cn.getDescription() == null || !cn.getDescription().contains("Robin") && !cn.getDescription().contains("robin")) continue;
                rrCN = cn;
                break;
            }
            if (rrCN != null) {
                this.cnList = new LinkedList<CNode>();
                CNode rrCNode = D1NodeFactory.buildNode(CNode.class, this.client, URI.create(rrCN.getBaseURL()));
                rrCNode.setNodeId(rrCN.getIdentifier());
                this.cnList.add(rrCNode);
            } else {
                this.cnList = new LinkedList<CNode>();
                for (Node n : cnSet) {
                    CNode cNode = D1NodeFactory.buildNode(CNode.class, this.client, URI.create(n.getBaseURL()));
                    cNode.setNodeId(n.getIdentifier());
                    this.cnList.add(cNode);
                }
            }
        }
    }
}

