/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.formats;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.types.v2.util.ObjectFormatServiceImpl;

public class ObjectFormatCache
extends ObjectFormatServiceImpl {
    private static Logger logger = Logger.getLogger((String)ObjectFormatCache.class.getName());
    private static ObjectFormatCache objectFormatCache;
    public static boolean usingFallbackFormatList;
    protected static int throttleIntervalSec;
    protected Date lastRefreshDate;

    private ObjectFormatCache() throws ServiceFailure {
        throttleIntervalSec = Settings.getConfiguration().getInt("ObjectFormatCache.minimum.refresh.interval.seconds", throttleIntervalSec);
        try {
            this.refreshCache();
        }
        catch (ServiceFailure e) {
            logger.warn((Object)("Failed to get current ObjectFormatList from the CN, using fallbacklist provided with libclient. Cause = ServiceFailure::" + e.getDetail_code() + ": " + e.getDescription()));
        }
        catch (NotImplemented e) {
            logger.warn((Object)("Failed to get current ObjectFormatList from the CN, using fallbacklist provided with libclient. Cause = NotImplemented::" + e.getDetail_code() + ": " + e.getDescription()));
        }
    }

    public static synchronized ObjectFormatCache getInstance() throws ServiceFailure {
        if (objectFormatCache == null) {
            objectFormatCache = new ObjectFormatCache();
        }
        return objectFormatCache;
    }

    public ObjectFormatList listFormats() {
        if (usingFallbackFormatList) {
            try {
                this.refreshCache();
            }
            catch (ServiceFailure serviceFailure) {
            }
            catch (NotImplemented notImplemented) {
                // empty catch block
            }
        }
        return this.objectFormatList;
    }

    public int getMinimalRefreshInterval() {
        return throttleIntervalSec;
    }

    public Date getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    public boolean isUsingFallbackFormatList() {
        return usingFallbackFormatList;
    }

    protected synchronized void refreshCache() throws ServiceFailure, NotImplemented {
        Date now = new Date();
        ObjectFormatList objectFormatList = null;
        if (usingFallbackFormatList || this.lastRefreshDate == null || now.getTime() - this.lastRefreshDate.getTime() > (long)(throttleIntervalSec * 1000)) {
            CNode cn = null;
            String cnUrl = Settings.getConfiguration().getString("ObjectFormatCache.overriding.CN_URL");
            if (StringUtils.isBlank((String)cnUrl)) {
                cnUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
            }
            if (StringUtils.isNotBlank((String)cnUrl)) {
                cn = D1Client.getCN(cnUrl);
                logger.info((Object)("refreshing objectFormatCache from cn: " + cn.getNodeId()));
                objectFormatList = cn.listFormats();
                this.lastRefreshDate = new Date();
                for (ObjectFormat objectFormat : objectFormatList.getObjectFormatList()) {
                    this.getObjectFormatMap().put(objectFormat.getFormatId(), objectFormat);
                }
                usingFallbackFormatList = false;
                logger.info((Object)"successful cache refresh from cn.listFormats()");
            }
        }
    }

    @Deprecated
    public ObjectFormat getFormat(String fmtidStr) throws NotFound {
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(fmtidStr);
        return this.getFormat(formatId);
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatId) throws NotFound {
        ObjectFormat objectFormat;
        ObjectFormat objectFormat2 = objectFormat = usingFallbackFormatList ? null : this.getObjectFormatMap().get(formatId);
        if (objectFormat == null) {
            try {
                this.refreshCache();
            }
            catch (ServiceFailure serviceFailure) {
            }
            catch (NotImplemented notImplemented) {
                // empty catch block
            }
            objectFormat = this.getObjectFormatMap().get(formatId);
        }
        if (objectFormat == null) {
            throw new NotFound("0000", "The format specified by " + formatId.getValue() + " was not found after refreshing the cache.");
        }
        return objectFormat;
    }

    protected HashMap<ObjectFormatIdentifier, ObjectFormat> getObjectFormatMap() {
        return this.objectFormatMap;
    }

    static {
        usingFallbackFormatList = true;
        throttleIntervalSec = 20;
    }
}

