/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static int DOES_NOT_EXIST = 0;
    public static int EXISTS_ONLY = 1;
    public static int EXISTS_READABLE = 2;
    public static int EXISTS_READ_WRITABLE = 3;
    private static Character FILE_SEPARATOR = null;

    private FileUtil() {
    }

    public static char getFS() {
        if (FILE_SEPARATOR == null) {
            FILE_SEPARATOR = Character.valueOf(File.separatorChar);
        }
        return FILE_SEPARATOR.charValue();
    }

    public static int getFileStatus(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.canRead()) {
                if (file.canWrite()) {
                    return EXISTS_READ_WRITABLE;
                }
                return EXISTS_READABLE;
            }
            return EXISTS_ONLY;
        }
        return DOES_NOT_EXIST;
    }

    public static boolean createDirectory(String dirPath) throws IOException {
        File file = new File(dirPath);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean createFile(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceInFile(String filePath, Hashtable<String, String> replacementList) throws IOException {
        if (FileUtil.getFileStatus(filePath) < EXISTS_READ_WRITABLE) {
            throw new IOException("File: " + filePath + " is not writeable.");
        }
        Vector<String> fileLines = new Vector<String>();
        FileInputStream fin = null;
        try {
            String fileLine;
            fin = new FileInputStream(filePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
            while ((fileLine = reader.readLine()) != null) {
                Enumeration<String> enumer = replacementList.keys();
                while (enumer.hasMoreElements()) {
                    String newLine;
                    String oldValue = enumer.nextElement();
                    String newValue = replacementList.get(oldValue);
                    fileLine = newLine = fileLine.replace(oldValue, newValue);
                }
                fileLines.add(fileLine);
            }
        }
        finally {
            fin.close();
        }
        PrintWriter output = null;
        try {
            output = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            Iterator iter = fileLines.iterator();
            while (iter.hasNext()) {
                output.println((String)iter.next());
            }
        }
        finally {
            output.close();
        }
        return true;
    }
}

