/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyExistsException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedProperties {
    private String propertiesDirName = null;
    private String propertiesFileName = null;
    private LinkedHashMap<String, String> allLinesMap = null;
    private LinkedHashMap<String, String> propertiesMap = null;
    private static String IS_PROPERTY = "true";
    private static String IS_NOT_PROPERTY = "false";
    private static String SPACE = "space";
    private static String COMMENT = "#";
    private static String UNKNOWN = "???";
    private int nonPropertyCount = 0;

    public SortedProperties(String propFileName) {
        File propFile = new File(propFileName);
        this.propertiesFileName = propFileName;
        this.propertiesDirName = propFile.getParent();
        this.allLinesMap = new LinkedHashMap();
        this.propertiesMap = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() throws IOException {
        if (FileUtil.getFileStatus(this.propertiesFileName) < FileUtil.EXISTS_READABLE) {
            return false;
        }
        FileInputStream fin = null;
        try {
            String fileLine;
            fin = new FileInputStream(this.propertiesFileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
            while ((fileLine = reader.readLine()) != null) {
                String[] parsedLine = this.parseLine(fileLine);
                this.allLinesMap.put(parsedLine[0], parsedLine[1]);
                if (!parsedLine[2].equals("true")) continue;
                this.propertiesMap.put(parsedLine[0], parsedLine[1]);
            }
        }
        finally {
            fin.close();
        }
        return true;
    }

    private String[] parseLine(String rawLine) {
        String line = rawLine.trim();
        String[] parsedString = new String[3];
        if (line.matches("^#.*")) {
            ++this.nonPropertyCount;
            parsedString[0] = COMMENT + this.nonPropertyCount;
            parsedString[1] = line;
            parsedString[2] = IS_NOT_PROPERTY;
        } else if (line.matches("^$")) {
            ++this.nonPropertyCount;
            parsedString[0] = SPACE + this.nonPropertyCount;
            parsedString[1] = "";
            parsedString[2] = IS_NOT_PROPERTY;
        } else {
            int equalIndex = line.indexOf(61);
            if (equalIndex != -1) {
                if (equalIndex == 0) {
                    ++this.nonPropertyCount;
                    parsedString[0] = UNKNOWN + this.nonPropertyCount;
                    parsedString[1] = line;
                    parsedString[2] = IS_NOT_PROPERTY;
                } else if (equalIndex == line.length()) {
                    parsedString[0] = line.substring(0, equalIndex);
                    parsedString[1] = "";
                    parsedString[2] = IS_PROPERTY;
                } else {
                    parsedString[0] = line.substring(0, equalIndex);
                    parsedString[1] = line.substring(equalIndex + 1);
                    parsedString[2] = IS_PROPERTY;
                }
            } else {
                ++this.nonPropertyCount;
                parsedString[0] = UNKNOWN + this.nonPropertyCount;
                parsedString[1] = line;
                parsedString[2] = IS_NOT_PROPERTY;
            }
        }
        return parsedString;
    }

    public synchronized void setProperty(String key, String value) throws GeneralPropertyException {
        if (!this.propertiesMap.containsKey(key)) {
            throw new PropertyNotFoundException("Property: " + key + " could not be updated to: " + value + " because it does not already exist in properties.");
        }
        this.allLinesMap.put(key, value);
        this.propertiesMap.put(key, value);
        this.store();
    }

    public synchronized void setPropertyNoPersist(String key, String value) throws PropertyNotFoundException {
        if (!this.propertiesMap.containsKey(key)) {
            throw new PropertyNotFoundException("Property: " + key + " could not be updated to: " + value + " because it does not already exist in properties.");
        }
        this.allLinesMap.put(key, value);
        this.propertiesMap.put(key, value);
    }

    public synchronized void addProperty(String key, String value) throws GeneralPropertyException {
        if (this.propertiesMap.containsKey(key)) {
            throw new PropertyExistsException("Property: " + key + " could not be added with value: " + value + " because it already exists in properties.");
        }
        this.allLinesMap.put(key, value);
        this.propertiesMap.put(key, value);
        this.store();
    }

    public synchronized void addPropertyNoPersist(String key, String value) throws PropertyExistsException {
        if (this.propertiesMap.containsKey(key)) {
            throw new PropertyExistsException("Property: " + key + " could not be added with value: " + value + " because it already exists in properties.");
        }
        this.allLinesMap.put(key, value);
        this.propertiesMap.put(key, value);
    }

    public synchronized String getProperty(String key) throws PropertyNotFoundException {
        String value = this.propertiesMap.get(key);
        if (value == null && !this.propertiesMap.containsKey(key)) {
            throw new PropertyNotFoundException("Could not find property: " + key);
        }
        return value;
    }

    public synchronized LinkedHashMap<String, String> getProperties() throws PropertyNotFoundException {
        return this.propertiesMap;
    }

    public Vector<String> getPropertyNames() {
        Vector<String> groupKeySet = new Vector<String>();
        Set<String> keySet = this.propertiesMap.keySet();
        for (String key : keySet) {
            groupKeySet.add(key);
        }
        return groupKeySet;
    }

    public Vector<String> getPropertyNamesByGroup(String groupName) {
        if (!(groupName = groupName.trim()).endsWith(".")) {
            groupName = groupName + ".";
        }
        Set<String> keySet = this.propertiesMap.keySet();
        Vector<String> groupKeySet = new Vector<String>();
        for (String key : keySet) {
            if (!key.startsWith(groupName)) continue;
            groupKeySet.add(key);
        }
        return groupKeySet;
    }

    public HashMap<String, String> getPropertiesByGroup(String groupName) throws PropertyNotFoundException {
        HashMap<String, String> groupPropertyMap = new HashMap<String, String>();
        Vector<String> groupKeySet = this.getPropertyNamesByGroup(groupName);
        for (String key : groupKeySet) {
            groupPropertyMap.put(key, this.getProperty(key));
        }
        return groupPropertyMap;
    }

    public synchronized void store() throws GeneralPropertyException {
        int fileStatus = FileUtil.getFileStatus(this.propertiesFileName);
        PrintWriter output = null;
        try {
            if (fileStatus == FileUtil.DOES_NOT_EXIST) {
                int dirStatus = FileUtil.getFileStatus(this.propertiesDirName);
                if (dirStatus == FileUtil.DOES_NOT_EXIST) {
                    throw new IOException("Could not write property file. Directory: " + this.propertiesDirName + " not found.");
                }
                if (dirStatus < FileUtil.EXISTS_READ_WRITABLE) {
                    throw new IOException("Could not write property file. Directory: " + this.propertiesDirName + " is not writable.");
                }
            } else if (fileStatus < FileUtil.EXISTS_READ_WRITABLE) {
                throw new IOException("Could not write property file. File: " + this.propertiesFileName + " is not writable.");
            }
            output = new PrintWriter(new BufferedWriter(new FileWriter(this.propertiesFileName)));
            for (String key : this.allLinesMap.keySet()) {
                if (key.startsWith(SPACE)) {
                    output.println("");
                    continue;
                }
                if (key.startsWith(COMMENT) || key.startsWith(UNKNOWN)) {
                    output.println(this.allLinesMap.get(key));
                    continue;
                }
                output.println(key + "=" + this.allLinesMap.get(key));
            }
        }
        catch (IOException ioe) {
            throw new GeneralPropertyException("Could not save properties: " + ioe.getMessage());
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }
}

