/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.DBSAXHandler;
import edu.ucsb.nceas.metacat.DBSAXNode;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DistributionSection;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.SchemaLocationResolver;
import edu.ucsb.nceas.metacat.SubTree;
import edu.ucsb.nceas.metacat.accesscontrol.AccessRule;
import edu.ucsb.nceas.metacat.accesscontrol.AccessSection;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.AccessControlInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Eml210SAXHandler
extends DBSAXHandler
implements AccessControlInterface {
    private boolean processingTopLevelAccess = false;
    private boolean processingAdditionalAccess = false;
    private boolean processingOtherAccess = false;
    private AccessSection accessObject = null;
    private AccessRule accessRule = null;
    private Vector<AccessSection> accessObjectList = new Vector();
    private Hashtable<String, AccessSection> topLevelAccessControlMap = new Hashtable();
    private Hashtable<String, AccessSection> additionalAccessControlMap = new Hashtable();
    private Vector<Hashtable<String, AccessSection>> additionalAccessMapList = new Vector();
    private Vector<String> describesId = new Vector();
    private Stack<SubTree> subTreeInfoStack = new Stack();
    private Vector<SubTree> subTreeList = new Vector();
    private boolean needToCheckAccessModule = false;
    private Vector<AccessSection> unChangeableAccessSubTreeVector = new Vector();
    private Stack<NodeRecord> currentUnchangeableAccessModuleNodeStack = new Stack();
    private AccessSection topAccessSection;
    private Stack<NodeRecord> storedAccessNodeStack = new Stack();
    private Vector<String> onlineDataFileIdInRelationVector = new Vector();
    private Vector<String> onlineDataFileIdInTopAccessVector = new Vector();
    private boolean handleInlineData = false;
    private Hashtable<String, String> inlineDataNameSpace = null;
    private Writer inlineDataFileWriter = null;
    private String inlineDataFileName = null;
    DistributionSection currentDistributionSection = null;
    Vector<DistributionSection> allDistributionSections = new Vector();
    private Vector<String> guidsToSync;
    private int distributionIndex = 0;
    private Vector<String> inlineFileIdList = new Vector();
    private static final String EML = "eml";
    private static final String DISTRIBUTION = "distribution";
    private static final String ORDER = "order";
    private static final String ID = "id";
    private static final String REFERENCES = "references";
    public static final String INLINE = "inline";
    private static final String ONLINE = "online";
    private static final String URL = "url";
    private static final String UPDATEACCESSERROR = "User tried to update an access module when they don't have \"ALL\" permission!";
    private static final String TOPLEVEL = "top";
    private static final String SUBTREELEVEL = "subtree";
    private static final String RELATION = "Provides info for";
    private Logger logMetacat = Logger.getLogger(Eml210SAXHandler.class);

    public Eml210SAXHandler(DBConnection conn, String action, String docid, String revision, String user, String[] groups, String pub, int serverCode, Date createDate, Date updateDate, boolean writeAccessRules, Vector<String> guidsToSync) throws SAXException {
        super(conn, action, docid, revision, user, groups, pub, serverCode, createDate, updateDate, writeAccessRules);
        this.guidsToSync = guidsToSync;
        try {
            if (action.equals("UPDATE")) {
                int latestRevision = DBUtil.getLatestRevisionInDocumentTable(docid);
                String previousDocid = docid + PropertyService.getProperty("document.accNumSeparator") + latestRevision;
                PermissionController control = new PermissionController(previousDocid);
                if (!control.hasPermission(user, groups, "ALL") && action != null) {
                    this.needToCheckAccessModule = true;
                    this.unChangeableAccessSubTreeVector = this.getAccessSubTreeListFromDB();
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private Vector<AccessSection> getAccessSubTreeListFromDB() throws Exception {
        Vector<AccessSection> result = new Vector<AccessSection>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT controllevel, subtreeid, startnodeid, endnodeid FROM xml_accesssubtree WHERE docid like ? ORDER BY startnodeid ASC";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, this.docid);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String level = rs.getString(1);
                String sectionId = rs.getString(2);
                long startNodeId = rs.getLong(3);
                long endNodeId = rs.getLong(4);
                AccessSection accessObj = new AccessSection();
                accessObj.setControlLevel(level);
                accessObj.setDocId(this.docid);
                accessObj.setSubTreeId(sectionId);
                accessObj.setStartNodeId(startNodeId);
                accessObj.setEndNodeId(endNodeId);
                Stack<NodeRecord> nodeStack = accessObj.getSubTreeNodeStack();
                accessObj.setSubTreeNodeStack(nodeStack);
                result.add(accessObj);
                if (level == null || !level.equals(TOPLEVEL)) continue;
                this.topAccessSection = accessObj;
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.getAccessSubTreeListFromDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.getAccessSubTreeListFromDB(): " + ee.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.logMetacat.debug((Object)("Start ELEMENT(qName) " + qName));
        this.logMetacat.debug((Object)("Start ELEMENT(localName) " + localName));
        this.logMetacat.debug((Object)("Start ELEMENT(uri) " + uri));
        DBSAXNode parentNode = null;
        DBSAXNode currentNode = null;
        if (!this.handleInlineData) {
            try {
                parentNode = (DBSAXNode)this.nodeStack.peek();
            }
            catch (EmptyStackException e) {
                parentNode = null;
            }
            if (localName.equals(INLINE)) {
                this.handleInlineData = true;
                this.inlineDataNameSpace = new Hashtable();
                String docidWithoutRev = DocumentUtil.getDocIdFromString(this.docid);
                String seperator = ".";
                try {
                    seperator = PropertyService.getProperty("document.accNumSeparator");
                }
                catch (PropertyNotFoundException pnfe) {
                    this.logMetacat.error((Object)("Could not fing property 'accNumSeparator'. Setting separator to '.': " + pnfe.getMessage()));
                }
                this.inlineDataFileName = docidWithoutRev + seperator + this.revision + seperator + this.distributionIndex;
                this.inlineDataFileWriter = this.createInlineDataFileWriter(this.inlineDataFileName, this.encoding);
                this.inlineFileIdList.add(this.inlineDataFileName);
                this.currentDistributionSection.setDistributionType(3);
                this.currentDistributionSection.setDataFileName(this.inlineDataFileName);
            }
            if (this.hitTextNode && parentNode != null) {
                if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                    this.compareAccessTextNode(this.currentUnchangeableAccessModuleNodeStack, this.textBuffer);
                }
                if (this.needToCheckAccessModule && (this.processingAdditionalAccess || this.processingOtherAccess || this.processingTopLevelAccess)) {
                    NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(this.textBuffer.toString()));
                    this.storedAccessNodeStack.push(nodeElement);
                }
                this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, parentNode);
                this.hitTextNode = false;
                this.textBuffer = null;
                this.textBuffer = new StringBuffer();
            }
            if (this.atFirstElement) {
                this.atFirstElement = false;
                if (this.docname == null) {
                    this.docname = localName;
                    this.doctype = uri != null && !uri.trim().equals("") ? uri : this.docname;
                    this.logMetacat.debug((Object)("DOCNAME-a: " + this.docname));
                    this.logMetacat.debug((Object)("DOCTYPE-a: " + this.doctype));
                } else if (this.doctype == null) {
                    this.doctype = this.docname;
                    this.logMetacat.debug((Object)("DOCTYPE-b: " + this.doctype));
                }
                this.rootNode.writeNodename(this.docname);
                try {
                    DBConnection dbConn = null;
                    int serialNumber = -1;
                    try {
                        dbConn = DBConnectionPool.getDBConnection("DBSAXHandler.startElement");
                        serialNumber = dbConn.getCheckOutSerialNumber();
                        String sql = "SELECT catalog_id FROM xml_catalog WHERE entry_type = 'Schema' AND public_id = ?";
                        PreparedStatement pstmt = dbConn.prepareStatement(sql);
                        pstmt.setString(1, this.doctype);
                        ResultSet rs = pstmt.executeQuery();
                        boolean hasRow = rs.next();
                        if (hasRow) {
                            this.catalogid = rs.getString(1);
                        }
                        pstmt.close();
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    if (!super.getIsRevisionDoc()) {
                        this.currentDocument = new DocumentImpl(this.connection, this.rootNode.getNodeID(), this.docname, this.doctype, this.docid, this.revision, this.action, this.user, this.pub, this.catalogid, this.serverCode, this.createDate, this.updateDate);
                    }
                }
                catch (McdbDocNotFoundException mdnfe) {
                    Vector<Integer> revList = null;
                    try {
                        revList = DBUtil.getRevListFromRevisionTable(this.docid);
                    }
                    catch (SQLException sqle) {
                        this.logMetacat.error((Object)("SQL error when trying to get rev list for doc " + this.docid + " : " + sqle.getMessage()));
                        throw new SAXException("Doc ID " + this.docid + " was not found and cannot be updated.");
                    }
                    if (revList.size() > 0) {
                        throw new SAXException("EML210SaxHandler.startElement - Doc ID " + this.docid + " was deleted and cannot be updated.");
                    }
                    throw new SAXException("EML210SaxHandler.startElement - Doc ID " + this.docid + " was not found and cannot be updated.");
                }
                catch (Exception e) {
                    throw new SAXException("EML210SaxHandler.startElement - error with action " + this.action + " : " + e.getMessage());
                }
            }
            currentNode = new DBSAXNode(this.connection, qName, localName, parentNode, this.rootNode.getNodeID(), this.docid, this.doctype);
            long startNodeId = currentNode.getNodeID();
            String prefix = null;
            String nsuri = null;
            Enumeration prefixes = this.namespaces.keys();
            while (prefixes.hasMoreElements()) {
                prefix = (String)prefixes.nextElement();
                nsuri = (String)this.namespaces.get(prefix);
                this.endNodeId = currentNode.setNamespace(prefix, nsuri, this.docid);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeName = atts.getQName(i);
                String attributeValue = atts.getValue(i);
                this.endNodeId = currentNode.setAttribute(attributeName, attributeValue, this.docid);
                if (attributeName != null && attributeName.indexOf(":schemaLocation") != -1) {
                    SchemaLocationResolver resolver = new SchemaLocationResolver(attributeValue);
                    resolver.resolveNameSpace();
                    continue;
                }
                if (attributeName != null && !attributeName.equals(ID)) continue;
            }
            if (localName.equals("access")) {
                if (parentNode.getTagName().equals(EML)) {
                    this.processingTopLevelAccess = true;
                } else if (parentNode.getTagName() == DISTRIBUTION) {
                    this.processingAdditionalAccess = true;
                } else {
                    this.processingOtherAccess = true;
                }
                this.accessObject = new AccessSection();
                String permOrder = currentNode.getAttribute(ORDER);
                this.accessObject.setPermissionOrder(permOrder);
                String accessId = currentNode.getAttribute(ID);
                this.accessObject.setSubTreeId(accessId);
                this.accessObject.setStartNodeId(startNodeId);
                this.accessObject.setDocId(this.docid);
                if (this.processingAdditionalAccess) {
                    this.accessObject.setDataFileName(this.inlineDataFileName);
                }
                if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                    this.currentUnchangeableAccessModuleNodeStack = this.topAccessSection.getSubTreeNodeStack();
                }
            } else if (localName.equals(DISTRIBUTION)) {
                ++this.distributionIndex;
                this.currentDistributionSection = new DistributionSection(this.distributionIndex);
                SubTree subTree = new SubTree();
                subTree.setSubTreeId(String.valueOf(this.distributionIndex));
                subTree.setStartElementName(currentNode.getTagName());
                subTree.setStartNodeId(startNodeId);
                this.subTreeInfoStack.push(subTree);
            } else if (parentNode.getTagName() != null && parentNode.getTagName().equals("access") && localName.equals("allow")) {
                this.accessRule = new AccessRule();
                this.accessRule.setPermissionType("allow");
            } else if (parentNode.getTagName() != null && parentNode.getTagName().equals("access") && localName.equals("deny")) {
                this.accessRule = new AccessRule();
                this.accessRule.setPermissionType("deny");
            }
            this.nodeStack.push(currentNode);
            this.nodeIndex.addElement(currentNode);
            if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                this.compareElementNameSpaceAttributes(this.currentUnchangeableAccessModuleNodeStack, this.namespaces, atts, localName, UPDATEACCESSERROR);
            }
            if (this.needToCheckAccessModule && (this.processingAdditionalAccess || this.processingOtherAccess || this.processingTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "ELEMENT", localName, prefix, MetacatUtil.normalize(null));
                this.storedAccessNodeStack.push(nodeElement);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attributeName = atts.getQName(i);
                    String attributeValue = atts.getValue(i);
                    NodeRecord nodeAttribute = new NodeRecord(-2L, -2L, -2L, "ATTRIBUTE", attributeName, null, MetacatUtil.normalize(attributeValue));
                    this.storedAccessNodeStack.push(nodeAttribute);
                }
            }
            this.namespaces = null;
            this.namespaces = new Hashtable();
        } else {
            StringBuffer inlineElements = new StringBuffer();
            inlineElements.append("<").append(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeName = atts.getQName(i);
                String attributeValue = atts.getValue(i);
                inlineElements.append(" ");
                inlineElements.append(attributeName);
                inlineElements.append("=\"");
                inlineElements.append(attributeValue);
                inlineElements.append("\"");
            }
            String prefix = null;
            String nsuri = null;
            Enumeration<String> prefixes = this.inlineDataNameSpace.keys();
            while (prefixes.hasMoreElements()) {
                prefix = prefixes.nextElement();
                nsuri = (String)this.namespaces.get(prefix);
                inlineElements.append(" ");
                inlineElements.append("xmlns:");
                inlineElements.append(prefix);
                inlineElements.append("=\"");
                inlineElements.append(nsuri);
                inlineElements.append("\"");
            }
            inlineElements.append(">");
            this.inlineDataNameSpace = null;
            this.inlineDataNameSpace = new Hashtable();
            this.logMetacat.debug((Object)("the inline element data is: " + inlineElements.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineElements);
        }
    }

    private void compareElementNameSpaceAttributes(Stack<NodeRecord> unchangeableNodeStack, Hashtable<String, String> nameSpaces, Attributes attributes, String localName, String error) throws SAXException {
        NodeRecord elementNode = null;
        try {
            elementNode = unchangeableNodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"Node stack is empty for element data");
            throw new SAXException(error);
        }
        this.logMetacat.debug((Object)"current node type from xml is ELEMENT");
        this.logMetacat.debug((Object)("node type from stack: " + elementNode.getNodeType()));
        this.logMetacat.debug((Object)("node name from xml document: " + localName));
        this.logMetacat.debug((Object)("node name from stack: " + elementNode.getNodeName()));
        this.logMetacat.debug((Object)("node data from stack: " + elementNode.getNodeData()));
        this.logMetacat.debug((Object)("node id is: " + elementNode.getNodeId()));
        if (!elementNode.getNodeType().equals("ELEMENT") || !localName.equals(elementNode.getNodeName())) {
            this.logMetacat.error((Object)"Inconsistence happened: ");
            this.logMetacat.error((Object)"current node type from xml is ELEMENT");
            this.logMetacat.error((Object)("node type from stack: " + elementNode.getNodeType()));
            this.logMetacat.error((Object)("node name from xml document: " + localName));
            this.logMetacat.error((Object)("node name from stack: " + elementNode.getNodeName()));
            this.logMetacat.error((Object)("node data from stack: " + elementNode.getNodeData()));
            this.logMetacat.error((Object)("node id is: " + elementNode.getNodeId()));
            throw new SAXException(error);
        }
        Enumeration<String> nameEn = nameSpaces.keys();
        while (nameEn.hasMoreElements()) {
            NodeRecord nameNode = null;
            try {
                nameNode = unchangeableNodeStack.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack is empty for namespace data");
                throw new SAXException(error);
            }
            String prefixName = nameEn.nextElement();
            String nameSpaceUri = nameSpaces.get(prefixName);
            if (nameNode.getNodeType().equals("NAMESPACE") && prefixName.equals(nameNode.getNodeName()) && nameSpaceUri.equals(nameNode.getNodeData())) continue;
            this.logMetacat.error((Object)"Inconsistence happened: ");
            this.logMetacat.error((Object)"current node type from xml is NAMESPACE");
            this.logMetacat.error((Object)("node type from stack: " + nameNode.getNodeType()));
            this.logMetacat.error((Object)("current node name from xml is: " + prefixName));
            this.logMetacat.error((Object)("node name from stack: " + nameNode.getNodeName()));
            this.logMetacat.error((Object)("current node data from xml is: " + nameSpaceUri));
            this.logMetacat.error((Object)("node data from stack: " + nameNode.getNodeData()));
            this.logMetacat.error((Object)("node id is: " + nameNode.getNodeId()));
            throw new SAXException(error);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            NodeRecord attriNode = null;
            try {
                attriNode = unchangeableNodeStack.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack is empty for attribute data");
                throw new SAXException(error);
            }
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            this.logMetacat.debug((Object)"current node type from xml is ATTRIBUTE ");
            this.logMetacat.debug((Object)("node type from stack: " + attriNode.getNodeType()));
            this.logMetacat.debug((Object)("current node name from xml is: " + attributeName));
            this.logMetacat.debug((Object)("node name from stack: " + attriNode.getNodeName()));
            this.logMetacat.debug((Object)("current node data from xml is: " + attributeValue));
            this.logMetacat.debug((Object)("node data from stack: " + attriNode.getNodeData()));
            this.logMetacat.debug((Object)("node id  is: " + attriNode.getNodeId()));
            if (attriNode.getNodeType().equals("ATTRIBUTE") && attributeName.equals(attriNode.getNodeName()) && attributeValue.equals(attriNode.getNodeData())) continue;
            this.logMetacat.error((Object)"Inconsistence happened: ");
            this.logMetacat.error((Object)"current node type from xml is ATTRIBUTE ");
            this.logMetacat.error((Object)("node type from stack: " + attriNode.getNodeType()));
            this.logMetacat.error((Object)("current node name from xml is: " + attributeName));
            this.logMetacat.error((Object)("node name from stack: " + attriNode.getNodeName()));
            this.logMetacat.error((Object)("current node data from xml is: " + attributeValue));
            this.logMetacat.error((Object)("node data from stack: " + attriNode.getNodeData()));
            this.logMetacat.error((Object)("node is: " + attriNode.getNodeId()));
            throw new SAXException(error);
        }
    }

    private void compareAccessTextNode(Stack<NodeRecord> nodeStack, StringBuffer text) throws SAXException {
        NodeRecord node = null;
        try {
            node = nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)("Node stack is empty for text data in startElement for doc id " + this.docid));
            throw new SAXException("Access rules could not be found in database.");
        }
        String dbAccessData = node.getNodeData();
        String docAccessData = text.toString().trim();
        this.logMetacat.debug((Object)("Eml210SAXHandler.compareAccessTextNode - \n\t access node type from db:       " + node.getNodeType() + "\n" + "\t access node data from db:       " + node.getNodeData() + "\n" + "\t access node data from document: " + text.toString()));
        if (!node.getNodeType().equals("TEXT") || !docAccessData.equals(dbAccessData)) {
            this.logMetacat.warn((Object)("Eml210SAXHandler.compareAccessTextNode - Access record mismatch: \n\t access node type from db:       " + node.getNodeType() + "\n" + "\t access node data from db:       " + dbAccessData + "\n" + "\t access node data from document: " + docAccessData));
            throw new SAXException("User tried to update an access module when they don't have \"ALL\" permission! [Eml210SAXHandler.compareAccessTextNode]");
        }
    }

    @Override
    public void characters(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.debug((Object)"CHARACTERS");
        if (!this.handleInlineData) {
            this.textBuffer.append(new String(cbuf, start, len));
            this.hitTextNode = true;
            if (this.textBuffer.length() > 4000) {
                this.logMetacat.debug((Object)"Write text into DB in charaters when text buffer size is greater than maxmum number");
                DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
                this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
                this.textBuffer = null;
                this.textBuffer = new StringBuffer();
            }
        } else {
            StringBuffer inlineText = new StringBuffer();
            inlineText.append(new String(cbuf, start, len));
            this.logMetacat.debug((Object)("The inline text data write into file system: " + inlineText.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineText);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.logMetacat.debug((Object)("End ELEMENT " + qName));
        if (localName.equals(INLINE) && this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.pop();
            this.logMetacat.debug((Object)"End of inline data");
            try {
                this.inlineDataFileWriter.close();
                this.handleInlineData = false;
            }
            catch (IOException ioe) {
                throw new SAXException(ioe.getMessage());
            }
            this.textBuffer = new StringBuffer(this.inlineDataFileName);
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            this.textBuffer = null;
            this.textBuffer = new StringBuffer();
            return;
        }
        if (!this.handleInlineData) {
            SubTree tree;
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.pop();
            String currentTag = currentNode.getTagName();
            if (this.hitTextNode) {
                DBSAXNode parentNode;
                String data = null;
                if (currentTag.equals("principal") && this.accessRule != null) {
                    data = this.textBuffer.toString().trim();
                    this.accessRule.addPrincipal(data);
                } else if (currentTag.equals("permission") && this.accessRule != null) {
                    data = this.textBuffer.toString().trim();
                    int permission = this.accessRule.getPermission();
                    if (data.toUpperCase().equals("READ")) {
                        permission |= 4;
                    } else if (data.toUpperCase().equals("WRITE")) {
                        permission |= 2;
                    } else if (data.toUpperCase().equals("CHANGEPERMISSION")) {
                        permission |= 1;
                    } else if (data.toUpperCase().equals("ALL")) {
                        permission |= 7;
                    }
                    this.accessRule.setPermission(permission);
                } else if (currentTag.equals(REFERENCES) && (this.processingTopLevelAccess || this.processingAdditionalAccess || this.processingOtherAccess)) {
                    data = this.textBuffer.toString().trim();
                    this.accessObject.setReferences(data);
                } else if (currentTag.equals(URL) && (parentNode = (DBSAXNode)this.nodeStack.peek()) != null && parentNode.getTagName() != null && parentNode.getTagName().equals(ONLINE)) {
                    data = this.textBuffer.toString().trim();
                    this.handleOnlineUrlDataFile(data);
                }
                this.logMetacat.debug((Object)"Write text into DB in End Element");
                if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                    this.compareAccessTextNode(this.currentUnchangeableAccessModuleNodeStack, this.textBuffer);
                }
                this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            }
            if (this.needToCheckAccessModule && (this.processingAdditionalAccess || this.processingOtherAccess || this.processingTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(this.textBuffer.toString()));
                this.storedAccessNodeStack.push(nodeElement);
            }
            this.hitTextNode = false;
            this.textBuffer = null;
            this.textBuffer = new StringBuffer();
            if (!this.subTreeInfoStack.empty() && (tree = this.subTreeInfoStack.peek()) != null && tree.getStartElementName() != null && tree.getStartElementName().equals(currentTag)) {
                tree.setEndNodeId(this.endNodeId);
                this.subTreeList.add(tree);
                this.subTreeInfoStack.pop();
            }
            if (currentTag.equals("allow") || currentTag.equals("deny")) {
                AccessRule newRule = this.accessRule;
                this.accessObject.addAccessRule(newRule);
                this.accessRule = null;
            } else if (currentTag.equals("access")) {
                AccessSection newAccessObject;
                DBSAXNode parentNode = (DBSAXNode)this.nodeStack.peek();
                this.accessObject.setEndNodeId(this.endNodeId);
                if (parentNode != null && parentNode.getTagName() != null && parentNode.getTagName().equals(DISTRIBUTION)) {
                    this.describesId.add(String.valueOf(this.distributionIndex));
                    this.currentDistributionSection.setAccessSection(this.accessObject);
                }
                if ((newAccessObject = this.accessObject) != null) {
                    if (newAccessObject.getReferences() == null) {
                        newAccessObject.setStoredTmpNodeStack(this.storedAccessNodeStack);
                        this.accessObjectList.add(newAccessObject);
                    }
                    if (this.processingTopLevelAccess) {
                        this.topLevelAccessControlMap.put(this.docid, newAccessObject);
                    } else if (this.processingAdditionalAccess) {
                        for (int i = 0; i < this.describesId.size(); ++i) {
                            String subId = this.describesId.elementAt(i);
                            if (subId == null) continue;
                            this.additionalAccessControlMap.put(subId, newAccessObject);
                        }
                        this.additionalAccessMapList.add(this.additionalAccessControlMap);
                        this.additionalAccessControlMap = null;
                        this.additionalAccessControlMap = new Hashtable();
                    }
                }
                if (this.needToCheckAccessModule && this.processingTopLevelAccess && !this.currentUnchangeableAccessModuleNodeStack.isEmpty()) {
                    this.logMetacat.error((Object)"Access node stack is not empty after parsing access subtree");
                    throw new SAXException(UPDATEACCESSERROR);
                }
                this.accessObject = null;
                this.storedAccessNodeStack = null;
                this.storedAccessNodeStack = new Stack();
                this.processingAdditionalAccess = false;
                this.processingTopLevelAccess = false;
                this.processingOtherAccess = false;
            } else if (currentTag.equals(DISTRIBUTION)) {
                if ((this.currentDistributionSection.getDistributionType() == 1 || this.currentDistributionSection.getDistributionType() == 3) && this.currentDistributionSection.getAccessSection() == null && this.topLevelAccessControlMap.size() > 0) {
                    AccessSection accessSection = new AccessSection();
                    accessSection.setDocId(this.docid);
                    AccessSection topLevelAccess = this.topLevelAccessControlMap.get(this.docid);
                    accessSection.setPermissionOrder(topLevelAccess.getPermissionOrder());
                    Vector<AccessRule> accessRuleList = topLevelAccess.getAccessRules();
                    for (AccessRule accessRule : accessRuleList) {
                        accessSection.addAccessRule(accessRule);
                    }
                    this.currentDistributionSection.setAccessSection(accessSection);
                }
                if (this.currentDistributionSection.getAccessSection() != null) {
                    this.currentDistributionSection.getAccessSection().setDataFileName(this.currentDistributionSection.getDataFileName());
                }
                this.allDistributionSections.add(this.currentDistributionSection);
                this.currentDistributionSection = null;
                this.describesId = null;
                this.describesId = new Vector();
            }
        } else {
            StringBuffer endElement = new StringBuffer();
            endElement.append("</");
            endElement.append(qName);
            endElement.append(">");
            this.logMetacat.debug((Object)("inline endElement: " + endElement.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, endElement);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.logMetacat.debug((Object)"COMMENT");
        if (!this.handleInlineData) {
            if (!this.processingDTD) {
                DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
                String str = new String(ch, start, length);
                if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                    this.compareCommentNode(this.currentUnchangeableAccessModuleNodeStack, str, UPDATEACCESSERROR);
                }
                this.endNodeId = currentNode.writeChildNodeToDB("COMMENT", null, str, this.docid);
                if (this.needToCheckAccessModule && (this.processingAdditionalAccess || this.processingOtherAccess || this.processingTopLevelAccess)) {
                    NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "COMMENT", null, null, MetacatUtil.normalize(str));
                    this.storedAccessNodeStack.push(nodeElement);
                }
            }
        } else {
            StringBuffer inlineComment = new StringBuffer();
            inlineComment.append("<!--");
            inlineComment.append(new String(ch, start, length));
            inlineComment.append("-->");
            this.logMetacat.debug((Object)("inline data comment: " + inlineComment.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineComment);
        }
    }

    private void compareCommentNode(Stack<NodeRecord> nodeStack, String string, String error) throws SAXException {
        NodeRecord node = null;
        try {
            node = nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"the stack is empty for comment data");
            throw new SAXException(error);
        }
        this.logMetacat.debug((Object)"current node type from xml is COMMENT");
        this.logMetacat.debug((Object)("node type from stack: " + node.getNodeType()));
        this.logMetacat.debug((Object)("current node data from xml is: " + string));
        this.logMetacat.debug((Object)("node data from stack: " + node.getNodeData()));
        this.logMetacat.debug((Object)("node is from stack: " + node.getNodeId()));
        if (!node.getNodeType().equals("COMMENT") || !string.equals(node.getNodeData())) {
            this.logMetacat.error((Object)"Inconsistence happened: ");
            this.logMetacat.error((Object)"current node type from xml is COMMENT");
            this.logMetacat.error((Object)("node type from stack: " + node.getNodeType()));
            this.logMetacat.error((Object)("current node data from xml is: " + string));
            this.logMetacat.error((Object)("node data from stack: " + node.getNodeData()));
            this.logMetacat.error((Object)("node is from stack: " + node.getNodeId()));
            throw new SAXException(error);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.logMetacat.debug((Object)"PI");
        if (!this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
            this.endNodeId = currentNode.writeChildNodeToDB("PI", target, data, this.docid);
        } else {
            StringBuffer inlinePI = new StringBuffer();
            inlinePI.append("<?");
            inlinePI.append(target);
            inlinePI.append(" ");
            inlinePI.append(data);
            inlinePI.append("?>");
            this.logMetacat.debug((Object)("inline data pi is: " + inlinePI.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlinePI);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.logMetacat.debug((Object)"NAMESPACE");
        if (!this.handleInlineData) {
            this.namespaces.put(prefix, uri);
        } else {
            this.inlineDataNameSpace.put(prefix, uri);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.debug((Object)"IGNORABLEWHITESPACE");
        if (!this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
            String data = new String(cbuf, start, len);
            if (this.processingTopLevelAccess && this.needToCheckAccessModule) {
                this.compareWhiteSpace(this.currentUnchangeableAccessModuleNodeStack, data, UPDATEACCESSERROR);
            }
            if (this.needToCheckAccessModule && (this.processingAdditionalAccess || this.processingOtherAccess || this.processingTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(data));
                this.storedAccessNodeStack.push(nodeElement);
            }
            this.endNodeId = currentNode.writeChildNodeToDB("TEXT", null, data, this.docid);
        } else {
            StringBuffer inlineWhiteSpace = new StringBuffer(new String(cbuf, start, len));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineWhiteSpace);
        }
    }

    private void compareWhiteSpace(Stack<NodeRecord> nodeStack, String string, String error) throws SAXException {
        NodeRecord node = null;
        try {
            node = nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"the stack is empty for whitespace data");
            throw new SAXException(error);
        }
        if (!node.getNodeType().equals("TEXT") || !string.equals(node.getNodeData())) {
            this.logMetacat.error((Object)"Inconsistence happened: ");
            this.logMetacat.error((Object)"current node type from xml is WHITESPACE TEXT");
            this.logMetacat.error((Object)("node type from stack: " + node.getNodeType()));
            this.logMetacat.error((Object)("current node data from xml is: " + string));
            this.logMetacat.error((Object)("node data from stack: " + node.getNodeData()));
            this.logMetacat.error((Object)("node is from stack: " + node.getNodeId()));
            throw new SAXException(error);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.logMetacat.debug((Object)"end Document");
        if (!super.getIsRevisionDoc()) {
            if (this.writeAccessRules) {
                this.writeAccessRuleToDB();
            }
            this.deleteRelations();
            for (int i = 0; i < this.onlineDataFileIdInRelationVector.size(); ++i) {
                String id = this.onlineDataFileIdInRelationVector.elementAt(i);
                this.writeOnlineDataFileIdIntoRelationTable(id);
            }
        }
    }

    private void writeAccessRuleToDB() throws SAXException {
        this.deletePermissionsInAccessTable();
        this.writeTopLevelAccessRuleToDB();
        this.writeAdditionalAccessRulesToDB();
    }

    private void writeTopLevelAccessRuleToDB() throws SAXException {
        AccessSection accessSection = this.topLevelAccessControlMap.get(this.docid);
        boolean top = true;
        String subSectionId = null;
        if (accessSection != null) {
            AccessSection accessSectionObj = accessSection;
            if (accessSectionObj.getReferences() == null) {
                String permOrder = accessSectionObj.getPermissionOrder();
                if (permOrder.equals("denyFirst") && this.ignoreDenyFirst) {
                    this.logMetacat.warn((Object)"Metacat no longer supports EML 'denyFirst' access rules - ignoring this access block");
                    return;
                }
                this.deleteAccessSubTreeRecord(this.docid);
                this.writeAccessSubTreeIntoDB(accessSectionObj, TOPLEVEL);
                this.writeGivenAccessRuleIntoDB(accessSectionObj, top, subSectionId);
            } else {
                String referenceId = accessSectionObj.getReferences();
                boolean findAccessObject = false;
                this.logMetacat.debug((Object)("referered id for top access: " + referenceId));
                for (int i = 0; i < this.accessObjectList.size(); ++i) {
                    AccessSection accessObj = this.accessObjectList.elementAt(i);
                    String accessObjId = accessObj.getSubTreeId();
                    String permOrder = accessObj.getPermissionOrder();
                    if (permOrder.equals("denyFirst") && this.ignoreDenyFirst) {
                        this.logMetacat.warn((Object)("Metacat no longer supports EML 'denyFirst' access rules - ignoring this access block, subtree id: " + accessObjId));
                        continue;
                    }
                    if (referenceId == null || accessObj == null || !referenceId.equals(accessObjId)) continue;
                    if (this.needToCheckAccessModule) {
                        Stack<NodeRecord> newStack = accessObj.getStoredTmpNodeStack();
                        newStack = DocumentUtil.reviseStack(newStack);
                        AccessSection oldAccessObj = this.getAccessSectionFromUnchangableAccessVector(referenceId);
                        if (oldAccessObj == null) {
                            throw new SAXException(UPDATEACCESSERROR);
                        }
                        Stack<NodeRecord> oldStack = oldAccessObj.getSubTreeNodeStack();
                        this.compareNodeStacks(newStack, oldStack);
                    }
                    this.writeGivenAccessRuleIntoDB(accessObj, top, subSectionId);
                    this.deleteAccessSubTreeRecord(this.docid);
                    this.writeAccessSubTreeIntoDB(accessSectionObj, TOPLEVEL);
                    this.writeAccessSubTreeIntoDB(accessObj, SUBTREELEVEL);
                    findAccessObject = true;
                    break;
                }
                if (!findAccessObject) {
                    throw new SAXException("The referenceid: " + referenceId + " is not access subtree");
                }
            }
        } else {
            this.logMetacat.warn((Object)("couldn't find access control for document: " + this.docid));
        }
    }

    private AccessSection getAccessSectionFromUnchangableAccessVector(String id) {
        AccessSection result = null;
        if (id == null || id.equals("")) {
            return result;
        }
        for (int i = 0; i < this.unChangeableAccessSubTreeVector.size(); ++i) {
            AccessSection accessObj = this.unChangeableAccessSubTreeVector.elementAt(i);
            if (accessObj.getSubTreeId() == null || !accessObj.getSubTreeId().equals(id)) continue;
            result = accessObj;
        }
        return result;
    }

    private void compareNodeStacks(Stack<NodeRecord> stack1, Stack<NodeRecord> stack2) throws SAXException {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            this.logMetacat.error((Object)"Because stack is empty!");
            throw new SAXException(UPDATEACCESSERROR);
        }
        while (!stack1.isEmpty()) {
            NodeRecord record1 = stack1.pop();
            NodeRecord record2 = null;
            try {
                record2 = stack2.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack2 is empty but stack1 isn't!");
                throw new SAXException(UPDATEACCESSERROR);
            }
            if (record1.contentEquals(record2)) continue;
            this.logMetacat.error((Object)"Two records from new and old stack are not same!");
            throw new SAXException(UPDATEACCESSERROR);
        }
        if (!stack2.isEmpty()) {
            this.logMetacat.error((Object)"stack2 still has some elements while stack is empty! ");
            throw new SAXException(UPDATEACCESSERROR);
        }
    }

    private void writeAdditionalAccessRulesToDB() throws SAXException {
        for (DistributionSection distributionSection : this.allDistributionSections) {
            AccessSection accessSection;
            block15: {
                PermissionController controller;
                String previousDocid;
                int distributionType = distributionSection.getDistributionType();
                if (distributionType != 1 && distributionType != 3 || (accessSection = distributionSection.getAccessSection()) == null) continue;
                String permOrder = accessSection.getPermissionOrder();
                if (permOrder.equals("denyFirst") && this.ignoreDenyFirst) {
                    this.logMetacat.warn((Object)("Metacat no longer supports EML 'denyFirst' access rules - ignoring this access block: " + distributionSection.getDataFileName()));
                    continue;
                }
                if (distributionType == 1) {
                    try {
                        String docidWithoutRev;
                        int latestRevision;
                        String dataDocid = distributionSection.getDataFileName();
                        try {
                            dataDocid = IdentifierManager.getInstance().getLocalId(dataDocid);
                        }
                        catch (McdbDocNotFoundException mcdbnfe) {
                            this.logMetacat.warn((Object)("Could not find guid/docid mapping for " + dataDocid));
                        }
                        previousDocid = dataDocid;
                        if (this.action == "UPDATE" && (latestRevision = DBUtil.getLatestRevisionInDocumentTable(docidWithoutRev = DocumentUtil.getDocIdFromString(dataDocid))) > 0) {
                            previousDocid = docidWithoutRev + PropertyService.getProperty("document.accNumSeparator") + latestRevision;
                        }
                        controller = new PermissionController(previousDocid);
                        PermissionController currentController = new PermissionController(dataDocid);
                        if (AccessionNumber.accNumberUsed(this.docid) && !controller.hasPermission(this.user, this.groups, "WRITE") && !currentController.hasPermission(this.user, this.groups, "WRITE")) {
                            throw new SAXException("User tried to update an access module when they don't have \"ALL\" permission! id: " + dataDocid);
                        }
                        break block15;
                    }
                    catch (SQLException sqle) {
                        throw new SAXException("Database error checking user permissions: " + sqle.getMessage());
                    }
                    catch (Exception e) {
                        throw new SAXException("General error checking user permissions: " + e.getMessage());
                    }
                }
                if (distributionType == 3 && this.action == "UPDATE") {
                    try {
                        int latestRevision = DBUtil.getLatestRevisionInDocumentTable(this.docid);
                        previousDocid = this.docid + PropertyService.getProperty("document.accNumSeparator") + latestRevision;
                        controller = new PermissionController(previousDocid);
                        if (!controller.hasPermission(this.user, this.groups, "WRITE")) {
                            throw new SAXException(UPDATEACCESSERROR);
                        }
                    }
                    catch (SQLException sqle) {
                        throw new SAXException("Database error checking user permissions: " + sqle.getMessage());
                    }
                    catch (Exception e) {
                        throw new SAXException("General error checking user permissions: " + e.getMessage());
                    }
                }
            }
            this.deleteAccessRule(accessSection, false);
            String subSectionId = Integer.toString(distributionSection.getDistributionId());
            this.writeGivenAccessRuleIntoDB(accessSection, false, subSectionId);
        }
    }

    private void deleteAccessRule(AccessSection accessSection, boolean topLevel) throws SAXException {
        if (accessSection == null) {
            throw new SAXException("The access object is null");
        }
        PreparedStatement pstmt = null;
        String sql = null;
        sql = "DELETE FROM xml_access WHERE guid = ?";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            String guid = null;
            if (topLevel) {
                try {
                    guid = IdentifierManager.getInstance().getGUID(this.docid, Integer.valueOf(this.revision));
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e.getMessage(), e);
                }
                catch (McdbDocNotFoundException e) {
                    guid = this.docid + "." + this.revision;
                    IdentifierManager.getInstance().createMapping(guid, guid);
                }
            } else {
                guid = accessSection.getDataFileName();
            }
            pstmt.setString(1, guid);
            this.logMetacat.debug((Object)("guid in accesstable: " + guid));
            this.logMetacat.debug((Object)("running sql: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.deleteAccessRule(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.deleteAccessRule(): " + ee.getMessage());
            }
        }
    }

    private void writeGivenAccessRuleIntoDB(AccessSection accessSection, boolean topLevel, String subSectionId) throws SAXException {
        if (accessSection == null) {
            throw new SAXException("The access object is null");
        }
        String guid = null;
        String referencedGuid = accessSection.getDataFileName();
        try {
            guid = IdentifierManager.getInstance().getGUID(this.docid, Integer.valueOf(this.revision));
        }
        catch (NumberFormatException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (McdbDocNotFoundException e) {
            guid = this.docid + "." + this.revision;
            IdentifierManager.getInstance().createMapping(guid, guid);
        }
        String permOrder = accessSection.getPermissionOrder();
        String sql = null;
        PreparedStatement pstmt = null;
        sql = topLevel ? "INSERT INTO xml_access (guid, principal_name, permission, perm_type, perm_order, accessfileid) VALUES  (?, ?, ?, ?, ?, ?)" : "INSERT INTO xml_access (guid,principal_name, permission, perm_type, perm_order, accessfileid, subtreeid) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(6, guid);
            this.logMetacat.debug((Object)("Accessfileid in accesstable: " + guid));
            pstmt.setString(5, permOrder);
            this.logMetacat.debug((Object)("PermOder in accesstable: " + permOrder));
            if (topLevel) {
                pstmt.setString(1, guid);
                this.logMetacat.debug((Object)("Guid in accesstable: " + guid));
            }
            if (!topLevel) {
                pstmt.setString(1, referencedGuid);
                this.logMetacat.debug((Object)("Docid in accesstable: " + this.inlineDataFileName));
                if (subSectionId == null) {
                    throw new SAXException("The subsection is null");
                }
                pstmt.setString(7, subSectionId);
                this.logMetacat.debug((Object)("SubSectionId in accesstable: " + subSectionId));
                this.guidsToSync.add(referencedGuid);
            }
            Vector<AccessRule> accessRules = accessSection.getAccessRules();
            for (int i = 0; i < accessRules.size(); ++i) {
                AccessRule rule = accessRules.elementAt(i);
                String permType = rule.getPermissionType();
                int permission = rule.getPermission();
                pstmt.setInt(3, permission);
                this.logMetacat.debug((Object)("permission in accesstable: " + permission));
                pstmt.setString(4, permType);
                this.logMetacat.debug((Object)("Permtype in accesstable: " + permType));
                Vector<String> nameVector = rule.getPrincipal();
                for (int j = 0; j < nameVector.size(); ++j) {
                    String prName = nameVector.elementAt(j);
                    pstmt.setString(2, prName);
                    this.logMetacat.debug((Object)("Principal in accesstable: " + prName));
                    this.logMetacat.debug((Object)("running sql: " + pstmt.toString()));
                    pstmt.execute();
                }
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeAccessRuletoDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeAccessRuletoDB(): " + ee.getMessage());
            }
        }
        HazelcastService.getInstance().refreshSystemMetadataEntry(guid);
        HazelcastService.getInstance().refreshSystemMetadataEntry(referencedGuid);
    }

    private void deletePermissionsInAccessTable() throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_access WHERE accessfileid IN (SELECT guid from identifier where docid = ? and rev = ?) OR guid IN (SELECT xa.guid from xml_access xa, identifier id WHERE xa.accessfileid = id.guid  AND id.docid = ? AND id.rev = ?)";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, this.docid);
            pstmt.setInt(2, Integer.valueOf(this.revision));
            pstmt.setString(3, this.docid);
            pstmt.setInt(4, Integer.valueOf(this.revision));
            this.connection.increaseUsageCount(1);
            this.logMetacat.debug((Object)("running sql: " + sql));
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private void writeAccessSubTreeIntoDB(AccessSection accessSection, String level) throws SAXException {
        if (accessSection == null) {
            throw new SAXException("The access object is null");
        }
        String sql = null;
        PreparedStatement pstmt = null;
        sql = "INSERT INTO xml_accesssubtree (docid, rev, controllevel, subtreeid, startnodeid, endnodeid) VALUES  (?, ?, ?, ?, ?, ?)";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            long startNodeId = accessSection.getStartNodeId();
            long endNodeId = accessSection.getEndNodeId();
            String sectionId = accessSection.getSubTreeId();
            pstmt.setString(1, this.docid);
            this.logMetacat.debug((Object)("Docid in access-subtreetable: " + this.docid));
            pstmt.setLong(2, new Long(this.revision));
            this.logMetacat.debug((Object)("rev in accesssubtreetable: " + this.revision));
            pstmt.setString(3, level);
            this.logMetacat.debug((Object)("contorl level in access-subtree table: " + level));
            pstmt.setString(4, sectionId);
            this.logMetacat.debug((Object)("Subtree id in access-subtree table: " + sectionId));
            pstmt.setLong(5, startNodeId);
            this.logMetacat.debug((Object)("Start node id is: " + startNodeId));
            pstmt.setLong(6, endNodeId);
            this.logMetacat.debug((Object)("End node id is: " + endNodeId));
            this.logMetacat.debug((Object)("running sql: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeAccessSubTreeIntoDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeAccessSubTreeIntoDB(): " + ee.getMessage());
            }
        }
    }

    private void deleteAccessSubTreeRecord(String docId) throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_accesssubtree WHERE docid = ?";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, docId);
            this.connection.increaseUsageCount(1);
            this.logMetacat.debug((Object)("running sql: " + sql));
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private Writer createInlineDataFileWriter(String fileName, String encoding) throws SAXException {
        String path;
        OutputStreamWriter writer = null;
        try {
            path = PropertyService.getProperty("application.inlinedatafilepath");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException(pnfe.getMessage());
        }
        String newFile = path + "/" + fileName;
        this.logMetacat.debug((Object)("inline file name: " + newFile));
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile, true), encoding);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe.getMessage());
        }
        return writer;
    }

    private void writeInlineDataIntoFile(Writer writer, StringBuffer data) throws SAXException {
        try {
            writer.write(data.toString());
            writer.flush();
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void deleteInlineFiles() throws SAXException {
        if (!this.inlineFileIdList.isEmpty()) {
            for (int i = 0; i < this.inlineFileIdList.size(); ++i) {
                String fileName = this.inlineFileIdList.elementAt(i);
                this.deleteInlineDataFile(fileName);
            }
        }
    }

    private void deleteInlineDataFile(String fileName) throws SAXException {
        String path;
        try {
            path = PropertyService.getProperty("application.inlinedatafilepath");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException("Could not find inline data file path: " + pnfe.getMessage());
        }
        File inlineDataDirectory = new File(path);
        File newFile = new File(inlineDataDirectory, fileName);
        newFile.delete();
    }

    private void deleteRelations() throws SAXException {
        PreparedStatement pStmt = null;
        String sql = "DELETE FROM xml_relation where docid =?";
        try {
            pStmt = this.connection.prepareStatement(sql);
            pStmt.setString(1, this.docid);
            pStmt.execute();
            pStmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.deleteRelations(): " + e.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.deleteRelations: " + ee.getMessage());
            }
        }
    }

    private void writeOnlineDataFileIdIntoRelationTable(String dataId) throws SAXException {
        PreparedStatement pStmt = null;
        String sql = "INSERT into xml_relation (docid, packagetype, subject, relationship, object) values (?, ?, ?, ?, ?)";
        try {
            pStmt = this.connection.prepareStatement(sql);
            pStmt.setString(1, this.docid);
            pStmt.setString(2, this.doctype);
            pStmt.setString(3, this.docid);
            pStmt.setString(4, RELATION);
            pStmt.setString(5, dataId);
            pStmt.execute();
            pStmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeOnlineDataFileIdIntoRelationTable(): " + e.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeOnlineDataFileIdIntoRelationTable(): " + ee.getMessage());
            }
        }
    }

    private void handleOnlineUrlDataFile(String url) throws SAXException {
        block14: {
            this.logMetacat.warn((Object)("The url is " + url));
            if (this.currentDistributionSection == null) {
                throw new SAXException("Trying to set the online file name for a null distribution section");
            }
            String accessionNumber = DocumentUtil.getAccessionNumberFromEcogridIdentifier(url);
            String docid = null;
            int rev = 0;
            if (accessionNumber != null) {
                try {
                    docid = DocumentUtil.getDocIdFromAccessionNumber(accessionNumber);
                    rev = DocumentUtil.getRevisionFromAccessionNumber(accessionNumber);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)(e.getClass().getName() + " - Problem parsing accession number for: " + accessionNumber + ". Message: " + e.getMessage()));
                    accessionNumber = null;
                }
            }
            if (accessionNumber == null) {
                this.currentDistributionSection.setDistributionType(2);
            } else {
                String guid = null;
                try {
                    guid = IdentifierManager.getInstance().getGUID(docid, rev);
                }
                catch (McdbDocNotFoundException e1) {
                    if (!this.writeAccessRules) {
                        this.logMetacat.warn((Object)("Not configured to write access rules for data referenced by: " + url));
                        return;
                    }
                    guid = docid + "." + rev;
                    IdentifierManager.getInstance().createMapping(guid, guid);
                }
                this.currentDistributionSection.setDistributionType(1);
                this.currentDistributionSection.setDataFileName(guid);
                this.onlineDataFileIdInRelationVector.add(guid);
                try {
                    if (!AccessionNumber.accNumberUsed(docid)) {
                        this.onlineDataFileIdInTopAccessVector.add(guid);
                        break block14;
                    }
                    int previousRevision = rev;
                    Vector<Integer> revisions = DBUtil.getRevListFromRevisionTable(docid);
                    if (revisions != null && revisions.size() > 0) {
                        previousRevision = revisions.get(revisions.size() - 1);
                    }
                    String previousDocid = docid + PropertyService.getProperty("document.accNumSeparator") + previousRevision;
                    PermissionController previousController = new PermissionController(previousDocid);
                    PermissionController currentController = new PermissionController(accessionNumber);
                    if (previousController.hasPermission(this.user, this.groups, "ALL") || currentController.hasPermission(this.user, this.groups, "ALL")) {
                        this.onlineDataFileIdInTopAccessVector.add(guid);
                        break block14;
                    }
                    throw new SAXException(UPDATEACCESSERROR);
                }
                catch (Exception e) {
                    this.logMetacat.error((Object)("Eorr in Eml210SAXHanlder.handleOnlineUrlDataFile is " + e.getMessage()));
                    throw new SAXException(e.getMessage());
                }
            }
        }
    }
}

