/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.MetaCatServlet;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.AuthAdmin;
import edu.ucsb.nceas.metacat.admin.BackupAdmin;
import edu.ucsb.nceas.metacat.admin.D1Admin;
import edu.ucsb.nceas.metacat.admin.DBAdmin;
import edu.ucsb.nceas.metacat.admin.GeoserverAdmin;
import edu.ucsb.nceas.metacat.admin.LoginAdmin;
import edu.ucsb.nceas.metacat.admin.PropertiesAdmin;
import edu.ucsb.nceas.metacat.admin.ReplicationAdmin;
import edu.ucsb.nceas.metacat.admin.SkinsAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.ConfigurationUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class MetacatAdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger logMetacat = Logger.getLogger(MetacatAdminServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("configureType");
        this.logMetacat.debug((Object)("MetacatAdminServlet.handleGetOrPost - Processing admin action: " + action));
        Vector<String> processingMessage = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        try {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                SessionService.getInstance().touchSession(httpSession.getId());
            }
            if (!ConfigurationUtil.isBackupDirConfigured()) {
                processingMessage.add("You must configure the backup directory before you can continue with Metacat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "backup";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'backup'");
            } else if (!AuthUtil.isAuthConfigured()) {
                processingMessage.add("You must configure authentication before you can continue with MetaCat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "auth";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'auth'");
            } else if (!AuthUtil.isUserLoggedInAsAdmin(request)) {
                processingMessage.add("You must log in as an administrative user before you can continue with MetaCat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "login";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'login'");
            }
            if (action == null || action.equals("configure")) {
                request.setAttribute("metaCatVersion", (Object)SystemUtil.getMetacatVersion());
                request.setAttribute("propsConfigured", (Object)new Boolean(PropertyService.arePropertiesConfigured()));
                request.setAttribute("authConfigured", (Object)new Boolean(AuthUtil.isAuthConfigured()));
                request.setAttribute("skinsConfigured", (Object)new Boolean(SkinUtil.areSkinsConfigured()));
                request.setAttribute("metacatConfigured", (Object)new Boolean(ConfigurationUtil.isMetacatConfigured()));
                request.setAttribute("geoserverConfigured", (Object)PropertyService.getProperty("configutil.geoserverConfigured"));
                request.setAttribute("dataoneConfigured", (Object)PropertyService.getProperty("configutil.dataoneConfigured"));
                request.setAttribute("metcatServletInitialized", (Object)MetaCatServlet.isFullyInitialized());
                if (PropertyService.arePropertiesConfigured()) {
                    request.setAttribute("databaseVersion", (Object)DBAdmin.getInstance().getDBVersion());
                    request.setAttribute("contextURL", (Object)SystemUtil.getContextURL());
                }
                RequestUtil.forwardRequest(request, response, "/admin/metacat-configuration.jsp?configureType=configure", null);
                return;
            }
            if (action.equals("properties")) {
                PropertiesAdmin.getInstance().configureProperties(request, response);
                return;
            }
            if (action.equals("skins")) {
                SkinsAdmin.getInstance().configureSkins(request, response);
                return;
            }
            if (action.equals("database")) {
                DBAdmin.getInstance().configureDatabase(request, response);
                return;
            }
            if (action.equals("auth")) {
                AuthAdmin.getInstance().configureAuth(request, response);
                return;
            }
            if (action.equals("login")) {
                LoginAdmin.getInstance().authenticateUser(request, response);
                return;
            }
            if (action.equals("backup")) {
                BackupAdmin.getInstance().configureBackup(request, response);
                return;
            }
            if (action.equals("geoserver")) {
                GeoserverAdmin.getInstance().configureGeoserver(request, response);
                return;
            }
            if (action.equals("dataone")) {
                D1Admin.getInstance().configureDataONE(request, response);
                return;
            }
            if (action.equals("replication")) {
                ReplicationAdmin.getInstance().handleRequest(request, response);
                return;
            }
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Invalid action in configuration request: " + action;
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
            if (processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestErrors(request, processingErrors);
                if (action != null && action.equals("configure")) {
                    RequestUtil.forwardRequest(request, response, "/admin/metacat-configuration.jsp", null);
                } else {
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure", null);
                }
            }
        }
        catch (GeneralPropertyException ge) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Property problem while handling request: " + ge.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (AdminException ae) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Admin problem while handling request: " + ae.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (MetacatUtilException ue) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Utility problem while handling request: " + ue.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (ServiceException e) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Service problem while handling request: " + e.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
    }
}

