/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.MetacatVersion;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.DBAdmin;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.database.DBVersion;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.SortedProperties;
import edu.ucsb.nceas.utilities.UtilException;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.log4j.Logger;

public class PropertiesAdmin
extends MetacatAdmin {
    private static String BACKSLASH = "/";
    private static String DEFAULTMETACATCONTEXT = "metacat";
    private static String METACATPROPERTYAPPENDIX = "/WEB-INF/metacat.properties";
    private static PropertiesAdmin propertiesAdmin = null;
    private static Logger logMetacat = Logger.getLogger(PropertiesAdmin.class);

    private PropertiesAdmin() {
    }

    public static PropertiesAdmin getInstance() {
        if (propertiesAdmin == null) {
            propertiesAdmin = new PropertiesAdmin();
        }
        return propertiesAdmin;
    }

    public void configureProperties(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                PropertiesMetaData metadata = PropertyService.getMainMetaData();
                request.setAttribute("metadata", (Object)metadata);
                String externalDir = PropertyService.getRecommendedExternalDir();
                if (externalDir == null) {
                    throw new AdminException("Could not initialize property configuration page recommended application backup directory was null");
                }
                PropertyService.setPropertyNoPersist("application.context", ServiceService.getRealApplicationContext());
                PropertyService.setPropertyNoPersist("server.name", SystemUtil.discoverServerName(request));
                PropertyService.setPropertyNoPersist("server.httpPort", SystemUtil.discoverServerPort(request));
                PropertyService.setPropertyNoPersist("server.httpSSLPort", SystemUtil.discoverServerSSLPort(request));
                PropertyService.setPropertyNoPersist("application.deployDir", SystemUtil.discoverDeployDir(request));
                PropertyService.setPropertyNoPersist("application.datafilepath", externalDir + FileUtil.getFS() + "data");
                PropertyService.setPropertyNoPersist("application.inlinedatafilepath", externalDir + FileUtil.getFS() + "inline-data");
                PropertyService.setPropertyNoPersist("application.documentfilepath", externalDir + FileUtil.getFS() + "documents");
                PropertyService.setPropertyNoPersist("application.tempDir", externalDir + FileUtil.getFS() + "temporary");
                PropertyService.setPropertyNoPersist("replication.logdir", externalDir + FileUtil.getFS() + "logs");
                PropertyService.setPropertyNoPersist("solr.homeDir", externalDir + FileUtil.getFS() + "solr-home");
                PropertyService.persistProperties();
                Vector<String> propertyNames = PropertyService.getPropertyNames();
                for (String propertyName : propertyNames) {
                    request.setAttribute(propertyName, (Object)PropertyService.getProperty(propertyName));
                }
                SortedProperties backupProperties = null;
                backupProperties = PropertyService.getMainBackupProperties();
                if (backupProperties != null) {
                    Vector backupKeys = backupProperties.getPropertyNames();
                    for (String key : backupKeys) {
                        String value = backupProperties.getProperty(key);
                        if (value == null) continue;
                        request.setAttribute(key, (Object)value);
                    }
                }
                RequestUtil.forwardRequest(request, response, "/admin/properties-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("PropertiesAdmin.configureProperties - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("PropertiesAdmin.configureProperties - utility problem while initializing system properties page:" + mue.getMessage());
            }
            catch (ServiceException se) {
                throw new AdminException("PropertiesAdmin.configureProperties - Service problem while initializing system properties page:" + se.getMessage());
            }
        }
        Vector<String> validationErrors = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        Vector<String> processingSuccess = new Vector<String>();
        MetacatVersion metacatVersion = null;
        try {
            metacatVersion = SystemUtil.getMetacatVersion();
            Vector<String> propertyNames = PropertyService.getPropertyNames();
            for (String name : propertyNames) {
                PropertyService.checkAndSetProperty(request, name);
            }
            PropertyService.persistProperties();
            validationErrors.addAll(this.validateOptions(request));
            String dataDir = PropertyService.getProperty("application.datafilepath");
            try {
                FileUtil.createDirectory((String)dataDir);
            }
            catch (UtilException ue) {
                String errorString = "PropertiesAdmin.configureProperties - Could not create directory: " + dataDir + " : " + ue.getMessage();
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            String inlineDataDir = PropertyService.getProperty("application.inlinedatafilepath");
            try {
                FileUtil.createDirectory((String)inlineDataDir);
            }
            catch (UtilException ue) {
                String errorString = "PropertiesAdmin.configureProperties - Could not create directory: " + inlineDataDir + " : " + ue.getMessage();
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            String documentfilepath = PropertyService.getProperty("application.documentfilepath");
            try {
                FileUtil.createDirectory((String)documentfilepath);
            }
            catch (UtilException ue) {
                String errorString = "PropertiesAdmin.configureProperties - Could not create directory: " + documentfilepath + " : " + ue.getMessage();
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            String tempDir = PropertyService.getProperty("application.tempDir");
            try {
                FileUtil.createDirectory((String)tempDir);
            }
            catch (UtilException ue) {
                String errorString = "PropertiesAdmin.configureProperties - Could not create directory: " + tempDir + " : " + ue.getMessage();
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            String replLogDir = PropertyService.getProperty("replication.logdir");
            try {
                FileUtil.createDirectory((String)replLogDir);
            }
            catch (UtilException ue) {
                String errorString = "PropertiesAdmin.configureProperties - Could not create directory: " + replLogDir + " : " + ue.getMessage();
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            String solrHomePath = PropertyService.getProperty("solr.homeDir");
            String indexContext = PropertyService.getProperty("index.context");
            boolean solrHomeExists = new File(solrHomePath).exists();
            if (!solrHomeExists) {
                try {
                    String metacatWebInf = ServiceService.getRealConfigDir();
                    String metacatIndexSolrHome = metacatWebInf + "/../../" + indexContext + "/WEB-INF/classes/solr-home";
                    File sourceDir = new File(metacatIndexSolrHome);
                    if (sourceDir.exists()) {
                        FileUtil.createDirectory((String)solrHomePath);
                        OrFileFilter fileFilter = new OrFileFilter();
                        fileFilter.addFileFilter(DirectoryFileFilter.DIRECTORY);
                        fileFilter.addFileFilter((IOFileFilter)new WildcardFileFilter("*"));
                        FileUtils.copyDirectory((File)new File(metacatIndexSolrHome), (File)new File(solrHomePath), (FileFilter)fileFilter);
                    }
                }
                catch (Exception ue) {
                    String errorString = "PropertiesAdmin.configureProperties - Could not initialize directory: " + solrHomePath + " : " + ue.getMessage();
                    logMetacat.error((Object)errorString);
                    validationErrors.add(errorString);
                }
            } else if (!FileUtil.isDirectory((String)solrHomePath)) {
                String errorString = "PropertiesAdmin.configureProperties - SOLR home is not a directory: " + solrHomePath;
                logMetacat.error((Object)errorString);
                validationErrors.add(errorString);
            }
            this.modifyIndexContextParams(indexContext);
            this.modifyHazelcastConfig();
            try {
                String cgiFiles = PropertyService.getProperty("application.deployDir") + FileUtil.getFS() + PropertyService.getProperty("application.context") + PropertyService.getProperty("application.cgiDir") + FileUtil.getFS() + "*.cgi";
                String[] command = new String[]{"sh", "-c", "chmod +x " + cgiFiles};
                Runtime rt = Runtime.getRuntime();
                Process pr = rt.exec(command);
                int ret = pr.waitFor();
                if (ret > 0) {
                    logMetacat.error((Object)IOUtils.toString((InputStream)pr.getErrorStream()));
                }
            }
            catch (Exception ignorable) {
                logMetacat.warn((Object)("Could not set permissions on the registry scripts: " + ignorable.getMessage()), (Throwable)ignorable);
            }
            PropertyService.persistMainBackupProperties();
        }
        catch (GeneralPropertyException gpe) {
            String errorMessage = "PropertiesAdmin.configureProperties - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        try {
            if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestFormErrors(request, validationErrors);
                RequestUtil.setRequestErrors(request, processingErrors);
                RequestUtil.forwardRequest(request, response, "/admin", null);
            } else {
                PropertyService.setProperty("configutil.propertiesConfigured", "true");
                DBVersion dbVersion = DBAdmin.getInstance().getDBVersion();
                if (dbVersion != null && metacatVersion != null && dbVersion.compareTo(metacatVersion) == 0) {
                    PropertyService.setProperty("configutil.databaseConfigured", "true");
                }
                processingSuccess.add("Properties successfully configured");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
        }
        catch (MetacatUtilException mue) {
            throw new AdminException("PropertiesAdmin.configureProperties - utility problem while processing system properties page: " + mue.getMessage());
        }
        catch (GeneralPropertyException gpe) {
            throw new AdminException("PropertiesAdmin.configureProperties - problem with properties while processing system properties page: " + gpe.getMessage());
        }
    }

    private void modifyIndexContextParams(String indexContext) {
        if (indexContext != null) {
            try {
                String metacatContext = PropertyService.getProperty("application.context");
                if (metacatContext != null && !metacatContext.equals(DEFAULTMETACATCONTEXT)) {
                    String indexConfigFile = PropertyService.getProperty("application.deployDir") + FileUtil.getFS() + indexContext + FileUtil.getFS() + "WEB-INF" + FileUtil.getFS() + "web.xml";
                    String configContents = FileUtil.readFileToString((String)indexConfigFile, (String)"UTF-8");
                    configContents = configContents.replace(BACKSLASH + DEFAULTMETACATCONTEXT + METACATPROPERTYAPPENDIX, BACKSLASH + metacatContext + METACATPROPERTYAPPENDIX);
                    FileUtil.writeFile((String)indexConfigFile, (Reader)new StringReader(configContents), (String)"UTF-8");
                }
            }
            catch (Exception e) {
                String errorMessage = "PropertiesAdmin.configureProperties - Problem getting/setting the \"metacat.properties.path\" in the web.xml of the index context : " + e.getMessage();
                logMetacat.error((Object)errorMessage);
            }
        }
    }

    private void modifyHazelcastConfig() {
        try {
            String metacatContext = PropertyService.getProperty("application.context");
            if (metacatContext != null) {
                String hzConfigFile = PropertyService.getProperty("application.deployDir") + FileUtil.getFS() + metacatContext + FileUtil.getFS() + "WEB-INF" + FileUtil.getFS() + "hazelcast.xml";
                String configContents = FileUtil.readFileToString((String)hzConfigFile, (String)"UTF-8");
                configContents = configContents.replace("<name>metacat</name>", "<name>" + metacatContext + "</name>");
                FileUtil.writeFile((String)hzConfigFile, (Reader)new StringReader(configContents), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            String errorMessage = "PropertiesAdmin.configureProperties - Problem setting groupName in hazelcast.xml: " + e.getMessage();
            logMetacat.error((Object)errorMessage);
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        try {
            String dbError = DBAdmin.getInstance().validateDBConnectivity(request.getParameter("database.driver"), request.getParameter("database.connectionURI"), request.getParameter("database.user"), request.getParameter("database.password"));
            if (dbError != null) {
                errorVector.add(dbError);
            }
        }
        catch (AdminException ae) {
            errorVector.add("Could not instantiate database admin: " + ae.getMessage());
        }
        return errorVector;
    }
}

