/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateGlobalIdentifiers
implements UpgradeUtilityInterface {
    private static Log log = LogFactory.getLog(GenerateGlobalIdentifiers.class);
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;

    @Override
    public boolean upgrade() throws AdminException {
        boolean success = false;
        log.debug((Object)"Upgrading identifiers to DOIs");
        boolean shouldUpgrade = false;
        try {
            shouldUpgrade = new Boolean(PropertyService.getProperty("guid.assignGUIDs"));
            if (shouldUpgrade) {
                log.debug((Object)"Upgrading identifiers to DOIs");
                success = this.updateIdentifierReferences();
            }
        }
        catch (PropertyNotFoundException e) {
            shouldUpgrade = false;
            success = true;
        }
        return success;
    }

    private boolean updateIdentifierReferences() throws AdminException {
        log.debug((Object)"Updating identifier references...");
        try {
            this.driver = PropertyService.getProperty("database.driver");
            this.url = PropertyService.getProperty("database.connectionURI");
            this.user = PropertyService.getProperty("database.user");
            this.password = PropertyService.getProperty("database.password");
        }
        catch (PropertyNotFoundException e) {
            String msg = "PropertyNotFound while trying to convert identifiers: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        Connection con = this.openDatabaseConnection();
        this.deferConstraints(con);
        this.createDuplicateGUIDColumn(con);
        int maxServerId = this.lookupMaxServers(con);
        for (int server = 1; server <= maxServerId; ++server) {
            try {
                String shoulder = PropertyService.getProperty("guid.ezid.doishoulder." + server);
                log.debug((Object)("Processing shoulder for server " + server + ": " + shoulder));
                this.convertIdentifierTable(con, server, shoulder);
                continue;
            }
            catch (PropertyNotFoundException e) {
                log.debug((Object)("No shoulder found: " + e.getMessage()));
            }
        }
        this.convertIdentifierField(con, "xml_access", "guid");
        this.convertIdentifierField(con, "xml_access", "accessfileid");
        this.convertIdentifierField(con, "systemmetadata", "guid");
        this.convertIdentifierField(con, "smreplicationpolicy", "guid");
        this.convertIdentifierField(con, "smreplicationstatus", "guid");
        this.convertIdentifierField(con, "smmediatypeproperties", "guid");
        this.dropDuplicateGUIDColumn(con);
        this.commitAndCloseConnection(con);
        return true;
    }

    private Connection openDatabaseConnection() throws AdminException {
        Connection con = null;
        try {
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            con = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (InstantiationException e) {
            String msg = "InstantiationException updating creating DB connection: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "IllegalAccessException updating creating DB connection: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        catch (ClassNotFoundException e) {
            String msg = "ClassNotFoundException updating creating DB connection: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        catch (SQLException e) {
            String msg = "SQLException updating creating DB connection: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return con;
    }

    private void deferConstraints(Connection con) throws AdminException {
        try {
            con.setAutoCommit(false);
            Statement sqlStatement = con.createStatement();
            boolean hasResults = sqlStatement.execute("SET CONSTRAINTS ALL DEFERRED;");
            log.debug((Object)"Constraints Deferred.");
        }
        catch (SQLException e) {
            String msg = "SQLException while disabling constraints: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
    }

    private void createDuplicateGUIDColumn(Connection con) throws AdminException {
        try {
            Statement sqlStatement = con.createStatement();
            boolean hasResults = sqlStatement.execute("ALTER TABLE identifier ADD COLUMN old_guid TEXT;");
            log.debug((Object)"old_guid column added.");
            sqlStatement = con.createStatement();
            hasResults = sqlStatement.execute("UPDATE identifier SET old_guid = guid;");
            log.debug((Object)"Copied original identifiers to old_guid column.");
        }
        catch (SQLException e) {
            String msg = "SQLException while duplicating GUID column: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
    }

    private void dropDuplicateGUIDColumn(Connection con) throws AdminException {
        try {
            Statement sqlStatement = con.createStatement();
            boolean hasResults = sqlStatement.execute("ALTER TABLE identifier DROP COLUMN old_guid;");
            log.debug((Object)"old_guid column dropped.");
        }
        catch (SQLException e) {
            String msg = "SQLException dropping GUID column: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
    }

    private int lookupMaxServers(Connection con) throws AdminException {
        int maxServers = 0;
        try {
            ResultSet rs;
            Statement sqlStatement = con.createStatement();
            boolean hasResults = sqlStatement.execute("SELECT max(serverid) AS maxserverid FROM xml_replication;");
            if (hasResults) {
                rs = sqlStatement.getResultSet();
                if (!rs.next()) {
                    String msg = "Could not determine max serverid; database query cursor had zero rows.";
                    log.error((Object)msg);
                    throw new AdminException(msg);
                }
            } else {
                String msg = "Could not determine max serverid; database query failed to return results.";
                log.error((Object)msg);
                throw new AdminException(msg);
            }
            maxServers = rs.getInt(1);
            log.debug((Object)("MaxServerID: " + maxServers));
        }
        catch (SQLException e) {
            String msg = "SQLException while looking up serverId: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return maxServers;
    }

    private boolean convertIdentifierTable(Connection con, int server, String shoulder) throws AdminException {
        PreparedStatement pstmt = null;
        try {
            String sql_1 = "UPDATE identifier SET    guid = p.doi FROM (SELECT  guid, ? || guid as doi FROM    identifier id2, ";
            String sql_2 = " xd WHERE   id2.docid = xd.docid AND id2.rev = xd.rev AND xd.server_location = ? ) p WHERE identifier.guid = p.guid;";
            pstmt = con.prepareStatement(sql_1 + "xml_documents" + sql_2);
            pstmt.setString(1, shoulder);
            pstmt.setInt(2, server);
            pstmt.execute();
            pstmt = con.prepareStatement(sql_1 + "xml_revisions" + sql_2);
            pstmt.setString(1, shoulder);
            pstmt.setInt(2, server);
            pstmt.execute();
            log.debug((Object)("Finished shoulder for server " + server + ": " + shoulder));
        }
        catch (SQLException e) {
            String msg = "SQLException updating identifier table: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return true;
    }

    private boolean convertIdentifierField(Connection con, String table, String field) throws AdminException {
        PreparedStatement pstmt = null;
        try {
            String sql_1 = "UPDATE " + table + " " + "SET " + field + " = id.guid " + "FROM identifier id " + "WHERE " + table + "." + field + " = id.old_guid;";
            pstmt = con.prepareStatement(sql_1);
            pstmt.execute();
            log.debug((Object)("Finished converting table " + table + " (" + field + ")"));
        }
        catch (SQLException e) {
            String msg = "SQLException while converting identifier field: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return true;
    }

    private boolean commitAndCloseConnection(Connection con) throws AdminException {
        try {
            log.debug((Object)"Committing and closing connection.");
            con.commit();
            con.close();
        }
        catch (SQLException e) {
            String msg = "SQLException while commiting and closing connection: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return true;
    }

    public static void main(String[] ags) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            GenerateGlobalIdentifiers upgrader = new GenerateGlobalIdentifiers();
            upgrader.upgrade();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (AdminException e) {
            e.printStackTrace();
        }
    }
}

