/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataquery;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;

public class MetacatDatabaseConnectionPoolFactory {
    public static Log log = LogFactory.getLog(MetacatDatabaseConnectionPoolFactory.class);
    private static String implementationClass = null;

    private static void loadOptions() {
        try {
            implementationClass = PropertyService.getProperty("datamanager.implementation");
        }
        catch (Exception e) {
            log.error((Object)("Error in loading options: " + e.getMessage()));
        }
    }

    public static DatabaseConnectionPoolInterface getDatabaseConnectionPoolInterface() {
        DatabaseConnectionPoolInterface instance = null;
        try {
            instance = (DatabaseConnectionPoolInterface)Class.forName(implementationClass).newInstance();
        }
        catch (Exception e) {
            log.error((Object)(e.getMessage() + ": could not create DatabaseConnectionPoolInterface implementation: " + implementationClass));
            e.printStackTrace();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        Connection conn = null;
        try {
            conn = MetacatDatabaseConnectionPoolFactory.getDatabaseConnectionPoolInterface().getConnection();
            log.debug((Object)("conn=" + conn));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ConnectionNotAvailableException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        MetacatDatabaseConnectionPoolFactory.loadOptions();
    }
}

