/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ecoinformatics.eml.EMLParser;
import org.ecoinformatics.eml.SAXValidate;
import org.xml.sax.SAXException;

public class EMLParserServlet
extends HttpServlet {
    private ServletConfig servletconfig = null;
    private ServletContext context = null;
    private HttpServletRequest request;
    private static HttpServletResponse response;
    private static PrintWriter out;
    private Hashtable params = new Hashtable();
    private static final String namespaces = "eml://ecoinformatics.org/eml-2.0.0 http://knb.ecoinformatics.org/emlparser/schema/eml-2.0.0/eml.xsd eml://ecoinformatics.org/eml-2.0.1 http://knb.ecoinformatics.org/emlparser/schema/eml-2.0.1/eml.xsd http://www.xml-cml.org/schema/stmml http://knb.ecoinformatics.org/emlparser/schema/eml-2.0.0/stmml.xsd";

    public void init(ServletConfig servletconfig) throws ServletException {
        super.init(servletconfig);
        this.servletconfig = servletconfig;
        this.context = servletconfig.getServletContext();
        System.out.println("Starting EMLParserServlet");
    }

    public void destroy() {
        System.out.println("Destroying EMLParserServlet");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action;
        this.request = request;
        EMLParserServlet.response = response;
        StringBuffer html = new StringBuffer();
        out = response.getWriter();
        String ctype = request.getContentType();
        InputStream fileToParse = null;
        File tempfile = null;
        html.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD html 4.0//EN\">");
        html.append("<html>");
        html.append("<head>");
        html.append("<title>EML ID and References Parser</title>");
        html.append("<link rel=\"stylesheet\" type=\"text/css\" ");
        html.append("href=\"http://knb.ecoinformatics.org/default.css\">");
        html.append("</head>");
        html.append("<body>");
        html.append("<table class=\"tabledefault\" width=\"100%\">");
        html.append("<tbody>");
        html.append("<tr>");
        html.append("<td rowspan=\"2\">");
        html.append("<img src=\"http://knb.ecoinformatics.org/images/KNBLogo.gif\">");
        html.append("</td>");
        html.append("<td colspan=\"7\"><div class=\"title\">");
        html.append("EML ID and References Parser</div></td>");
        html.append("</tr>");
        html.append("<tr>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/\" ");
        html.append("class=\"toollink\"> KNB Home </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/data.html\" ");
        html.append("class=\"toollink\"> Data </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/people.html\" ");
        html.append("class=\"toollink\"> People </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/informatics\" ");
        html.append("class=\"toollink\"> Informatics </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/biodiversity\" ");
        html.append("class=\"toollink\"> Biocomplexity </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/education\" ");
        html.append("class=\"toollink\"> Education </a></td>");
        html.append("<td><a href=\"http://knb.ecoinformatics.org/software\" ");
        html.append("class=\"toollink\"> Software </a></td>");
        html.append("</tr>");
        html.append("</tbody>");
        html.append("</table>");
        html.append("<hr>");
        HttpSession sess = request.getSession(true);
        String sess_id = "";
        try {
            sess_id = sess.getId();
        }
        catch (IllegalStateException ise) {
            System.out.println("error in handleGetOrPost: this shouldn't happen: the session should be valid: " + ise.getMessage());
        }
        File tempdir = new File("/tmp/emlparser");
        if (!tempdir.exists()) {
            tempdir.mkdirs();
        }
        tempfile = new File("/tmp/emlparser/.tmpfile." + sess_id);
        if (ctype != null && ctype.startsWith("multipart/form-data")) {
            try {
                fileToParse = this.handleGetFile(request, response);
                int c = fileToParse.read();
                FileOutputStream fos = new FileOutputStream(tempfile);
                while (c != -1) {
                    fos.write(c);
                    c = fileToParse.read();
                }
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                out.println("<html><body><h1>Error handling multipart data: " + e.getMessage() + "</h1></body></html>");
                System.out.println("Error handling multipart data: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            Enumeration paramlist = request.getParameterNames();
            while (paramlist.hasMoreElements()) {
                String name = (String)paramlist.nextElement();
                String[] value = request.getParameterValues(name);
                this.params.put(name, value);
            }
        }
        if ((action = ((String[])this.params.get("action"))[0]).equals("parse")) {
            html.append(this.parse(tempfile));
        } else if (action.equals("textparse")) {
            String doctext = ((String[])this.params.get("doctext"))[0];
            if (doctext == null || doctext.trim().equals("")) {
                html.append("<h2>Error.  Submitted document is null.</h2>");
            } else {
                StringReader sr = new StringReader(doctext);
                FileWriter fw = new FileWriter(tempfile);
                int c = sr.read();
                while (c != -1) {
                    fw.write(c);
                    c = sr.read();
                }
                fw.flush();
                fw.close();
                html.append(this.parse(tempfile));
            }
        } else {
            html.append("<h2>Error.  Action '").append(action);
            html.append("' not registered</h2>");
        }
        tempfile.delete();
        html.append("<hr><a href=\"/emlparser\">Back</a> to the previous page.");
        html.append("</body></html>");
        response.setContentType("text/html");
        out.println(html.toString());
        out.flush();
    }

    private String parse(File tempfile) {
        StringBuffer html = new StringBuffer();
        try {
            if (tempfile != null) {
                EMLParser parser = new EMLParser(tempfile, new File("/var/www/org.ecoinformatics.knb/emlparser/lib/config.xml"));
                html.append("<h2>Document is EML valid.</h2><p>There ");
                html.append("were no EML errors found in your document.</p>");
            } else {
                html.append("<h2>Error: The file sent to the parser was null.</h2>");
            }
        }
        catch (Exception e) {
            html.append("<h2>EML Errors Found</h2><p>The following errors were found:");
            html.append("</p><p>").append(e.getMessage()).append("</p>");
        }
        try {
            SAXValidate validator = new SAXValidate(true);
            validator.runTest(new FileReader(tempfile), "DEFAULT", namespaces);
            html.append("<hr><h2>Document is XML-schema valid.</h2>");
            html.append("<p>There were no XML errors found in your document.</p>");
        }
        catch (IOException ioe) {
            html.append("<hr><h2>IOException: Error reading file</h2>");
            html.append("<p>").append(ioe.getMessage()).append("</p>");
        }
        catch (ClassNotFoundException cnfe) {
            html.append("<hr><h2>Parser class not found</h2>");
            html.append("<p>").append(cnfe.getMessage()).append("</p>");
        }
        catch (SAXException se) {
            if (se.getMessage().indexOf("WARNING") != -1) {
                html.append("<hr><h2>XML-Schema Warning</h2><p>The following warnings ");
                html.append("were issued about your document: </p><p>");
                html.append(se.getMessage()).append("</p>");
            }
            html.append("<hr><h2>XML-Schema Errors Found</h2><p>");
            html.append("The following errors were ");
            html.append("found:</p><p>").append(se.getMessage()).append("</p>");
        }
        return html.toString();
    }

    private InputStream handleGetFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Part part;
        Hashtable<String, FilePart> fileList = new Hashtable<String, FilePart>();
        MultipartParser mp = new MultipartParser(request, 0x800000);
        while ((part = mp.readNextPart()) != null) {
            String name = part.getName();
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue();
                String[] s = new String[]{value};
                this.params.put(name, s);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            fileList.put(name, filePart);
            break;
        }
        FilePart fp = (FilePart)fileList.get("filename");
        return fp.getInputStream();
    }

    static {
        out = null;
    }
}

