/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import com.nwalsh.xalan.FormatCallout;
import com.nwalsh.xalan.FormatDingbatCallout;
import com.nwalsh.xalan.FormatGraphicCallout;
import com.nwalsh.xalan.FormatTextCallout;
import com.nwalsh.xalan.FormatUnicodeCallout;
import com.nwalsh.xalan.Params;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Verbatim {
    private Stack elementStack = null;
    private Stack tempStack = null;
    private int lineNumber = 0;
    private int colNumber = 0;
    private int modulus = 0;
    private int width = 0;
    private String separator = "";
    private Callout[] callout = null;
    private int calloutCount = 0;
    private int calloutPos = 0;
    private String graphicsPath = null;
    private String graphicsExt = null;
    private int graphicsMax = 10;
    private boolean graphicsFO = false;
    private static final String foURI = "http://www.w3.org/1999/XSL/Format";
    private static final String xhURI = "http://www.w3.org/1999/xhtml";

    private void addCallout(int coNum, Node node, int defaultColumn) {
        Element area = (Element)node;
        String units = area.getAttribute("units");
        String otherUnits = area.getAttribute("otherunits");
        String coords = area.getAttribute("coords");
        int type = 0;
        String otherType = null;
        if (units == null || units.equals("linecolumn")) {
            type = 2;
        } else if (units.equals("linerange")) {
            type = 4;
        } else if (units.equals("linecolumnpair")) {
            type = 3;
        } else if (units.equals("calspair")) {
            type = 1;
        } else {
            type = 5;
            otherType = otherUnits;
        }
        if (type != 2 && type != 4) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (coords == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer st = new StringTokenizer(coords);
        int tokenCount = 0;
        int c1 = 0;
        int c2 = 0;
        while (st.hasMoreTokens()) {
            if (++tokenCount > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                int coord;
                String token = st.nextToken();
                c2 = coord = Integer.parseInt(token);
                if (tokenCount != 1) continue;
                c1 = coord;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (this.calloutCount == this.callout.length) {
            Callout[] bigger = new Callout[this.calloutCount + 10];
            int count = 0;
            while (count < this.callout.length) {
                bigger[count] = this.callout[count];
                ++count;
            }
            this.callout = bigger;
        }
        if (tokenCount == 2) {
            if (type == 4) {
                int count = c1;
                while (count <= c2) {
                    this.callout[this.calloutCount++] = new Callout(coNum, area, count, defaultColumn, type);
                    ++count;
                }
            } else {
                this.callout[this.calloutCount++] = new Callout(coNum, area, c1, c2, type);
            }
        } else {
            this.callout[this.calloutCount++] = new Callout(coNum, area, c1, defaultColumn, type);
        }
    }

    private void calloutFragment(DOMBuilder rtf, Node node, FormatCallout fCallout) {
        try {
            char[] chars;
            String text;
            String name;
            String localName;
            String ns;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                Node child = node.getFirstChild();
                while (child != null) {
                    this.calloutFragment(rtf, child, fCallout);
                    child = child.getNextSibling();
                }
            } else if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.startElement(ns, localName, name, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                Node child = node.getFirstChild();
                while (child != null) {
                    this.calloutFragment(rtf, child, fCallout);
                    child = child.getNextSibling();
                }
            } else if (node.getNodeType() == 3) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                int pos = 0;
                int count = 0;
                while (count < text.length()) {
                    if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        this.closeOpenElements(rtf);
                        while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                            fCallout.formatCallout(rtf, this.callout[this.calloutPos]);
                            ++this.calloutPos;
                        }
                        this.openClosedElements(rtf);
                    }
                    if (text.charAt(count) == '\n') {
                        if (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                            if (pos > 0) {
                                rtf.characters(chars, 0, pos);
                                pos = 0;
                            }
                            this.closeOpenElements(rtf);
                            while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() > this.colNumber) {
                                this.formatPad(rtf, this.callout[this.calloutPos].getColumn() - this.colNumber);
                                this.colNumber = this.callout[this.calloutPos].getColumn();
                                while (this.calloutPos < this.calloutCount && this.callout[this.calloutPos].getLine() == this.lineNumber && this.callout[this.calloutPos].getColumn() == this.colNumber) {
                                    fCallout.formatCallout(rtf, this.callout[this.calloutPos]);
                                    ++this.calloutPos;
                                }
                            }
                            this.openClosedElements(rtf);
                        }
                        ++this.lineNumber;
                        this.colNumber = 1;
                    } else {
                        ++this.colNumber;
                    }
                    chars[pos++] = text.charAt(count);
                    ++count;
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in calloutFragment: " + node.getNodeType() + ": " + node.getNodeName());
            }
            if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.endElement(ns, localName, name);
                this.elementStack.pop();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in calloutFragment");
        }
    }

    private void closeOpenElements(DOMBuilder rtf) throws SAXException {
        this.tempStack = new Stack();
        while (!this.elementStack.empty()) {
            Node elem = (Node)this.elementStack.pop();
            String ns = elem.getNamespaceURI();
            String localName = elem.getLocalName();
            String name = ((Element)elem).getTagName();
            if (this.elementStack.empty() && (ns != null && ns.equals(foURI) && localName.equals("block") || ns == null && localName.equalsIgnoreCase("pre") || ns != null && ns.equals(xhURI) && localName.equals("pre") || ns == null && localName.equalsIgnoreCase("div") || ns != null && ns.equals(xhURI) && localName.equals("div"))) {
                this.elementStack.push(elem);
                break;
            }
            rtf.endElement(ns, localName, name);
            this.tempStack.push(elem);
        }
    }

    private Attributes copyAttributes(Element node) {
        AttributesImpl attrs = new AttributesImpl();
        NamedNodeMap nnm = node.getAttributes();
        int count = 0;
        while (count < nnm.getLength()) {
            Attr attr = (Attr)nnm.item(count);
            String name = attr.getName();
            if (!name.startsWith("xmlns:") && !name.equals("xmlns")) {
                attrs.addAttribute(attr.getNamespaceURI(), attr.getName(), attr.getName(), "CDATA", attr.getValue());
            }
            ++count;
        }
        return attrs;
    }

    private int countLineBreaks(Node node) {
        int numLines;
        block4: {
            block3: {
                numLines = 0;
                if (node.getNodeType() != 11 && node.getNodeType() != 9 && node.getNodeType() != 1) break block3;
                Node child = node.getFirstChild();
                while (child != null) {
                    numLines += this.countLineBreaks(child);
                    child = child.getNextSibling();
                }
                break block4;
            }
            if (node.getNodeType() != 3) break block4;
            String text = node.getNodeValue();
            boolean pos = false;
            int count = 0;
            while (count < text.length()) {
                if (text.charAt(count) == '\n') {
                    ++numLines;
                }
                ++count;
            }
        }
        return numLines;
    }

    private void formatLineNumber(DOMBuilder rtf, int lineNumber) {
        char ch = '\u00a0';
        String lno = "";
        if (lineNumber == 1 || this.modulus >= 1 && lineNumber % this.modulus == 0) {
            lno = String.valueOf(lineNumber);
        }
        while (lno.length() < this.width) {
            lno = String.valueOf(ch) + lno;
        }
        lno = String.valueOf(lno) + this.separator;
        char[] chars = lno.toCharArray();
        try {
            rtf.characters(chars, 0, lno.length());
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatLineNumber");
        }
    }

    private void formatPad(DOMBuilder rtf, int numBlanks) {
        char[] chars = new char[numBlanks];
        int count = 0;
        while (count < numBlanks) {
            chars[count] = 32;
            ++count;
        }
        try {
            rtf.characters(chars, 0, numBlanks);
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in formatCallout");
        }
    }

    public DocumentFragment insertCallouts(ExpressionContext context, NodeIterator areaspecNodeSet, NodeIterator xalanNI) {
        String type = Params.getString(context, "stylesheet.result.type");
        boolean useFO = type.equals("fo");
        int defaultColumn = Params.getInt(context, "callout.defaultcolumn");
        if (Params.getBoolean(context, "callout.graphics")) {
            String gPath = Params.getString(context, "callout.graphics.path");
            String gExt = Params.getString(context, "callout.graphics.extension");
            int gMax = Params.getInt(context, "callout.graphics.number.limit");
            return this.insertGraphicCallouts(areaspecNodeSet, xalanNI, defaultColumn, gPath, gExt, gMax, useFO);
        }
        if (Params.getBoolean(context, "callout.unicode")) {
            int uStart = Params.getInt(context, "callout.unicode.start.character");
            int uMax = Params.getInt(context, "callout.unicode.number.limit");
            return this.insertUnicodeCallouts(areaspecNodeSet, xalanNI, defaultColumn, uStart, uMax, useFO);
        }
        if (Params.getBoolean(context, "callout.dingbats")) {
            int dMax = 10;
            return this.insertDingbatCallouts(areaspecNodeSet, xalanNI, defaultColumn, dMax, useFO);
        }
        return this.insertTextCallouts(areaspecNodeSet, xalanNI, defaultColumn, useFO);
    }

    public DocumentFragment insertCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, FormatCallout fCallout) {
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        this.callout = new Callout[10];
        this.calloutCount = 0;
        this.calloutPos = 0;
        this.lineNumber = 1;
        this.colNumber = 1;
        boolean pos = false;
        int coNum = 0;
        boolean inAreaSet = false;
        Node node = areaspecNodeSet.nextNode();
        node = node.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("areaset")) {
                    ++coNum;
                    Node area = node.getFirstChild();
                    while (area != null) {
                        if (area.getNodeType() == 1) {
                            if (area.getNodeName().equals("area")) {
                                this.addCallout(coNum, area, defaultColumn);
                            } else {
                                System.out.println("Unexpected element in areaset: " + area.getNodeName());
                            }
                        }
                        area = area.getNextSibling();
                    }
                } else if (node.getNodeName().equalsIgnoreCase("area")) {
                    this.addCallout(++coNum, node, defaultColumn);
                } else {
                    System.out.println("Unexpected element in areaspec: " + node.getNodeName());
                }
            }
            node = node.getNextSibling();
        }
        Arrays.sort(this.callout, 0, this.calloutCount);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("PCE 2!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder db = new DOMBuilder(doc, df);
        this.elementStack = new Stack();
        this.calloutFragment(db, xalanRTF, fCallout);
        return df;
    }

    public DocumentFragment insertDingbatCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, int gMax, boolean useFO) {
        FormatDingbatCallout fdc = new FormatDingbatCallout(gMax, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fdc);
    }

    public DocumentFragment insertGraphicCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, String gPath, String gExt, int gMax, boolean useFO) {
        FormatGraphicCallout fgc = new FormatGraphicCallout(gPath, gExt, gMax, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fgc);
    }

    public DocumentFragment insertTextCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, boolean useFO) {
        FormatTextCallout ftc = new FormatTextCallout(useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, ftc);
    }

    public DocumentFragment insertUnicodeCallouts(NodeIterator areaspecNodeSet, NodeIterator xalanNI, int defaultColumn, int uStart, int uMax, boolean useFO) {
        FormatUnicodeCallout fuc = new FormatUnicodeCallout(uStart, uMax, useFO);
        return this.insertCallouts(areaspecNodeSet, xalanNI, defaultColumn, fuc);
    }

    private void lineNumberFragment(DOMBuilder rtf, Node node) {
        try {
            char[] chars;
            String text;
            String name;
            String localName;
            String ns;
            if (node.getNodeType() == 11 || node.getNodeType() == 9) {
                Node child = node.getFirstChild();
                while (child != null) {
                    this.lineNumberFragment(rtf, child);
                    child = child.getNextSibling();
                }
            } else if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.startElement(ns, localName, name, this.copyAttributes((Element)node));
                this.elementStack.push(node);
                Node child = node.getFirstChild();
                while (child != null) {
                    this.lineNumberFragment(rtf, child);
                    child = child.getNextSibling();
                }
            } else if (node.getNodeType() == 3) {
                text = node.getNodeValue();
                if (this.lineNumber == 0) {
                    this.formatLineNumber(rtf, ++this.lineNumber);
                }
                chars = text.toCharArray();
                int pos = 0;
                int count = 0;
                while (count < text.length()) {
                    if (text.charAt(count) == '\n') {
                        if (pos > 0) {
                            rtf.characters(chars, 0, pos);
                            pos = 0;
                        }
                        this.closeOpenElements(rtf);
                        chars[pos++] = text.charAt(count);
                        rtf.characters(chars, 0, pos);
                        pos = 0;
                        this.formatLineNumber(rtf, ++this.lineNumber);
                        this.openClosedElements(rtf);
                    } else {
                        chars[pos++] = text.charAt(count);
                    }
                    ++count;
                }
                if (pos > 0) {
                    rtf.characters(chars, 0, pos);
                }
            } else if (node.getNodeType() == 8) {
                text = node.getNodeValue();
                chars = text.toCharArray();
                rtf.comment(chars, 0, text.length());
            } else if (node.getNodeType() == 7) {
                rtf.processingInstruction(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Warning: unexpected node type in lineNumberFragment");
            }
            if (node.getNodeType() == 1) {
                ns = node.getNamespaceURI();
                localName = node.getLocalName();
                name = ((Element)node).getTagName();
                rtf.endElement(ns, localName, name);
                this.elementStack.pop();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAX Exception in lineNumberFragment");
        }
    }

    public DocumentFragment numberLines(ExpressionContext context, NodeIterator xalanNI) {
        int xalanMod = Params.getInt(context, "linenumbering.everyNth");
        int xalanWidth = Params.getInt(context, "linenumbering.width");
        String xalanSep = Params.getString(context, "linenumbering.separator");
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        int numLines = this.countLineBreaks(xalanRTF) + 1;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("PCE!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder db = new DOMBuilder(doc, df);
        this.elementStack = new Stack();
        this.lineNumber = 0;
        this.modulus = numLines < xalanMod ? 1 : xalanMod;
        this.width = xalanWidth;
        this.separator = xalanSep;
        double log10numLines = Math.log(numLines) / Math.log(10.0);
        if ((double)this.width < log10numLines + 1.0) {
            this.width = (int)Math.floor(log10numLines + 1.0);
        }
        this.lineNumberFragment(db, xalanRTF);
        return df;
    }

    private void openClosedElements(DOMBuilder rtf) throws SAXException {
        while (!this.tempStack.empty()) {
            Node elem = (Node)this.tempStack.pop();
            String ns = elem.getNamespaceURI();
            String localName = elem.getLocalName();
            String name = ((Element)elem).getTagName();
            NamedNodeMap domAttr = elem.getAttributes();
            AttributesImpl attr = new AttributesImpl();
            int acount = 0;
            while (acount < domAttr.getLength()) {
                Node a = domAttr.item(acount);
                if ((ns != null && ns != xhURI || !localName.equalsIgnoreCase("a")) && !a.getLocalName().equalsIgnoreCase("id")) {
                    attr.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getNodeName(), "CDATA", a.getNodeValue());
                }
                ++acount;
            }
            rtf.startElement(ns, localName, name, (Attributes)attr);
            this.elementStack.push(elem);
        }
        this.tempStack = null;
    }
}

