/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;

public class TagUtils {
    private static final String DEFAULT_ATTRIBUTE_SEPARATOR = "; ";
    public static final IValueMap ATTRIBUTES_SEPARATORS = new ValueMap();

    public static final boolean isBodyTag(ComponentTag tag) {
        return "body".equalsIgnoreCase(tag.getName()) && tag.getNamespace() == null;
    }

    public static final boolean isHeadTag(MarkupElement elem) {
        ComponentTag tag;
        return elem instanceof ComponentTag && "head".equalsIgnoreCase((tag = (ComponentTag)elem).getName()) && tag.getNamespace() == null;
    }

    public static final boolean isWicketTag(IMarkupFragment markup, int i) {
        MarkupElement elem = markup.get(i);
        return elem instanceof WicketTag;
    }

    public static final boolean isExtendTag(IMarkupFragment markup, int i) {
        MarkupElement elem = markup.get(i);
        if (elem instanceof WicketTag) {
            WicketTag wtag = (WicketTag)elem;
            return wtag.isExtendTag();
        }
        return false;
    }

    public static final boolean isWicketHeadTag(MarkupElement elem) {
        WicketTag wtag;
        return elem instanceof WicketTag && (wtag = (WicketTag)elem).isHeadTag();
    }

    public static final boolean isWicketBodyTag(MarkupElement elem) {
        WicketTag wtag;
        return elem instanceof WicketTag && (wtag = (WicketTag)elem).isBodyTag();
    }

    public static final boolean isWicketBorderTag(MarkupElement elem) {
        WicketTag wtag;
        return elem instanceof WicketTag && (wtag = (WicketTag)elem).isBorderTag();
    }

    public static void copyAttributes(MarkupContainer component, ComponentTag tag) {
        IMarkupFragment markup = component.getMarkup(null);
        String namespace = markup.getMarkupResourceStream().getWicketNamespace() + ":";
        MarkupElement elem = markup.get(0);
        if (elem instanceof ComponentTag) {
            ComponentTag panelTag = (ComponentTag)elem;
            for (String key : panelTag.getAttributes().keySet()) {
                if (key.startsWith(namespace)) continue;
                String separator = ATTRIBUTES_SEPARATORS.getString(key, DEFAULT_ATTRIBUTE_SEPARATOR);
                tag.append(key, panelTag.getAttribute(key), separator);
            }
        } else {
            throw new MarkupException(markup.getMarkupResourceStream(), "Expected a Tag but found raw markup: " + elem.toString());
        }
    }

    static {
        ATTRIBUTES_SEPARATORS.put((Object)"class", (Object)" ");
        ATTRIBUTES_SEPARATORS.put((Object)"style", (Object)DEFAULT_ATTRIBUTE_SEPARATOR);
        ATTRIBUTES_SEPARATORS.put((Object)"onclick", (Object)DEFAULT_ATTRIBUTE_SEPARATOR);
    }
}

