/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class MakeProjectionDictionary {
    public static String[][] unitNames = new String[8][2];
    public static Element root = new Element("projectionList", Namespace.getNamespace((String)"sp", (String)"eml://ecoinformatics.org/spatialReference-2.0.0"));
    public static Document XMLDoc = new Document(root);

    public static void main(String[] args) throws IOException {
        MakeProjectionDictionary.unitNames[0][0] = "Meter";
        MakeProjectionDictionary.unitNames[0][1] = "meter";
        MakeProjectionDictionary.unitNames[1][0] = "Foot_US";
        MakeProjectionDictionary.unitNames[1][1] = "Foot_US";
        MakeProjectionDictionary.unitNames[2][0] = "Grad";
        MakeProjectionDictionary.unitNames[2][1] = "gradient";
        MakeProjectionDictionary.unitNames[3][0] = "Degree";
        MakeProjectionDictionary.unitNames[3][1] = "degree";
        MakeProjectionDictionary.unitNames[4][0] = "Foot_Gold_Coast";
        MakeProjectionDictionary.unitNames[4][1] = "Foot_Gold_Coast";
        MakeProjectionDictionary.unitNames[5][0] = "Yard_Indian";
        MakeProjectionDictionary.unitNames[5][1] = "Yard_Indian";
        MakeProjectionDictionary.unitNames[6][0] = "Yard_Sears";
        MakeProjectionDictionary.unitNames[6][1] = "Yard_Sears";
        MakeProjectionDictionary.unitNames[7][0] = "Link_Clarke";
        MakeProjectionDictionary.unitNames[7][1] = "Link_Clarke";
        root.setAttribute("schemaLocation", "eml://ecoinformatics.org/spatialReference-2.0.0 eml-spatialReference.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        if (args.length == 1) {
            MakeProjectionDictionary.processPrjFiles(args[0]);
            File outFilePath = new File(args[0].concat("\\eml-spatialReferenceDictionary.xml"));
            FileWriter writer = new FileWriter(outFilePath);
            XMLOutputter outputter = new XMLOutputter("  ", true);
            outputter.output(XMLDoc, (Writer)writer);
        } else {
            System.out.print("usage: java MakeProjectionDictionary path\n");
        }
    }

    public static void processPrjFiles(String filePath) {
        try {
            File file = new File(filePath);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    MakeProjectionDictionary.processPrjFiles(files[i].getPath());
                    ++i;
                }
            } else if (file.getName().endsWith(".prj")) {
                MakeProjectionDictionary.addProjection(file.getPath(), root);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void addProjection(String filePath, Element root) {
        File file = new File(filePath);
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String readline = br.readLine();
            int i = 0;
            StringTokenizer tokens = new StringTokenizer(readline, "[]\",", false);
            Element horizsys = new Element("horizCoordSysDef");
            int howManyTokens = tokens.countTokens();
            if (tokens.nextToken().equalsIgnoreCase("PROJCS")) {
                String unitName;
                Element unit;
                Element projcs = new Element("projCoordSys");
                horizsys.setAttribute("name", tokens.nextToken());
                if (tokens.nextToken().equalsIgnoreCase("GEOGCS")) {
                    Element geogcs = new Element("geogCoordSys");
                    geogcs.setAttribute("name", tokens.nextToken());
                    if (tokens.nextToken().equalsIgnoreCase("DATUM")) {
                        geogcs.addContent(new Element("datum").setAttribute("name", tokens.nextToken()));
                    } else {
                        System.out.print("Didnt find DATUM\n");
                    }
                    if (tokens.nextToken().equalsIgnoreCase("SPHEROID")) {
                        Element spheroid = new Element("spheroid");
                        spheroid.setAttribute("name", tokens.nextToken());
                        spheroid.setAttribute("semiAxisMajor", tokens.nextToken());
                        spheroid.setAttribute("denomFlatRatio", tokens.nextToken());
                        geogcs.addContent(spheroid);
                    } else {
                        System.out.print("Didnt find SPHEROID\n");
                    }
                    if (tokens.nextToken().equalsIgnoreCase("PRIMEM")) {
                        Element primem = new Element("primeMeridian");
                        primem.setAttribute("name", tokens.nextToken());
                        primem.setAttribute("longitude", tokens.nextToken());
                        geogcs.addContent(primem);
                    } else {
                        System.out.print("Didnt find PRIMEM\n");
                    }
                    if (tokens.nextToken().equalsIgnoreCase("UNIT")) {
                        unit = new Element("unit");
                        unitName = tokens.nextToken();
                        i = 0;
                        while (i < unitNames.length / 2) {
                            if (unitNames[i][0].equalsIgnoreCase(unitName)) {
                                unit.setAttribute("name", unitNames[i][1]);
                                i = unitNames.length / 2;
                            }
                            ++i;
                        }
                        geogcs.addContent(unit);
                    } else {
                        System.out.print("Didnt find UNIT\n");
                    }
                    projcs.addContent(geogcs);
                } else {
                    System.out.print("Didnt find GEOGCS\n");
                }
                if (tokens.nextToken().equalsIgnoreCase("PROJECTION")) {
                    Element project = new Element("projection");
                    project.setAttribute("name", tokens.nextToken());
                    while (tokens.nextToken().equalsIgnoreCase("PARAMETER")) {
                        Element param = new Element("parameter");
                        param.setAttribute("name", tokens.nextToken());
                        param.setAttribute("value", tokens.nextToken());
                        project.addContent(param);
                    }
                    unit = new Element("unit");
                    unitName = tokens.nextToken();
                    i = 0;
                    while (i < unitNames.length / 2) {
                        if (unitNames[i][0].equalsIgnoreCase(unitName)) {
                            unit.setAttribute("name", unitNames[i][1]);
                            i = unitNames.length / 2;
                        }
                        ++i;
                    }
                    project.addContent(unit);
                    projcs.addContent(project);
                }
                horizsys.addContent(projcs);
            } else {
                Element geogcs = new Element("geogCoordSys");
                String sysname = tokens.nextToken();
                horizsys.setAttribute("name", sysname);
                geogcs.setAttribute("name", sysname);
                if (tokens.nextToken().equalsIgnoreCase("DATUM")) {
                    geogcs.addContent(new Element("datum").setAttribute("name", tokens.nextToken()));
                } else {
                    System.out.print("Didnt find DATUM\n");
                }
                if (tokens.nextToken().equalsIgnoreCase("SPHEROID")) {
                    Element spheroid = new Element("spheroid");
                    spheroid.setAttribute("name", tokens.nextToken());
                    spheroid.setAttribute("semiAxisMajor", tokens.nextToken());
                    spheroid.setAttribute("denomFlatRatio", tokens.nextToken());
                    geogcs.addContent(spheroid);
                } else {
                    System.out.print("Didnt find SPHEROID\n");
                }
                if (tokens.nextToken().equalsIgnoreCase("PRIMEM")) {
                    Element primem = new Element("primeMeridian");
                    primem.setAttribute("name", tokens.nextToken());
                    primem.setAttribute("longitude", tokens.nextToken());
                    geogcs.addContent(primem);
                } else {
                    System.out.print("Didnt find PRIMEM\n");
                }
                if (tokens.nextToken().equalsIgnoreCase("UNIT")) {
                    Element unit = new Element("unit");
                    String unitName = tokens.nextToken();
                    i = 0;
                    while (i < unitNames.length / 2) {
                        if (unitNames[i][0].equalsIgnoreCase(unitName)) {
                            unit.setAttribute("name", unitNames[i][1]);
                            i = unitNames.length / 2;
                        }
                        ++i;
                    }
                    geogcs.addContent(unit);
                } else {
                    System.out.print("Didnt find UNIT\n");
                }
                horizsys.addContent(geogcs);
            }
            root.addContent(horizsys);
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }
}

