/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.EMLParser;

public class EMLParserTest
extends TestCase {
    private static final String VALID = "test/eml.xml";
    private static final String ERROR1 = "test/eml-error1.xml";
    private static final String ERROR3 = "test/eml-error3.xml";
    private static final String ERROR4 = "test/eml-error4.xml";
    private EMLParser emlp;

    public EMLParserTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EMLParserTest("initialize"));
        suite.addTest((Test)new EMLParserTest("testParse"));
        return suite;
    }

    public void initialize() {
        Assert.assertTrue((boolean)true);
    }

    public void testParse() {
        File f;
        try {
            f = new File(VALID);
            this.emlp = new EMLParser(f);
        }
        catch (Exception e) {
            Assert.fail((String)("Error.  This file should have parsed correctly: " + e.getMessage()));
        }
        try {
            f = new File(ERROR1);
            this.emlp = new EMLParser(f);
            Assert.fail((String)"Error 1. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((e.getMessage().indexOf("Error in xml document.  This EML document is not valid because the id 23445 occurs more than once.  IDs must be unique.") != -1 ? 1 : 0) != 0);
        }
        try {
            f = new File(ERROR3);
            this.emlp = new EMLParser(f);
            Assert.fail((String)"Error 3. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Error processing keyrefs: //references : Error in xml document. This EML instance is invalid because referenced id 23447 does not exist in the given keys."));
        }
        try {
            f = new File(ERROR4);
            this.emlp = new EMLParser(f);
            Assert.fail((String)"Error 3. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Error processing keyrefs: //references : Error in xml document. This EML instance is invalid because this element has an id and it is being used in a keyref expression."));
        }
    }
}

