/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.SAXValidate;
import org.xml.sax.SAXParseException;

public class SaxValidateTest
extends TestCase {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String TEST_DIR = "./test";

    public SaxValidateTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void initialize() {
        Assert.assertTrue((boolean)true);
    }

    public void testSchemaValid() {
        SAXValidate test = new SAXValidate(true);
        Assert.assertTrue((test != null ? 1 : 0) != 0);
        File testDir = new File(TEST_DIR);
        Vector fileList = this.getXmlFiles(testDir);
        int i = 0;
        while (i < fileList.size()) {
            File testFile = (File)fileList.elementAt(i);
            try {
                System.err.println("Validating file: " + testFile.getName());
                test.runTest(new FileReader(testFile), DEFAULT_PARSER);
            }
            catch (Exception e) {
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    System.err.println("Error on line: " + spe.getLineNumber());
                }
                e.printStackTrace(System.err);
                Assert.fail((String)("Document NOT valid!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
            ++i;
        }
    }

    public void testDocbook() {
        SAXValidate test = new SAXValidate(false);
        Assert.assertTrue((test != null ? 1 : 0) != 0);
        System.err.println("Validating the docs/eml-2.0.0/eml-docbook.xml file.");
        File f = new File("docs/eml-2.0.0/eml-docbook.xml");
        if (!f.exists()) {
            System.err.println("The file eml-2.0.0/eml-docbook.xml is not in the docs directory.  You must run 'ant docbook' before running this test.");
            Assert.fail((String)"The file eml-2.0.0/eml-docbook.xml is not in the docs directory.  You must run 'ant docbook' before running this test.");
        }
        try {
            test.runTest(new FileReader("docs/eml-2.0.0/eml-docbook.xml"), DEFAULT_PARSER);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.equals("Attribute \"xmlns:xs\" must be declared for element type \"book\".")) {
                System.err.println("eml-docbook.xsl is valid");
            }
            System.err.println("eml-docbook.xsl is NOT valid: " + msg);
            Assert.fail((String)("eml-docbook.xml NOT valid: " + msg));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SaxValidateTest("initialize"));
        suite.addTest((Test)new SaxValidateTest("testSchemaValid"));
        suite.addTest((Test)new SaxValidateTest("testDocbook"));
        return suite;
    }

    private Vector getXmlFiles(File directory) {
        String[] files = directory.list();
        Vector<File> fileList = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            File currentFile = new File(directory, filename);
            if (currentFile.isFile() && filename.endsWith(".xml")) {
                fileList.addElement(currentFile);
            }
            ++i;
        }
        return fileList;
    }
}

