/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.convert;

import java.util.StringTokenizer;
import tmap_30.convert.Convert;

public class ConvertLatitude
extends Convert {
    public static final int M90_90 = 0;
    public static final int N_S = 1;
    public static final int SPACE_N_S = 2;
    public static final int SPACE_NORTH_SOUTH = 3;
    private String[] recognizedUnits = new String[]{"deg", "degrees"};

    public ConvertLatitude() {
        this.setRange(-90.0, 90.0);
    }

    public ConvertLatitude(int n) {
        this();
        this.outputStyle = n;
    }

    public void setOutputStyle(int n) {
        this.outputStyle = n;
    }

    public double toDouble(String string) throws IllegalArgumentException {
        String string2 = new String(string);
        double d = 0.0;
        int n = 1;
        string2 = string2.trim();
        if ((string2 = string2.toUpperCase()).endsWith("N")) {
            n = 1;
            string2 = string2.substring(0, string2.length() - 1).trim();
        } else if (string2.endsWith("S")) {
            n = -1;
            string2 = string2.substring(0, string2.length() - 1).trim();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " +-.0123456789", false);
        if (stringTokenizer.countTokens() > 0) {
            throw new IllegalArgumentException("Bad character in string: \"" + string + "\".");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", false);
        switch (stringTokenizer2.countTokens()) {
            case 1: {
                if (string2.length() > 4 && string2.indexOf(46) == -1) {
                    String string3 = string2.substring(0, string2.length() - 4);
                    String string4 = string2.substring(string2.length() - 4, string2.length() - 2);
                    String string5 = string2.substring(string2.length() - 2, string2.length());
                    try {
                        d = Double.valueOf(string3);
                        d += Double.valueOf(string4) / 60.0;
                        d += Double.valueOf(string5) / 3600.0;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(numberFormatException.toString());
                    }
                }
                try {
                    d = Double.valueOf(string2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            case 2: {
                String string6 = stringTokenizer2.nextToken();
                String string7 = stringTokenizer2.nextToken();
                try {
                    d = Double.valueOf(string6);
                    d += Double.valueOf(string7) / 60.0;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            case 3: {
                String string8 = stringTokenizer2.nextToken();
                String string9 = stringTokenizer2.nextToken();
                String string10 = stringTokenizer2.nextToken();
                try {
                    d = Double.valueOf(string8);
                    d += Double.valueOf(string9) / 60.0;
                    d += Double.valueOf(string10) / 3600.0;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        d *= (double)n;
        d = this.rangeTest(d);
        return d;
    }

    public String toString(double d) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer("");
        if ((d = this.rangeTest(d)) < 0.0) {
            switch (this.outputStyle) {
                case 1: {
                    stringBuffer.append(-d);
                    stringBuffer.append("S");
                    break;
                }
                case 2: {
                    stringBuffer.append(-d);
                    stringBuffer.append(" S");
                    break;
                }
                case 3: {
                    stringBuffer.append(-d);
                    stringBuffer.append(" South");
                    break;
                }
                default: {
                    stringBuffer.append(d);
                    break;
                }
            }
        } else {
            switch (this.outputStyle) {
                case 1: {
                    stringBuffer.append(d);
                    stringBuffer.append("N");
                    break;
                }
                case 2: {
                    stringBuffer.append(d);
                    stringBuffer.append(" N");
                    break;
                }
                case 3: {
                    stringBuffer.append(d);
                    stringBuffer.append(" North");
                    break;
                }
                default: {
                    stringBuffer.append(d);
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }
}

