/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.eml;

import edu.ucsb.nceas.configxml.ConfigXML;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xpath.XPathAPI;
import org.ecoinformatics.eml.EMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EMLParser {
    private String parserName;
    private ConfigXML config;
    private Key[] keys;
    private Keyref[] keyrefs;
    private Hashtable idHash = new Hashtable();
    private Hashtable idrefHash = new Hashtable();
    private File xml;

    public EMLParser(File xml) {
        this.xml = xml;
        URL configFile = this.getClass().getResource("/config.xml");
        try {
            this.config = new ConfigXML(configFile.openStream());
        }
        catch (Exception e) {
            throw new EMLParserException("Config file not found: " + e.getMessage());
        }
        this.parseConfig();
        this.parseKeys();
        this.parseKeyrefs();
    }

    public EMLParser(File xml, File configFile) throws EMLParserException {
        this.xml = xml;
        try {
            this.config = new ConfigXML(configFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new EMLParserException("Config file not found: " + e.getMessage());
        }
        this.parseConfig();
        this.parseKeys();
        this.parseKeyrefs();
    }

    public EMLParser(String xmlString) throws EMLParserException, IOException {
        if (xmlString == null || xmlString.equals("")) {
            throw new EMLParserException("The string need to be parse is null");
        }
        URL configFile = this.getClass().getResource("/config.xml");
        try {
            this.config = new ConfigXML(configFile.openStream());
        }
        catch (Exception e) {
            throw new EMLParserException("Config file not found: " + e.getMessage());
        }
        this.parseConfig();
        this.parseKeys(xmlString);
        this.parseKeyrefs(xmlString);
    }

    private void parseKeys() {
        for (int i = 0; i < this.keys.length; ++i) {
            try {
                NodeList keyNL = EMLParser.getPathContent(new FileInputStream(this.xml), this.keys[i].selector);
                this.parseKeysByNodeList(keyNL, i, this.keys[i].name);
                continue;
            }
            catch (Exception e) {
                throw new EMLParserException("Error running xpath expression: " + this.keys[i].selector + " : " + e.getMessage());
            }
        }
    }

    private void parseKeys(String xmlString) {
        for (int i = 0; i < this.keys.length; ++i) {
            StringReader reader = new StringReader(xmlString);
            try {
                NodeList keyNL = EMLParser.getPathContent(reader, this.keys[i].selector);
                this.parseKeysByNodeList(keyNL, i, this.keys[i].name);
                continue;
            }
            catch (Exception e) {
                throw new EMLParserException("Error running xpath expression: " + this.keys[i].selector + " : " + e.getMessage());
            }
        }
    }

    private void parseKeysByNodeList(NodeList keyNL, int i, String keyname) throws Exception {
        for (int j = 0; j < keyNL.getLength(); ++j) {
            Node n = keyNL.item(j);
            Node id = XPathAPI.selectSingleNode((Node)n, (String)this.keys[i].field);
            if (id == null) continue;
            String idval = this.keys[i].field.indexOf("@") != -1 ? id.getNodeValue() : id.getFirstChild().getNodeValue();
            Object o = this.idHash.get(keyname + "." + idval);
            if (o == null) {
                this.idHash.put(keyname + "." + idval, new Integer(i));
                continue;
            }
            throw new EMLParserException("Error in xml document.  This EML document is not valid because the id " + idval + " occurs " + "more than once.  IDs must be unique.");
        }
    }

    private void parseKeyrefs() {
        for (int i = 0; i < this.keyrefs.length; ++i) {
            try {
                NodeList keyrefNL = EMLParser.getPathContent(new FileInputStream(this.xml), this.keyrefs[i].selector);
                this.parseKeyrefsByNodeList(keyrefNL, i);
                continue;
            }
            catch (Exception e) {
                throw new EMLParserException("Error processing keyrefs: " + this.keyrefs[i].selector + " : " + e.getMessage());
            }
        }
    }

    private void parseKeyrefs(String xmlString) {
        for (int i = 0; i < this.keyrefs.length; ++i) {
            StringReader reader = new StringReader(xmlString);
            try {
                NodeList keyrefNL = EMLParser.getPathContent(reader, this.keyrefs[i].selector);
                this.parseKeyrefsByNodeList(keyrefNL, i);
                continue;
            }
            catch (Exception e) {
                throw new EMLParserException("Error processing keyrefs: " + this.keyrefs[i].selector + " : " + e.getMessage());
            }
        }
    }

    private void parseKeyrefsByNodeList(NodeList keyrefNL, int i) throws Exception {
        for (int j = 0; j < keyrefNL.getLength(); ++j) {
            Node n = keyrefNL.item(j);
            Node id = this.keyrefs[i].field.equals(".") ? n : XPathAPI.selectSingleNode((Node)n, (String)this.keyrefs[i].field);
            if (id == null) continue;
            String idval = this.keyrefs[i].field.indexOf("@") != -1 ? id.getNodeValue() : id.getFirstChild().getNodeValue().trim();
            Object o = this.idHash.get(this.keyrefs[i].refer + "." + idval);
            if (o == null) {
                throw new EMLParserException("Error in xml document. This EML instance is invalid because referenced id " + idval + " does not exist in the given keys.");
            }
            int keyindex = (Integer)o;
            Key referencedKey = this.keys[keyindex];
            if (!referencedKey.name.equals(this.keyrefs[i].refer)) {
                throw new EMLParserException("Error in xml document. This EML instance is invalid because the keyref " + this.keyrefs[i].name + " must refer to a key by the name of " + this.keyrefs[i].refer + ". Instead it points at " + referencedKey.name);
            }
            Node parent = id.getParentNode();
            NamedNodeMap parentAtts = parent.getAttributes();
            for (int k = 0; k < parentAtts.getLength(); ++k) {
                String parentAtt = parentAtts.item(k).getNodeName();
                if (!("@" + parentAtt).equals(referencedKey.field)) continue;
                throw new EMLParserException("Error in xml document. This EML instance is invalid because this element has an id and it is being used in a keyref expression.");
            }
        }
    }

    private static String reverseEngineerPath(Node n) {
        String nodename = n.getNodeName();
        String path = "";
        while (!nodename.equals("#document")) {
            path = nodename + "/" + path;
            n = n.getParentNode();
            nodename = n.getNodeName();
        }
        return "/" + path;
    }

    private Document buildDocumentFromPath(String path) {
        try {
            String node;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringBuffer xml = new StringBuffer();
            Stack<String> s = new Stack<String>();
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreElements()) {
                node = tokenizer.nextToken();
                xml.append("<").append(node).append(">");
                s.push(node);
            }
            while (!s.empty()) {
                node = (String)s.pop();
                xml.append("</").append(node).append(">");
            }
            return builder.parse(new InputSource(new StringReader(xml.toString())));
        }
        catch (Exception e) {
            throw new EMLParserException("Error building document fragment: " + e.getMessage());
        }
    }

    private void resolveKeys() {
    }

    public static NodeList getPathContent(InputStream is, String xpath) throws Exception {
        InputSource in = new InputSource(is);
        return EMLParser.getPathContent(in, xpath);
    }

    public static NodeList getPathContent(StringReader read, String xpath) throws Exception {
        InputSource in = new InputSource(read);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        Document doc = dfactory.newDocumentBuilder().parse(in);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        NodeList nl = XPathAPI.selectNodeList((Node)doc, (String)xpath);
        return nl;
    }

    private static NodeList getPathContent(InputSource in, String xpath) throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        Document doc = dfactory.newDocumentBuilder().parse(in);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        NodeList nl = XPathAPI.selectNodeList((Node)doc, (String)xpath);
        return nl;
    }

    private void parseConfig() {
        try {
            String name;
            int i;
            NodeList keyNL = this.config.getPathContent("//key");
            this.keys = new Key[keyNL.getLength()];
            NodeList keyrefNL = this.config.getPathContent("//keyref");
            this.keyrefs = new Keyref[keyrefNL.getLength()];
            for (i = 0; i < keyNL.getLength(); ++i) {
                name = "";
                String selector = "";
                String field = "";
                Node n = keyNL.item(i);
                NamedNodeMap atts = n.getAttributes();
                Node nameatt = atts.getNamedItem("name");
                name = nameatt.getNodeValue();
                NodeList keychildren = n.getChildNodes();
                for (int j = 0; j < keychildren.getLength(); ++j) {
                    Node kc = keychildren.item(j);
                    if (kc.getNodeName().equals("selector")) {
                        NamedNodeMap selectoratts = kc.getAttributes();
                        Node selectoratt = selectoratts.getNamedItem("xpath");
                        selector = selectoratt.getNodeValue();
                        continue;
                    }
                    if (!kc.getNodeName().equals("field")) continue;
                    NamedNodeMap fieldatts = kc.getAttributes();
                    Node fieldatt = fieldatts.getNamedItem("xpath");
                    field = fieldatt.getNodeValue();
                }
                if (name.equals("") | selector.equals("") | field.equals("")) {
                    throw new EMLParserException("Error in config file.  All keys must have a name, selector and field.");
                }
                this.keys[i] = new Key(name, selector, field);
            }
            for (i = 0; i < keyrefNL.getLength(); ++i) {
                name = "";
                String refer = "";
                String selector = "";
                String field = "";
                Node n = keyrefNL.item(i);
                NamedNodeMap atts = n.getAttributes();
                Node nameatt = atts.getNamedItem("name");
                name = nameatt.getNodeValue();
                Node referatt = atts.getNamedItem("refer");
                refer = referatt.getNodeValue();
                NodeList keychildren = n.getChildNodes();
                for (int j = 0; j < keychildren.getLength(); ++j) {
                    Node kc = keychildren.item(j);
                    if (kc.getNodeName().equals("selector")) {
                        NamedNodeMap selectoratts = kc.getAttributes();
                        Node selectoratt = selectoratts.getNamedItem("xpath");
                        selector = selectoratt.getNodeValue();
                        continue;
                    }
                    if (!kc.getNodeName().equals("field")) continue;
                    NamedNodeMap fieldatts = kc.getAttributes();
                    Node fieldatt = fieldatts.getNamedItem("xpath");
                    field = fieldatt.getNodeValue();
                }
                if (name.equals("") | selector.equals("") | field.equals("") | refer.equals("")) {
                    throw new EMLParserException("Error in config file.  All keys must have a name, selector and field.");
                }
                this.keyrefs[i] = new Keyref(name, refer, selector, field);
            }
        }
        catch (Exception e) {
            throw new EMLParserException("Error parsing keys and keyrefs in config file: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && !args[0].equals("-q")) {
            System.out.println("EML Parser version 1.0");
            System.out.println("Note that this parser DOES NOT VALIDATE your eml file ");
            System.out.println("agains the schema.  It only validates the ids and ");
            System.out.println("references. To validate your eml file against the ");
            System.out.println("schema, use SAXValidate or another xml parser.");
            System.out.println("Usage: java org.ecoinformatics.eml.EMLParser [-q] [<config file>] <eml file>");
            System.out.println("-----------------------------------------------------------------------");
        }
        if (args.length > 3) {
            System.out.println("Invalid number of arguments.");
        }
        String configfile = "";
        String emlfile = "";
        if (args.length == 3) {
            configfile = args[1];
            emlfile = args[2];
            System.out.println("emlfile: " + emlfile + " configfile: " + configfile);
        } else if (args.length == 2) {
            if (args[0].equals("-q")) {
                emlfile = args[1];
            } else {
                configfile = args[0];
                emlfile = args[1];
            }
        } else if (args.length == 1) {
            emlfile = args[0];
        } else if (args.length == 0) {
            System.out.println("Usage: java org.ecoinformatics.eml.EMLParser [-q] [<config file>] <eml file>");
            System.out.println("  -q = quiet mode, little or no output");
            System.out.println("  <config file> = use an alternate config file.  The default is lib/config.xml");
            System.out.println("  <eml file> = the EML file to parse");
            System.exit(0);
        }
        try {
            if (configfile.equals("")) {
                EMLParser parser = new EMLParser(new File(emlfile));
                FileReader xmldoc = new FileReader(emlfile);
                char[] ch = new char[4096];
                StringWriter writer = new StringWriter();
                int readNum = xmldoc.read(ch);
                while (readNum != -1) {
                    writer.write(ch, 0, readNum);
                    readNum = xmldoc.read(ch);
                }
                String str = writer.toString();
                EMLParser readerParser = new EMLParser(str);
            } else {
                EMLParser parser = new EMLParser(new File(emlfile), new File(configfile));
            }
            System.out.println(emlfile + " has valid ids and references.");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    private class Keyref {
        protected String name;
        protected String refer;
        protected String selector;
        protected String field;

        Keyref(String name, String refer, String selector, String field) {
            this.name = name;
            this.refer = refer;
            this.selector = selector;
            this.field = field;
        }

        public String toString() {
            String s = "name: " + this.name + " refer: " + this.refer + " selector: " + this.selector + " field: " + this.field;
            return s;
        }
    }

    private class Key {
        protected String selector;
        protected String field;
        protected String name;

        Key(String name, String selector, String field) {
            this.name = name;
            this.selector = selector;
            this.field = field;
        }

        public String toString() {
            String s = "name: " + this.name + " selector: " + this.selector + " field: " + this.field;
            return s;
        }
    }
}

