/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.EMLParserServlet;
import org.ecoinformatics.eml.SAXValidate;
import org.xml.sax.SAXParseException;

public class SaxValidateTest
extends TestCase {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String TEST_DIR = "./src/test/resources";

    public SaxValidateTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void initialize() {
        SaxValidateTest.assertTrue((boolean)true);
    }

    public void testSchemaValid() {
        SAXValidate test = new SAXValidate(true);
        SaxValidateTest.assertTrue((test != null ? 1 : 0) != 0);
        File testDir = new File(TEST_DIR);
        Vector fileList = this.getXmlFiles(testDir);
        for (int i = 0; i < fileList.size(); ++i) {
            File testFile = (File)fileList.elementAt(i);
            try {
                System.err.println("Validating file: " + testFile.getName());
                FileReader reader = new FileReader(testFile);
                String namespace = EMLParserServlet.findNamespace(reader);
                reader.close();
                test.runTest(new FileReader(testFile), namespace);
                continue;
            }
            catch (Exception e) {
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    System.err.println("Error on line: " + spe.getLineNumber());
                }
                e.printStackTrace(System.err);
                SaxValidateTest.fail((String)("Document NOT valid!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
        }
    }

    public void testDocbook() {
        SAXValidate test = new SAXValidate(false);
        SaxValidateTest.assertTrue((test != null ? 1 : 0) != 0);
        System.err.println("Validating the build/docs/eml-2.1.1/eml-docbook.xml file.");
        File f = new File("build/docs/eml-2.1.1/eml-docbook.xml");
        if (!f.exists()) {
            System.err.println("The file eml-2.1.1/eml-docbook.xml is not in the docs directory.  You must run 'ant docbook' before running this test.");
            SaxValidateTest.fail((String)"The file eml-2.1.1/eml-docbook.xml is not in the docs directory.  You must run 'ant docbook' before running this test.");
        }
        try {
            test.runTest(new FileReader("build/docs/eml-2.1.1/eml-docbook.xml"), DEFAULT_PARSER);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.equals("Attribute \"xmlns:xs\" must be declared for element type \"book\".")) {
                System.err.println("eml-docbook.xsl is valid");
            }
            System.err.println("eml-docbook.xsl is NOT valid: " + msg);
            SaxValidateTest.fail((String)("eml-docbook.xml NOT valid: " + msg));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SaxValidateTest("initialize"));
        suite.addTest((Test)new SaxValidateTest("testSchemaValid"));
        suite.addTest((Test)new SaxValidateTest("testDocbook"));
        return suite;
    }

    private Vector getXmlFiles(File directory) {
        String[] files = directory.list();
        Vector<File> fileList = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File currentFile = new File(directory, filename);
            if (!currentFile.isFile() || !filename.endsWith(".xml")) continue;
            fileList.addElement(currentFile);
        }
        return fileList;
    }
}

