/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.PlainFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.ext.ExtHash;
import com.hp.hpl.jena.tdb.sys.SystemTDB;

public class IndexFactoryExtHash
implements IndexFactory {
    private final int blockSize;

    public IndexFactoryExtHash() {
        this(8192);
    }

    public IndexFactoryExtHash(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public Index createIndex(FileSet fileset, RecordFactory recordFactory) {
        String fnDictionary = fileset.filename("exh");
        PlainFile dictionary = FileFactory.createPlainFileDisk(fnDictionary);
        String fnBuckets = fileset.filename("dat");
        BlockMgr mgr = this.createBlockMgr(fnBuckets, this.blockSize);
        ExtHash eHash = new ExtHash(dictionary, recordFactory, mgr);
        return eHash;
    }

    protected BlockMgr createBlockMgr(String filename, int blockSize) {
        return BlockMgrFactory.createFile(filename, blockSize, SystemTDB.BlockReadCacheSize, SystemTDB.BlockWriteCacheSize);
    }
}

