/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import org.apache.noggit.ObjectBuilder;
import org.apache.solr.CollectionTester;

public class JSONTestUtil {
    public static final double DEFAULT_DELTA = 1.0E-5;

    public static String match(String input, String pathAndExpected) throws Exception {
        return JSONTestUtil.match(input, pathAndExpected, 1.0E-5);
    }

    public static String match(String path, String input, String expected) throws Exception {
        return JSONTestUtil.match(path, input, expected, 1.0E-5);
    }

    public static String matchObj(String path, Object input, Object expected) throws Exception {
        return JSONTestUtil.matchObj(path, input, expected, 1.0E-5);
    }

    public static String match(String input, String pathAndExpected, double delta) throws Exception {
        int pos = pathAndExpected.indexOf("==");
        String path = pos >= 0 ? pathAndExpected.substring(0, pos) : null;
        String expected = pos >= 0 ? pathAndExpected.substring(pos + 2) : pathAndExpected;
        return JSONTestUtil.match(path, input, expected, delta);
    }

    public static String match(String path, String input, String expected, double delta) throws Exception {
        Object inputObj = ObjectBuilder.fromJSON((String)input);
        Object expectObj = ObjectBuilder.fromJSON((String)expected);
        return JSONTestUtil.matchObj(path, inputObj, expectObj);
    }

    public static String matchObj(String path, Object input, Object expected, double delta) throws Exception {
        CollectionTester tester = new CollectionTester(input);
        boolean reversed = path.startsWith("!");
        String positivePath = reversed ? path.substring(1) : path;
        if (!tester.seek(positivePath) ^ reversed) {
            return "Path not found: " + path;
        }
        if (expected != null && !tester.match(expected) ^ reversed) {
            return tester.err + " @ " + tester.getPath();
        }
        return null;
    }
}

