/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected boolean foStylesheet = false;
    protected NamePool namePool = null;

    public FormatCallout(NamePool nPool, boolean fo) {
        this.namePool = nPool;
        this.foStylesheet = fo;
    }

    public String areaLabel(Element area) {
        String label = null;
        if (area.hasAttribute("label")) {
            label = area.getAttribute("label");
        } else {
            Element parent = (Element)area.getParentNode();
            if (parent != null && parent.getLocalName().equalsIgnoreCase("areaset") && parent.hasAttribute("label")) {
                label = parent.getAttribute("label");
            }
        }
        return label;
    }

    public void endSpan(Emitter rtf) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            int spanName = this.namePool.allocate("", "", "span");
            rtf.endElement(spanName);
        }
    }

    public abstract void formatCallout(Emitter var1, Callout var2);

    public void formatTextCallout(Emitter rtfEmitter, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        char[] chars = label.toCharArray();
        try {
            this.startSpan(rtfEmitter);
            rtfEmitter.characters(chars, 0, label.length());
            this.endSpan(rtfEmitter);
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in formatTextCallout");
        }
    }

    public void startSpan(Emitter rtf) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            int spanName = this.namePool.allocate("", "", "span");
            AttributeCollection spanAttr = new AttributeCollection(this.namePool);
            int[] namespaces = new int[1];
            spanAttr.addAttribute("", "", "class", "CDATA", "co");
            rtf.startElement(spanName, (Attributes)spanAttr, namespaces, 0);
        }
    }
}

