/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.RecordFactory;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ExtendedJDBCRecordFactory
extends RecordFactory {
    private String repositoryIdentifier = null;
    protected String identifierLabel = null;
    protected String datestampLabel = null;

    public ExtendedJDBCRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        this.repositoryIdentifier = properties.getProperty("ExtendedJDBCRecordFactory.repositoryIdentifier");
        if (this.repositoryIdentifier == null) {
            throw new IllegalArgumentException("ExtendedJDBCRecordFactory.repositoryIdentifier is missing from the properties file");
        }
        this.identifierLabel = properties.getProperty("ExtendedJDBCRecordFactory.identifierLabel");
        if (this.identifierLabel == null) {
            throw new IllegalArgumentException("ExtendedJDBCRecordFactory.identifierLabel is missing from the properties file");
        }
        this.datestampLabel = properties.getProperty("ExtendedJDBCRecordFactory.datestampLabel");
        if (this.datestampLabel == null) {
            throw new IllegalArgumentException("ExtendedJDBCRecordFactory.datestampLabel is missing from the properties file");
        }
    }

    public String fromOAIIdentifier(String oaiIdentifier) {
        StringTokenizer tokenizer = new StringTokenizer(oaiIdentifier, ":");
        try {
            tokenizer.nextToken();
            tokenizer.nextToken();
            return tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getLocalIdentifier(Object nativeItem) {
        HashMap table = (HashMap)((HashMap)nativeItem).get("coreResult");
        return table.get(this.identifierLabel).toString();
    }

    public String getOAIIdentifier(Object nativeItem) throws IllegalArgumentException {
        StringBuffer sb = new StringBuffer();
        sb.append("oai:");
        sb.append(this.repositoryIdentifier);
        sb.append(":");
        sb.append(this.getLocalIdentifier(nativeItem));
        return sb.toString();
    }

    public String getDatestamp(Object nativeItem) {
        HashMap table = (HashMap)((HashMap)nativeItem).get("coreResult");
        return ((Timestamp)table.get(this.datestampLabel)).toString().substring(0, 10);
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        return false;
    }

    public String quickCreate(Object nativeItem, String schemaLocation, String metadataPrefix) {
        return null;
    }
}

