/**
 *  '$RCSfile$'
 *  Copyright: 2004 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: cjones $'
 *     '$Date: 2011-06-07 16:53:46 +0000 (Tue, 07 Jun 2011) $'
 * '$Revision: 6124 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;

/**
 * @author jones
 *
 * Version represents the current version information for this Metacat instance.
 */
public class MetacatVersion extends Version {
    public MetacatVersion(String versionID) {
    	super(versionID);
    }
	
	/**
	 * Get the current version string for this metacat instance. It is currently
	 * stored in the metacat.properties file.
	 * 
	 * @return a string indicating the version of Metacat running
	 */
	public static String getVersionID() throws PropertyNotFoundException {
		String version = PropertyService.getProperty("application.metacatVersion");
		return version;
	}
    
    /**
	 * Get the version number in an XML document.
	 * 
	 * @return the version wrapped in an XML document
	 */
    public static String getVersionAsXml() throws PropertyNotFoundException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<version>");
        sb.append(getVersionID());
        sb.append("</version>");
        return sb.toString();
    }
}
