/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import edu.ucsb.nceas.metacat.harvesterClient.HarvestDetailLog;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestDocument;
import edu.ucsb.nceas.metacat.harvesterClient.Harvester;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class HarvestLog {
    private Connection conn;
    private Harvester harvester;
    private int harvestLogID;
    private Date harvestDate;
    private int status;
    private final String marker = "*****************************************************************************";
    private String message;
    private String harvestOperationCode;
    private int siteScheduleID;
    private String explanation;
    private String harvestOperationCodeLevel;
    private String timestamp;
    private HarvestDetailLog harvestDetailLog;

    public HarvestLog(Harvester harvester, Connection connection, int n, Date date, int n2, String string, String string2, int n3) {
        Date date2 = new Date();
        this.timestamp = date2.toString();
        this.harvester = harvester;
        this.conn = connection;
        this.harvestLogID = n;
        this.harvestDate = date;
        this.status = n2;
        this.message = string;
        this.harvestOperationCode = string2;
        this.siteScheduleID = n3;
        this.harvestOperationCodeLevel = this.getHarvestOperationCodeLevel(string2);
        this.explanation = this.getExplanation(string2);
        this.dbInsertHarvestLogEntry();
    }

    public HarvestLog(Harvester harvester, Connection connection, int n, int n2, Date date, int n3, String string, String string2, int n4, HarvestDocument harvestDocument, String string3) {
        Date date2 = new Date();
        this.timestamp = date2.toString();
        this.harvester = harvester;
        this.conn = connection;
        this.harvestLogID = n;
        this.harvestDate = date;
        this.status = n3;
        this.message = string;
        this.harvestOperationCode = string2;
        this.siteScheduleID = n4;
        this.harvestDetailLog = new HarvestDetailLog(harvester, connection, n2, n, harvestDocument, string3);
        this.harvestOperationCodeLevel = this.getHarvestOperationCodeLevel(string2);
        this.explanation = this.getExplanation(string2);
        this.dbInsertHarvestLogEntry();
        this.harvestDetailLog.dbInsertHarvestDetailLogEntry();
    }

    void dbInsertHarvestLogEntry() {
        String string = this.harvester.dequoteText(this.message);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        String string2 = "INSERT INTO HARVEST_LOG (HARVEST_LOG_ID, HARVEST_DATE, STATUS, MESSAGE, HARVEST_OPERATION_CODE, SITE_SCHEDULE_ID) values(" + this.harvestLogID + ", " + "'" + simpleDateFormat.format(this.harvestDate) + "', " + this.status + ", " + "'" + this.timestamp + ": " + string + "', " + "'" + this.harvestOperationCode + "', " + this.siteScheduleID + ")";
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate(string2);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public int getCodeLevelValue(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("error")) {
            n = 1;
        } else if (string.equalsIgnoreCase("warning")) {
            n = 2;
        } else if (string.equalsIgnoreCase("notice")) {
            n = 3;
        } else if (string.equalsIgnoreCase("info")) {
            n = 4;
        } else if (string.equalsIgnoreCase("debug")) {
            n = 5;
        }
        return n;
    }

    public String getExplanation(String string) {
        String string2 = "EXPLANATION";
        String string3 = this.getHarvestOperation(string2, string);
        return string3;
    }

    String getHarvestOperation(String string, String string2) {
        String string3 = "No explanation available";
        String string4 = "debug";
        String string5 = null;
        String string6 = "";
        try {
            string5 = PropertyService.getProperty((String)string2);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("Error trying to get property: " + string2 + " : " + propertyNotFoundException.getMessage());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
        string3 = (String)stringTokenizer.nextElement();
        string4 = (String)stringTokenizer.nextElement();
        if (string.equals("EXPLANATION")) {
            string6 = string3;
        } else if (string.equals("HARVEST_OPERATION_CODE_LEVEL")) {
            string6 = string4;
        }
        return string6;
    }

    public String getHarvestOperationCodeLevel(String string) {
        String string2 = "HARVEST_OPERATION_CODE_LEVEL";
        String string3 = this.getHarvestOperation(string2, string);
        return string3;
    }

    int getSiteScheduleID() {
        return this.siteScheduleID;
    }

    boolean isErrorEntry() {
        boolean bl = this.status != 0;
        return bl;
    }

    public void printOutput(PrintStream printStream, String string) {
        int n;
        int n2 = this.getCodeLevelValue(this.harvestOperationCodeLevel);
        if (n2 <= (n = this.getCodeLevelValue(string))) {
            printStream.println("");
            printStream.println("*****************************************************************************");
            printStream.println("*");
            printStream.println("* harvestLogID:         " + this.harvestLogID);
            printStream.println("* harvestDate:          " + this.harvestDate);
            printStream.println("* status:               " + this.status);
            printStream.println("* message:              " + this.message);
            printStream.println("* harvestOperationCode: " + this.harvestOperationCode);
            printStream.println("* description:          " + this.explanation);
            if ((this.harvestOperationCode.equals("harvester.GetHarvestListSuccess") || this.harvestOperationCode.equals("harvester.GetHarvestListError")) && this.siteScheduleID != 0) {
                this.harvester.printHarvestSiteSchedule(printStream, this.siteScheduleID);
            }
            if (this.harvestDetailLog != null) {
                this.harvestDetailLog.printOutput(printStream);
            }
            printStream.println("*");
            printStream.println("*****************************************************************************");
        }
    }
}

