/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import com.oreilly.servlet.MailMessage;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestDocument;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestLog;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestSiteSchedule;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Harvester {
    public static final String filler = "*";
    private static boolean keepRunning = true;
    public static final String marker = "*****************************************************************************";
    private static String schemaLocation = null;
    private Connection conn = null;
    private boolean connectToMetacat;
    private int detailLogID;
    String harvesterAdministrator;
    private int harvestLogID;
    private Date harvestEndTime;
    private ArrayList harvestLogList = new ArrayList();
    private ArrayList harvestSiteScheduleList = new ArrayList();
    private Date harvestStartTime;
    int logPeriod;
    Metacat metacat;
    String smtpServer;
    String timestamp;

    public static void loadProperties(String string) {
        try {
            PropertyService.getInstance((String)(string + "/WEB-INF"));
        }
        catch (Exception exception) {
            System.out.println("Error in loading properties: " + exception.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        Integer n = new Integer(0);
        int n2 = n;
        Integer n3 = new Integer(0);
        int n4 = n3;
        int n5 = 0;
        Integer n6 = new Integer(24);
        int n7 = n6;
        String string = null;
        if (stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        if (stringArray.length > 1) {
            schemaLocation = stringArray[1];
            System.err.println("schemaLocation: " + schemaLocation);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.out.println(marker);
        System.out.println("Starting Harvester");
        Harvester.loadProperties(string);
        try {
            Integer n8 = Integer.valueOf(PropertyService.getProperty((String)"harvester.delay"));
            n2 = n8;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NumberFormatException: Error parsing delay: " + numberFormatException.getMessage());
            System.out.println("Defaulting to delay=" + n);
            n2 = n;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("PropertyNotFoundException: Error finding delay: " + propertyNotFoundException.getMessage());
            System.out.println("Defaulting to delay=" + n);
            n2 = n;
        }
        try {
            Integer n9 = Integer.valueOf(PropertyService.getProperty((String)"harvester.maxHarvests"));
            n4 = n9;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NumberFormatException: Error parsing maxHarvests: " + numberFormatException.getMessage());
            System.out.println("Defaulting to maxHarvests=" + n3);
            n4 = n3;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("PropertyNotFoundException: Error finding maxHarvests: " + propertyNotFoundException.getMessage());
            System.out.println("Defaulting to maxHarvests=" + n3);
            n4 = n3;
        }
        try {
            Integer n10 = Integer.valueOf(PropertyService.getProperty((String)"harvester.period"));
            n7 = n10;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NumberFormatException: Error parsing period: " + numberFormatException.getMessage());
            System.out.println("Defaulting to period=" + n6);
            n7 = n6;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("PropertyNotFoundException: Error finding period: " + propertyNotFoundException.getMessage());
            System.out.println("Defaulting to period=" + n6);
            n7 = n6;
        }
        if (n2 > 0) {
            try {
                System.out.print("First harvest will begin in " + n2);
                if (n2 == 1) {
                    System.out.println(" hour.");
                } else {
                    System.out.println(" hours.");
                }
                Thread.sleep((long)n2 * 3600000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("InterruptedException: " + interruptedException.getMessage());
                System.exit(1);
            }
        }
        while (keepRunning && (n5 < n4 || n4 <= 0)) {
            long l = System.currentTimeMillis();
            Harvester harvester = new Harvester();
            harvester.startup(++n5, n4);
            harvester.readHarvestSiteSchedule();
            harvester.harvest();
            harvester.shutdown();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (n5 >= n4 && n4 > 0) continue;
            try {
                System.out.println("Next harvest will begin in " + n7 + " hours.");
                Thread.sleep((long)n7 * 3600000L - l3);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("InterruptedException: " + interruptedException.getMessage());
                System.exit(1);
            }
        }
    }

    static void setKeepRunning(boolean bl) {
        keepRunning = bl;
    }

    void addLogEntry(int n, String string, String string2, int n2, HarvestDocument harvestDocument, String string3) {
        HarvestLog harvestLog;
        int n3 = this.getHarvestLogID();
        if (harvestDocument == null) {
            harvestLog = new HarvestLog(this, this.conn, n3, this.harvestStartTime, n, string, string2, n2);
        } else {
            int n4 = this.getDetailLogID();
            harvestLog = new HarvestLog(this, this.conn, n3, n4, this.harvestStartTime, n, string, string2, n2, harvestDocument, string3);
        }
        this.harvestLogList.add(harvestLog);
    }

    public void closeConnection() {
        try {
            System.out.println("Closing the database connection.");
            this.conn.close();
        }
        catch (SQLException sQLException) {
            System.out.println("Database access failed " + sQLException);
        }
    }

    boolean connectToMetacat() {
        return this.connectToMetacat;
    }

    public String dequoteText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append('\"');
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public Connection getConnection() {
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this.conn == null) {
            try {
                string = PropertyService.getProperty((String)"database.driver");
                string2 = PropertyService.getProperty((String)"database.connectionURI");
                string3 = PropertyService.getProperty((String)"database.password");
                string4 = PropertyService.getProperty((String)"database.user");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                System.out.println("Can't find property " + (Object)((Object)propertyNotFoundException));
                System.exit(1);
            }
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Can't load driver " + classNotFoundException);
                System.exit(1);
            }
            try {
                SQLWarning sQLWarning;
                System.out.println("Getting connection to Harvester tables");
                this.conn = DriverManager.getConnection(string2, string4, string3);
                if (sQLWarning != null) {
                    for (sQLWarning = this.conn.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                        System.out.println("SQLState: " + sQLWarning.getSQLState());
                        System.out.println("Message:  " + sQLWarning.getMessage());
                        System.out.println("Vendor: " + sQLWarning.getErrorCode());
                        System.out.println("");
                    }
                }
            }
            catch (SQLException sQLException) {
                System.out.println("Database access failed " + sQLException);
                System.exit(1);
            }
        }
        return this.conn;
    }

    public int getDetailLogID() {
        int n = this.detailLogID++;
        return n;
    }

    public int getHarvestLogID() {
        int n = this.harvestLogID++;
        return n;
    }

    private int getMaxValue(String string, String string2) {
        int n = 0;
        String string3 = "SELECT " + string2 + " FROM " + string;
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(string2);
                n = Math.max(n, n2);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return n;
    }

    private int getMinValue(String string, String string2) {
        int n = 0;
        String string3 = "SELECT " + string2 + " FROM " + string;
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(string2);
                if (n == 0) {
                    n = n2;
                    continue;
                }
                n = Math.min(n, n2);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
        return n;
    }

    private void harvest() {
        for (int i = 0; i < this.harvestSiteScheduleList.size(); ++i) {
            HarvestSiteSchedule harvestSiteSchedule = (HarvestSiteSchedule)this.harvestSiteScheduleList.get(i);
            if (schemaLocation != null) {
                harvestSiteSchedule.setSchemaLocation(schemaLocation);
            }
            harvestSiteSchedule.harvestDocumentList();
        }
    }

    public void initLogIDs() {
        this.detailLogID = this.getMaxValue("HARVEST_DETAIL_LOG", "DETAIL_LOG_ID") + 1;
        this.harvestLogID = this.getMaxValue("HARVEST_LOG", "HARVEST_LOG_ID") + 1;
    }

    void printHarvestHeader(PrintStream printStream, int n) {
        int n2 = 0;
        for (int i = 0; i < this.harvestLogList.size(); ++i) {
            HarvestLog harvestLog = (HarvestLog)this.harvestLogList.get(i);
            int n3 = harvestLog.getSiteScheduleID();
            if (n != 0 && n != n3 || !harvestLog.isErrorEntry()) continue;
            ++n2;
        }
        printStream.println(marker);
        printStream.println(filler);
        printStream.println("* METACAT HARVESTER REPORT: " + this.timestamp);
        printStream.println(filler);
        if (n2 > 0) {
            String string = n2 == 1 ? " ERROR WAS " : " ERRORS WERE ";
            printStream.println("* A TOTAL OF " + n2 + string + "DETECTED.");
            printStream.println("* Please see the log entries below for additonal details.");
        } else {
            printStream.println("* NO ERRORS WERE DETECTED DURING THIS HARVEST.");
        }
        printStream.println(filler);
        printStream.println(marker);
    }

    void printHarvestLog(PrintStream printStream, String string, int n) {
        boolean bl = false;
        printStream.println("");
        printStream.println(marker);
        printStream.println(filler);
        printStream.println("*                       LOG ENTRIES");
        printStream.println(filler);
        printStream.println(marker);
        for (int i = 0; i < this.harvestLogList.size(); ++i) {
            HarvestLog harvestLog = (HarvestLog)this.harvestLogList.get(i);
            int n2 = harvestLog.getSiteScheduleID();
            if (n != 0 && n != n2) continue;
            harvestLog.printOutput(printStream, string);
        }
    }

    void printHarvestSiteSchedule(PrintStream printStream, int n) {
        for (int i = 0; i < this.harvestSiteScheduleList.size(); ++i) {
            HarvestSiteSchedule harvestSiteSchedule = (HarvestSiteSchedule)this.harvestSiteScheduleList.get(i);
            if (harvestSiteSchedule.siteScheduleID != n) continue;
            harvestSiteSchedule.printOutput(printStream);
        }
    }

    private void pruneHarvestLog() {
        long l = this.harvestStartTime.getTime();
        int n = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        long l2 = 0L;
        long l3 = (long)this.logPeriod * 86400000L;
        String string = "DELETE FROM HARVEST_LOG WHERE HARVEST_DATE < ";
        String string2 = "SELECT HARVEST_LOG_ID FROM HARVEST_LOG WHERE HARVEST_DATE < ";
        String string3 = "DELETE FROM HARVEST_DETAIL_LOG WHERE HARVEST_LOG_ID = ";
        l2 = l - l3;
        Date date = new Date(l2);
        String string4 = "'" + simpleDateFormat.format(date) + "'";
        string = string + string4;
        string2 = string2 + string4;
        try {
            int n2;
            SQLWarning sQLWarning;
            System.out.println("Pruning log entries from HARVEST_DETAIL_LOG and HARVEST_LOG:");
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            if (sQLWarning != null) {
                System.out.println("\n---Warning---\n");
                for (sQLWarning = resultSet.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    System.out.println("Message: " + sQLWarning.getMessage());
                    System.out.println("SQLState: " + sQLWarning.getSQLState());
                    System.out.print("Vendor error code: ");
                    System.out.println(sQLWarning.getErrorCode());
                    System.out.println("");
                }
            }
            while (resultSet.next()) {
                this.harvestLogID = resultSet.getInt("HARVEST_LOG_ID");
                statement = this.conn.createStatement();
                n2 = statement.executeUpdate(string3 + this.harvestLogID);
                n += n2;
                statement.close();
            }
            statement = this.conn.createStatement();
            n2 = statement.executeUpdate(string);
            statement.close();
            System.out.println("  " + n + " records deleted from HARVEST_DETAIL_LOG");
            System.out.println("  " + n2 + " records deleted from HARVEST_LOG");
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    private void readHarvestSiteSchedule() {
        try {
            SQLWarning sQLWarning;
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM HARVEST_SITE_SCHEDULE");
            if (sQLWarning != null) {
                System.out.println("\n---Warning---\n");
                for (sQLWarning = resultSet.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    System.out.println("Message: " + sQLWarning.getMessage());
                    System.out.println("SQLState: " + sQLWarning.getSQLState());
                    System.out.print("Vendor error code: ");
                    System.out.println(sQLWarning.getErrorCode());
                    System.out.println("");
                }
            }
            while (resultSet.next()) {
                int n = resultSet.getInt("SITE_SCHEDULE_ID");
                String string = resultSet.getString("DOCUMENTLISTURL");
                String string2 = resultSet.getString("LDAPDN");
                String string3 = resultSet.getString("LDAPPWD");
                String string4 = resultSet.getString("DATENEXTHARVEST");
                String string5 = resultSet.getString("DATELASTHARVEST");
                int n2 = resultSet.getInt("UPDATEFREQUENCY");
                String string6 = resultSet.getString("UNIT");
                String string7 = resultSet.getString("CONTACT_EMAIL");
                sQLWarning = resultSet.getWarnings();
                if (sQLWarning != null) {
                    System.out.println("\n---Warning---\n");
                    while (sQLWarning != null) {
                        System.out.println("Message: " + sQLWarning.getMessage());
                        System.out.println("SQLState: " + sQLWarning.getSQLState());
                        System.out.print("Vendor error code: ");
                        System.out.println(sQLWarning.getErrorCode());
                        System.out.println("");
                        sQLWarning = sQLWarning.getNextWarning();
                    }
                }
                HarvestSiteSchedule harvestSiteSchedule = new HarvestSiteSchedule(this, n, string, string2, string3, string4, string5, n2, string6, string7);
                this.harvestSiteScheduleList.add(harvestSiteSchedule);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("Database access failed " + sQLException);
            System.exit(1);
        }
    }

    void reportToAdministrator(String string) {
        String string2 = this.harvesterAdministrator;
        int n = 0;
        String string3 = "Report from Metacat Harvester: " + this.timestamp;
        String string4 = this.harvesterAdministrator;
        if (!string4.equals("")) {
            System.out.println("Sending report to Harvester Administrator at address " + this.harvesterAdministrator);
            try {
                MailMessage mailMessage = new MailMessage(this.smtpServer);
                if (string2.indexOf(44) > 0) {
                    String[] stringArray = string2.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            mailMessage.from(stringArray[i]);
                        }
                        mailMessage.to(stringArray[i]);
                    }
                } else if (string2.indexOf(59) > 0) {
                    String[] stringArray = string2.split(";");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            mailMessage.from(stringArray[i]);
                        }
                        mailMessage.to(stringArray[i]);
                    }
                } else {
                    mailMessage.from(string2);
                    mailMessage.to(string4);
                }
                mailMessage.setSubject(string3);
                PrintStream printStream = mailMessage.getPrintStream();
                this.printHarvestHeader(printStream, n);
                this.printHarvestLog(printStream, string, n);
                mailMessage.sendAndClose();
            }
            catch (IOException iOException) {
                System.out.println("There was a problem sending email to " + string4);
                System.out.println("IOException: " + iOException.getMessage());
            }
        }
    }

    public void setHarvestStartTime(Date date) {
        this.harvestStartTime = date;
    }

    private void shutdown() {
        String string = "debug";
        int n = 0;
        System.out.println("Shutting Down Harvester");
        this.addLogEntry(0, "Shutting Down Harvester", "harvester.HarvesterShutdown", 0, null, "");
        this.pruneHarvestLog();
        this.closeConnection();
        this.printHarvestLog(System.out, string, n);
        this.reportToAdministrator(string);
    }

    private void startup(int n, int n2) {
        Date date = new Date();
        this.timestamp = date.toString();
        System.out.println(marker);
        System.out.print(this.timestamp + ": Starting Next Harvest");
        if (n2 > 0) {
            System.out.print(" (" + n + "/" + n2 + ")");
        }
        System.out.print("\n");
        try {
            Boolean bl = Boolean.valueOf(PropertyService.getProperty((String)"harvester.connectToMetacat"));
            this.connectToMetacat = bl;
            this.harvesterAdministrator = PropertyService.getProperty((String)"harvester.administrator");
            this.smtpServer = PropertyService.getProperty((String)"harvester.smtpServer");
            Integer n3 = Integer.valueOf(PropertyService.getProperty((String)"harvester.logPeriod"));
            this.logPeriod = n3;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("NumberFormatException: Error parsing logPeriod " + this.logPeriod + numberFormatException.getMessage());
            System.err.println("Defaulting to logPeriod of 90 days");
            this.logPeriod = 90;
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            System.out.println("PropertyNotFoundException: Error getting property: " + propertyNotFoundException.getMessage());
            return;
        }
        this.conn = this.getConnection();
        this.initLogIDs();
        this.setHarvestStartTime(date);
        this.addLogEntry(0, "Starting Up Harvester", "harvester.HarvesterStartup", 0, null, "");
        if (this.connectToMetacat()) {
            try {
                String string = SystemUtil.getServletURL();
                System.out.println("Connecting to Metacat: " + string);
                this.metacat = MetacatFactory.createMetacatConnection((String)string);
            }
            catch (MetacatInaccessibleException metacatInaccessibleException) {
                System.out.println("Metacat connection failed." + metacatInaccessibleException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("Metacat connection failed." + exception.getMessage());
            }
        }
    }
}

