/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AccessionNumber {
    private String sitecode = null;
    private String sep = null;
    private String docid = null;
    private String rev = null;

    private AccessionNumber() throws AccessionNumberException {
        try {
            this.sitecode = PropertyService.getProperty("document.sitecode");
            this.sep = PropertyService.getProperty("document.accNumSeparator");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AccessionNumberException("Could not retrieve property in constructor: " + pnfe.getMessage());
        }
    }

    public AccessionNumber(String accnum, String action) throws AccessionNumberException, SQLException, NumberFormatException {
        this();
        int lastIndex;
        int firstIndex;
        this.rev = null;
        this.docid = accnum;
        if (accnum != null && (firstIndex = accnum.indexOf(this.sep)) != (lastIndex = accnum.lastIndexOf(this.sep))) {
            this.rev = accnum.substring(lastIndex + 1);
            this.docid = accnum.substring(0, lastIndex);
        }
        if (action.equals("INSERT")) {
            if (this.rev != null) {
                try {
                    Integer.parseInt(this.rev);
                }
                catch (NumberFormatException e) {
                    throw new AccessionNumberException("Revision number is required");
                }
            }
            if (this.docid == null) {
                throw new AccessionNumberException("Accession number is required");
            }
            if (this.rev == null) {
                throw new AccessionNumberException("Revision number is required");
            }
            if (AccessionNumber.accNumberUsed(this.docid)) {
                throw new AccessionNumberException("Accession number " + this.docid + " is already in use");
            }
        } else if (action.equals("UPDATE") || action.equals("DELETE")) {
            String l_rev = "";
            int reversionNumber = 1;
            if (this.rev != null) {
                try {
                    reversionNumber = Integer.parseInt(this.rev);
                }
                catch (NumberFormatException e) {
                    throw new AccessionNumberException("Revision number is required");
                }
            }
            if (this.docid == null) {
                throw new AccessionNumberException("Accession number is required");
            }
            if (this.rev == null) {
                throw new AccessionNumberException("Revision number is required");
            }
            if (!this.accNumberIsCurrent(this.docid)) {
                throw new AccessionNumberException("Document not found for Accession number " + this.docid);
            }
            if (action.equals("UPDATE") && reversionNumber <= this.getLastRevisionNumber(this.docid)) {
                throw new AccessionNumberException("Next revision number can't be less than or equal to " + this.getLastRevisionNumber(this.docid));
            }
            if (action.equals("DELETE") && !this.rev.equals(l_rev = this.getLastRevision(this.docid))) {
                throw new AccessionNumberException("Last revision number is " + l_rev);
            }
        }
    }

    public static boolean accNumberUsed(String accNumber) throws SQLException {
        boolean hasAccNumber = false;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            PreparedStatement pstmt = null;
            conn = DBConnectionPool.getDBConnection("AccessionNumber.accNumberUsed");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT 'x' FROM xml_documents WHERE docid = ? UNION SELECT 'x' FROM xml_revisions WHERE docid = ?");
            pstmt.setString(1, accNumber);
            pstmt.setString(2, accNumber);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            hasAccNumber = rs.next();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("Error on AccessionNumber.accNumberUsed(accNumber): " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
        return hasAccNumber;
    }

    private boolean accNumberIsCurrent(String accNumber) throws SQLException {
        boolean hasCurrentAccNumber = false;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            PreparedStatement pstmt = null;
            conn = DBConnectionPool.getDBConnection("AccessionNumber.accNumberIsCurre");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT 'x' FROM xml_documents WHERE docid = ?");
            pstmt.setString(1, accNumber);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            hasCurrentAccNumber = rs.next();
            if (!hasCurrentAccNumber) {
                pstmt = conn.prepareStatement("SELECT 'x' FROM xml_revisions WHERE docid = ?");
                pstmt.setString(1, accNumber);
                pstmt.execute();
                rs = pstmt.getResultSet();
                hasCurrentAccNumber = rs.next();
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("Error on AccessionNumber.accNumberIsCurrent(String accNumber): " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
        return hasCurrentAccNumber;
    }

    private String getLastRevision(String docid) throws SQLException {
        String rev = "";
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            PreparedStatement pstmt = null;
            conn = DBConnectionPool.getDBConnection("AccessionNumber.getLastRevision");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT rev FROM xml_documents WHERE docid = ?");
            pstmt.setString(1, docid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRow = rs.next();
            rev = rs.getString(1);
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("Error on AccessionNumber.getLastRevision(): " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
        return rev;
    }

    private int getLastRevisionNumber(String docId) throws SQLException {
        int rev = 1;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            PreparedStatement pStmt = null;
            conn = DBConnectionPool.getDBConnection("AccessionNumber.getLastRevisionN");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement("SELECT rev FROM xml_documents WHERE docid = ? ");
            pStmt.setString(1, docId);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                rev = rs.getInt(1);
            }
            pStmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("Error on AccessionNumber.getLastRevision(): " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
        return rev;
    }

    public String getDocid() {
        return this.docid;
    }

    public String getRev() {
        return this.rev;
    }
}

