/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.ecoinformatics.eml.EMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ContentTypeProvider {
    private String dataFileId = null;
    private String contentType = null;
    private String packageType = null;
    private Hashtable contentTypeHash = new Hashtable();
    private String BETA = "beta";
    private String EML2 = "eml2";
    private static String DEFAULTCONTENTTYPE;
    private String FORMATPATH = "//format";
    private String TEXT = "text";
    private String TEXTYPE = "text/plain";
    private String XML = "xml";
    private String XMLTYPE = "text/xml";
    private String HTML = "HTML";
    private String HTMLTYPE = "text/html";
    private String GIF = "gif";
    private String JPEG = "jpeg";
    private String JPEGTYPE = "image/jpeg";
    private String GIFTYPE = "image/gif";
    private String BMP = "bmp";
    private String BMPTYPE = "image/bmp";
    private String TAR = "tar";
    private String TARTYPE = "application/x-tar";
    private String ZIP = "zip";
    private String ZIPTYPE = "application/x-zip-compressed";
    private String BINARY = "binary";
    private String BINARYTYPE = "application/octet-stream";
    private String ENTITYDOCTYPE = "xml.entitydoctype";
    private String PHYSICALDOCTYPE = "xml.physicaldoctype";
    private String EML2DOCTYPE = "eml2namespace";
    private String DATAFORMAT = "dataFormat";
    private String TEXTFORMAT = "textFormat";
    private String EXTENALFORMAT = "externallyDefinedFormat";
    private String FORMATNAME = "formatName";
    private String BINARYRASTERFORMAT = "binaryRasterFormat";
    private String DATAFILEPATH = "//physical/distribution/online/url";
    private static Logger logMetacat;

    public ContentTypeProvider(String docIdWithRevision) {
        this.dataFileId = DocumentUtil.getDocIdFromString(docIdWithRevision);
        Vector docLists = null;
        docLists = this.getRelativeDocIdList(this.dataFileId);
        if (this.packageType == null) {
            this.contentType = DEFAULTCONTENTTYPE;
        } else if (this.packageType.equals(this.BETA)) {
            String entityDocid = this.getTargetDocIdForBeta(docLists, this.ENTITYDOCTYPE);
            String physicalDocId = this.getTargetDocIdForBeta(docLists = this.getRelativeDocIdList(entityDocid), this.PHYSICALDOCTYPE);
            if (physicalDocId == null) {
                this.contentType = DEFAULTCONTENTTYPE;
            } else {
                this.parsePhysicalDocumentForBeta(physicalDocId);
            }
        } else if (this.packageType.equals(this.EML2)) {
            String eml2Docid = (String)docLists.elementAt(0);
            this.findContentTypeInEML2(eml2Docid);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    private void findContentTypeInEML2(String eml2DocId) {
        if (eml2DocId == null) {
            this.contentType = DEFAULTCONTENTTYPE;
            return;
        }
        DocumentImpl xmlDoc = null;
        String xmlString = null;
        StringReader read = null;
        InputSource in = null;
        DocumentBuilderFactory dfactory = null;
        Document doc = null;
        try {
            String accNumber = eml2DocId + PropertyService.getProperty("document.accNumSeparator") + DBUtil.getLatestRevisionInDocumentTable(eml2DocId);
            xmlDoc = new DocumentImpl(accNumber);
            xmlString = xmlDoc.toString();
            read = new StringReader(xmlString);
            in = new InputSource(read);
            dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(false);
            doc = dfactory.newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            this.contentType = DEFAULTCONTENTTYPE;
            logMetacat.error((Object)("Error in ContentTypeProvider.findContentTypeInEML2()" + e.getMessage()));
            return;
        }
        Node dataFormatNode = this.findDataFormatNodeInEML2(doc, this.DATAFILEPATH, this.dataFileId);
        if (dataFormatNode == null) {
            this.contentType = DEFAULTCONTENTTYPE;
            logMetacat.info((Object)"Couldn't find data format node");
            return;
        }
        NodeList childList = dataFormatNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeName() != null && child.getNodeName().equals(this.TEXTFORMAT)) {
                logMetacat.info((Object)"in text format");
                this.contentType = this.TEXTYPE;
            }
            if (child.getNodeName() != null && child.getNodeName().equals(this.EXTENALFORMAT)) {
                logMetacat.info((Object)"in external format ");
                String format = this.getTextValueForGivenChildTag(child, this.FORMATNAME);
                logMetacat.info((Object)("The format is: " + format));
                this.contentType = this.lookUpContentType(format);
                if (this.contentType == null) {
                    this.contentType = this.BINARYTYPE;
                }
            }
            if (child.getNodeName() == null || !child.getNodeName().equals(this.BINARYRASTERFORMAT)) continue;
            this.contentType = this.BINARYTYPE;
        }
        if (this.contentType == null) {
            this.contentType = DEFAULTCONTENTTYPE;
        }
    }

    private String getTextValueForGivenChildTag(Node parentNode, String childTagName) {
        String textValue = null;
        NodeList childList = parentNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeName() == null || !child.getNodeName().equals(childTagName)) continue;
            logMetacat.info((Object)("Find child node: " + childTagName));
            Node textNode = child.getFirstChild();
            if (textNode.getNodeType() != 3) continue;
            textValue = textNode.getNodeValue();
        }
        logMetacat.info((Object)("The text value for element- " + childTagName + " is " + textValue));
        return textValue;
    }

    private Node findDataFormatNodeInEML2(Document xml, String xPath, String targetDocId) {
        Node targetNode = null;
        Node node = this.findDataFileNodeInEML2(xml, xPath, targetDocId);
        if (node != null) {
            Node phyicalNode = node.getParentNode().getParentNode().getParentNode();
            NodeList list = phyicalNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node kid = list.item(i);
                if (kid.getNodeType() != 1 || !kid.getNodeName().equals(this.DATAFORMAT)) continue;
                targetNode = kid;
                break;
            }
            if (targetNode != null) {
                logMetacat.info((Object)("dataFormat node'name: " + targetNode.getNodeName()));
            }
        }
        return targetNode;
    }

    private Node findDataFileNodeInEML2(Document xml, String xPath, String targetDocId) {
        Node dataFileNode = null;
        NodeList list = null;
        try {
            list = XPathAPI.selectNodeList((Node)xml, (String)xPath);
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error in findDataFileNode: " + e.getMessage()));
            return dataFileNode;
        }
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                Node textNode = node.getFirstChild();
                if (textNode.getNodeType() != 3) continue;
                String URLData = textNode.getNodeValue();
                logMetacat.info((Object)("online/url text data: " + URLData));
                if (URLData.indexOf("ecogrid://") == -1) continue;
                String docId = DocumentUtil.getAccessionNumberFromEcogridIdentifier(URLData);
                docId = DocumentUtil.getDocIdFromAccessionNumber(docId);
                logMetacat.info((Object)("docid from url element in xml is: " + docId));
                if (docId == null || !docId.equals(targetDocId)) continue;
                logMetacat.info((Object)("Find target docid in online/url: " + docId));
                dataFileNode = node;
                break;
            }
        }
        return dataFileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getRelativeDocIdList(String id) {
        Vector<String> docList = new Vector<String>();
        String sql = "SELECT packagetype, subject from xml_relation where object = ?";
        ResultSet rs = null;
        Statement pStmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ContentTypeProvider.getRelativeDocIdlist");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            pStmt.setString(1, id);
            pStmt.execute();
            rs = pStmt.getResultSet();
            String packType = null;
            while (rs.next()) {
                packType = rs.getString(1);
                String subject = rs.getString(2);
                if (docList.contains(subject)) continue;
                docList.add(subject);
            }
            if (MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctype")).contains(packType)) {
                logMetacat.info((Object)"This is beta package");
                this.packageType = this.BETA;
                return docList;
            }
            if (MetacatUtil.getOptionList(PropertyService.getProperty("xml.eml2_0_0namespace")).contains(packType)) {
                logMetacat.info((Object)"This is EML2.0.0 package");
                this.packageType = this.EML2;
                return docList;
            }
            if (!MetacatUtil.getOptionList(PropertyService.getProperty("xml.eml2_0_1namespace")).contains(packType)) return docList;
            logMetacat.info((Object)"This is EML2.0.1 package");
            this.packageType = this.EML2;
            return docList;
        }
        catch (SQLException e) {
            logMetacat.error((Object)("ContenTypProvider.getRelativeDoclist1 " + e.getMessage()));
            return docList;
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("ContenTypProvider.getRelativeDoclist1 " + pnfe.getMessage()));
            return docList;
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ContenTypProvider.getRelativeDoclist2 " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTargetDocIdForBeta(Vector list, String targetType) {
        String docId = null;
        if (list.isEmpty()) {
            return docId;
        }
        String sql = "SELECT doctype, docid from xml_documents where docid in ( ";
        sql = sql + "?";
        for (int i = 1; i < list.size(); ++i) {
            sql = sql + ", ?";
        }
        sql = sql + ")";
        logMetacat.info((Object)("SQL for select doctype: " + sql));
        ResultSet rs = null;
        Statement pStmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ContentTypeProvider.setPhycialDocIdForBeta");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            for (int i = 0; i < list.size(); ++i) {
                String docid = (String)list.elementAt(i);
                pStmt.setString(i + 1, docid);
            }
            pStmt.execute();
            rs = pStmt.getResultSet();
            while (rs.next()) {
                String packType = rs.getString(1);
                String targetId = rs.getString(2);
                if (!MetacatUtil.getOptionList(PropertyService.getProperty(targetType)).contains(packType)) continue;
                docId = targetId;
                break;
            }
        }
        catch (SQLException e) {
            logMetacat.error((Object)("ContenTypProvider.setPhysicalDocIdForBeta1 " + e.getMessage()));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("ContenTypProvider.setPhysicalDocIdForBeta1 " + pnfe.getMessage()));
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ContenTypProvider.setPhysicalDocIdForBeta2 " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        logMetacat.info((Object)("target docid is: " + docId + " " + "for target doctype: " + targetType));
        return docId;
    }

    private void parsePhysicalDocumentForBeta(String physicalDocid) {
        String xmlDoc = null;
        try {
            String accNumber = physicalDocid + PropertyService.getProperty("document.accNumSeparator") + DBUtil.getLatestRevisionInDocumentTable(physicalDocid);
            DocumentImpl doc = new DocumentImpl(accNumber);
            xmlDoc = doc.toString();
        }
        catch (Exception e) {
            this.contentType = DEFAULTCONTENTTYPE;
            logMetacat.error((Object)("Error in ContentTypeProvider.parsePhysicalDocumentForBeta()" + e.getMessage()));
            return;
        }
        String format = this.getTextValueFromPath(new StringReader(xmlDoc), this.FORMATPATH);
        if (format == null) {
            this.contentType = DEFAULTCONTENTTYPE;
        } else {
            this.contentType = this.lookUpContentType(format);
            if (this.contentType == null) {
                this.contentType = DEFAULTCONTENTTYPE;
            }
        }
    }

    private String getTextValueFromPath(StringReader xml, String xPath) {
        String textValue = null;
        try {
            NodeList list = EMLParser.getPathContent((StringReader)xml, (String)xPath);
            Node elementNode = list.item(0);
            Node textNode = elementNode.getFirstChild();
            if (textNode.getNodeType() == 3) {
                textValue = textNode.getNodeValue();
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("error in ContentTypeProvider.getTextValueFromPath: " + e.getMessage()));
        }
        logMetacat.info((Object)("The text value for " + xPath + " is: " + textValue));
        return textValue;
    }

    private String lookUpContentType(String format) {
        String newFormat = null;
        this.constructContentHashTable();
        newFormat = format.toLowerCase().trim();
        String type = null;
        type = (String)this.contentTypeHash.get(newFormat);
        logMetacat.info((Object)("contentType looked from hashtalbe is: " + type));
        return type;
    }

    private void constructContentHashTable() {
        this.contentTypeHash.put(this.TEXT, this.TEXTYPE);
        this.contentTypeHash.put(this.XML, this.XMLTYPE);
        this.contentTypeHash.put(this.HTML, this.HTMLTYPE);
        this.contentTypeHash.put(this.GIF, this.GIFTYPE);
        this.contentTypeHash.put(this.JPEG, this.JPEGTYPE);
        this.contentTypeHash.put(this.BMP, this.BMPTYPE);
        this.contentTypeHash.put(this.TAR, this.TARTYPE);
        this.contentTypeHash.put(this.ZIP, this.ZIPTYPE);
        this.contentTypeHash.put(this.BINARY, this.BINARYTYPE);
    }

    public static void main(String[] argus) {
        try {
            DBConnectionPool pool = DBConnectionPool.getInstance();
            ContentTypeProvider provider = new ContentTypeProvider("tao.0001");
            String str = provider.getContentType();
            logMetacat.info((Object)("content type is : " + str));
        }
        catch (Exception e) {
            logMetacat.error((Object)("erorr in Schemalocation.main: " + e.getMessage()));
        }
    }

    static {
        try {
            DEFAULTCONTENTTYPE = PropertyService.getProperty("replication.defaultcontenttype");
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get property DEFAULTCONTENTTYPE:" + pnfe.getMessage());
        }
        logMetacat = Logger.getLogger(ContentTypeProvider.class);
    }
}

