/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.SubTree;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlList;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public class PermissionController {
    private String guid = null;
    private boolean hasSubTreeAccessControl = false;
    private Vector subTreeList = new Vector();
    private static final long TOPLEVELSTARTNODEID = 0L;
    private static Logger logMetacat = Logger.getLogger(PermissionController.class);

    public PermissionController(String myDocid) throws McdbException {
        String docId = null;
        int rev = -1;
        docId = DocumentUtil.getSmartDocId(myDocid);
        rev = DocumentUtil.getRevisionFromAccessionNumber(myDocid);
        this.guid = IdentifierManager.getInstance().getGUID(docId, rev);
    }

    public boolean hasSubTreeAccessControl() {
        return this.hasSubTreeAccessControl;
    }

    public boolean hasPermission(String sessionId, String myPermission) throws SQLException {
        SessionData sessionData = null;
        sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
        if (sessionData == null) {
            return false;
        }
        return this.hasPermission(sessionData.getUserName(), sessionData.getGroupNames(), myPermission);
    }

    public boolean hasPermission(String user, String[] groups, String myPermission) throws SQLException {
        boolean hasPermission = false;
        String[] userPackage = null;
        int permission = AccessControlList.intValue(myPermission);
        if (user == null && (groups == null || groups.length == 0)) {
            return true;
        }
        try {
            if (AuthUtil.isAdministrator(user, groups)) {
                return true;
            }
        }
        catch (MetacatUtilException e) {
            logMetacat.warn((Object)("Error checking for administrator: " + e.getMessage()), (Throwable)e);
        }
        boolean isOwner = false;
        try {
            Session userSession = new Session();
            Subject subject = new Subject();
            subject.setValue(user);
            userSession.setSubject(subject);
            Identifier pid = new Identifier();
            pid.setValue(this.guid);
            SystemMetadata sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            isOwner = sysMeta.getRightsHolder().equals((Object)subject);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Error checking for DataONE permissions: " + e.getMessage()), (Throwable)e);
            isOwner = false;
        }
        if (isOwner) {
            return true;
        }
        userPackage = this.createUsersPackage(user, groups);
        hasPermission = this.isAccessDocument() && permission == 2 ? this.hasPermission(userPackage, 7) : this.hasPermission(userPackage, permission);
        return hasPermission;
    }

    private boolean hasPermission(String[] principals, int permission) throws SQLException {
        long startId = 0L;
        try {
            if (this.containDocumentOwner(principals)) {
                return true;
            }
            if (this.isAllowFirst(principals, startId)) {
                if (this.hasExplicitDenyRule(principals, permission, startId)) {
                    return false;
                }
                return this.hasAllowRule(principals, permission, startId);
            }
            return this.hasAllowRule(principals, permission, startId);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("PermissionController.hasPermission - There is a exception in hasPermission method: " + e.getMessage()));
            return false;
        }
    }

    private boolean hasPermissionForInlineData(String user, String[] groups, String myPermission, String inlineDataId) throws McdbException {
        String[] userPackage = this.createUsersPackage(user, groups);
        try {
            if (this.containDocumentOwner(userPackage)) {
                return true;
            }
            PermissionController controller = new PermissionController(this.guid);
            controller.guid = inlineDataId;
            return controller.hasPermission(user, groups, myPermission);
        }
        catch (SQLException e) {
            throw new McdbException(e.getMessage());
        }
    }

    public boolean hasPermissionForSubTreeNode(String user, String[] groups, String myPermission, long nodeId) throws McdbException {
        boolean flag = true;
        Hashtable unaccessableSubTree = this.hasUnaccessableSubTree(user, groups, myPermission);
        Enumeration en = unaccessableSubTree.elements();
        while (en.hasMoreElements()) {
            SubTree tree = (SubTree)en.nextElement();
            long start = tree.getStartNodeId();
            long stop = tree.getEndNodeId();
            if (nodeId < start || nodeId > stop) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public Hashtable hasUnaccessableSubTree(String user, String[] groups, String myPermission) throws McdbException {
        Hashtable resultUnaccessableSubTree = new Hashtable();
        String[] principals = null;
        int permission = AccessControlList.intValue(myPermission);
        if (user == null && (groups == null || groups.length == 0)) {
            return resultUnaccessableSubTree;
        }
        principals = this.createUsersPackage(user, groups);
        try {
            if (this.containDocumentOwner(principals)) {
                return resultUnaccessableSubTree;
            }
        }
        catch (SQLException ee) {
            throw new McdbException(ee);
        }
        for (int i = 0; i < this.subTreeList.size(); ++i) {
            SubTree tree = (SubTree)this.subTreeList.elementAt(i);
            long startId = tree.getStartNodeId();
            try {
                if (this.isAllowFirst(principals, startId)) {
                    if (this.hasExplicitDenyRule(principals, permission, startId)) {
                        if (resultUnaccessableSubTree.containsKey(new Long(startId))) continue;
                        resultUnaccessableSubTree.put(new Long(startId), tree);
                        continue;
                    }
                    if (this.hasAllowRule(principals, permission, startId) || resultUnaccessableSubTree.containsKey(new Long(startId))) continue;
                    resultUnaccessableSubTree.put(new Long(startId), tree);
                    continue;
                }
                if (this.hasAllowRule(principals, permission, startId) || resultUnaccessableSubTree.containsKey(new Long(startId))) continue;
                resultUnaccessableSubTree.put(new Long(startId), tree);
                continue;
            }
            catch (Exception e) {
                logMetacat.error((Object)("PermissionController.hasUnaccessableSubTree - error in PermissionControl.hasUnaccessableSubTree " + e.getMessage()));
                throw new McdbException(e);
            }
        }
        resultUnaccessableSubTree = this.mergeEquivalentSubtree(resultUnaccessableSubTree);
        return resultUnaccessableSubTree;
    }

    private Hashtable mergeEquivalentSubtree(Hashtable unAccessSubTree) {
        Hashtable<Long, SubTree> newSubTreeHash = new Hashtable<Long, SubTree>();
        boolean needDelete = false;
        if (unAccessSubTree == null || unAccessSubTree.isEmpty()) {
            return newSubTreeHash;
        }
        Enumeration en = unAccessSubTree.elements();
        while (en.hasMoreElements()) {
            SubTree tree = (SubTree)en.nextElement();
            String treeId = tree.getSubTreeId();
            long startId = tree.getStartNodeId();
            long endId = tree.getEndNodeId();
            Enumeration enu = unAccessSubTree.elements();
            while (enu.hasMoreElements()) {
                SubTree subTree = (SubTree)enu.nextElement();
                String subTreeId = subTree.getSubTreeId();
                long subTreeStartId = subTree.getStartNodeId();
                long subTreeEndId = subTree.getEndNodeId();
                if (startId <= subTreeStartId || endId >= subTreeEndId) continue;
                needDelete = true;
                logMetacat.info((Object)("PermissionController.mergeEquivalentSubtree - the subtree: " + treeId + " need to be get rid of from unaccessable" + " subtree list becuase it is a subtree of" + " another subtree in the list"));
                break;
            }
            if (!needDelete) {
                newSubTreeHash.put(new Long(startId), tree);
            }
            needDelete = false;
        }
        return newSubTreeHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAccessDocument() throws SQLException {
        String docId = null;
        try {
            docId = IdentifierManager.getInstance().getLocalId(this.guid);
        }
        catch (McdbDocNotFoundException e) {
            return false;
        }
        docId = DocumentUtil.getDocIdFromString(docId);
        Statement pStmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("PermissionControl.isAccessDoc");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement("select doctype from xml_documents where docid like ? ");
            pStmt.setString(1, docId);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            String doctype = null;
            if (hasRow) {
                doctype = rs.getString(1);
            }
            pStmt.close();
            if (doctype != null && MetacatUtil.getOptionList(PropertyService.getProperty("xml.accessdoctype")).contains(doctype)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new SQLException("PermissionControl.isAccessDocument Error checking on document " + docId + ". " + e.getMessage());
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SQLException("PermissionControl.isAccessDocument Error checking on document " + docId + ". " + pnfe.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containDocumentOwner(String[] principals) throws SQLException {
        String docId = null;
        try {
            docId = IdentifierManager.getInstance().getLocalId(this.guid);
            docId = DocumentUtil.getDocIdFromString(docId);
        }
        catch (McdbDocNotFoundException e) {
            return false;
        }
        int lengthOfArray = principals.length;
        Statement pStmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("PermissionControl.containDocOnwer");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement("SELECT 'x' FROM xml_documents WHERE docid = ? AND lower(user_owner) = ? UNION ALL SELECT 'x' FROM xml_revisions WHERE docid = ? AND lower(user_owner) = ? ");
            for (int i = 0; i < lengthOfArray; ++i) {
                pStmt.setString(1, docId);
                pStmt.setString(2, principals[i]);
                pStmt.setString(3, docId);
                pStmt.setString(4, principals[i]);
                logMetacat.info((Object)("PermissionController.containDocumentOwner - the principle stack is : " + principals[i]));
                pStmt.execute();
                ResultSet rs = pStmt.getResultSet();
                boolean hasRow = rs.next();
                if (!hasRow) continue;
                pStmt.close();
                logMetacat.info((Object)"PermissionController.containDocumentOwner - find the owner");
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            pStmt.close();
            throw new SQLException("PermissionControl.hasPermission - Error checking ownership for " + principals[0] + " on document #" + docId + ". " + e.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllowFirst(String[] principals, long startId) throws SQLException, Exception {
        int lengthOfArray = principals.length;
        Statement pStmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        String sql = null;
        boolean topLever = false;
        if (startId == 0L) {
            topLever = true;
            sql = "SELECT perm_order FROM xml_access WHERE lower(principal_name) = ? AND guid = ? AND startnodeid is NULL";
        } else {
            sql = "SELECT perm_order FROM xml_access WHERE lower(principal_name) = ? AND guid = ? AND startnodeid = ?";
        }
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlList.isAllowFirst");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            for (int i = 0; i < lengthOfArray; ++i) {
                pStmt.setString(1, principals[i]);
                pStmt.setString(2, this.guid);
                if (!topLever) {
                    pStmt.setLong(3, startId);
                }
                pStmt.execute();
                ResultSet rs = pStmt.getResultSet();
                boolean hasRow = rs.next();
                if (!hasRow) continue;
                String permissionOrder = rs.getString(1);
                if (permissionOrder.equalsIgnoreCase("allowFirst")) {
                    pStmt.close();
                    boolean bl = true;
                    return bl;
                }
                pStmt.close();
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        throw new Exception("PermissionController.isAllowFirst - There is no permission record for user " + principals[0] + " at document " + this.guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAllowRule(String[] principals, int permission, long startId) throws SQLException, Exception {
        int lengthOfArray = principals.length;
        boolean allow = false;
        Statement pStmt = null;
        int permissionValue = permission;
        DBConnection conn = null;
        int serialNumber = -1;
        boolean topLever = false;
        String sql = null;
        if (startId == 0L) {
            topLever = true;
            sql = "SELECT permission FROM xml_access WHERE guid = ? AND lower(principal_name) = ? AND perm_type = ? AND startnodeid is NULL";
        } else {
            topLever = false;
            sql = "SELECT permission FROM xml_access WHERE guid = ? AND lower(principal_name) = ? AND perm_type = ? AND startnodeid = ?";
        }
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlList.hasAllowRule");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            pStmt.setString(1, this.guid);
            pStmt.setString(3, "allow");
            if (!topLever) {
                pStmt.setLong(4, startId);
            }
            for (int i = 0; i < lengthOfArray; ++i) {
                pStmt.setString(2, principals[i]);
                pStmt.execute();
                ResultSet rs = pStmt.getResultSet();
                while (rs.next()) {
                    int permissionValueInTable = rs.getInt(1);
                    if ((permissionValueInTable & permissionValue) != permissionValue) continue;
                    allow = true;
                }
            }
        }
        catch (SQLException sqlE) {
            throw sqlE;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasExplicitDenyRule(String[] principals, int permission, long startId) throws SQLException {
        int lengthOfArray = principals.length;
        Statement pStmt = null;
        int permissionValue = permission;
        DBConnection conn = null;
        int serialNumber = -1;
        String sql = null;
        boolean topLevel = false;
        if (startId == 0L) {
            topLevel = true;
            sql = "SELECT permission FROM xml_access WHERE guid = ? AND lower(principal_name) = ? AND perm_type = ? AND startnodeid is NULL";
        } else {
            topLevel = false;
            sql = "SELECT permission FROM xml_access WHERE guid = ? AND lower(principal_name) = ? AND perm_type = ? AND startnodeid = ?";
        }
        try {
            conn = DBConnectionPool.getDBConnection("PermissionControl.hasExplicitDeny");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            pStmt.setString(1, this.guid);
            pStmt.setString(3, "deny");
            if (!topLevel) {
                pStmt.setLong(4, startId);
            }
            for (int i = 0; i < lengthOfArray; ++i) {
                pStmt.setString(2, principals[i]);
                pStmt.execute();
                ResultSet rs = pStmt.getResultSet();
                while (rs.next()) {
                    int permissionValueInTable = rs.getInt(1);
                    if ((permissionValueInTable & permissionValue) != permissionValue) continue;
                    pStmt.close();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return false;
    }

    private String[] createUsersPackage(String user, String[] groups) {
        String[] usersPackage = null;
        if (groups != null) {
            if (!user.equalsIgnoreCase("public")) {
                int lengthOfPackage = groups.length + 2;
                usersPackage = new String[lengthOfPackage];
                if (user != null) {
                    usersPackage[0] = user.toLowerCase();
                    logMetacat.info((Object)("PermissionController.createUsersPackage - after transfer to lower case(not null): " + usersPackage[0]));
                } else {
                    usersPackage[0] = user;
                    usersPackage[0] = user.toLowerCase();
                    logMetacat.info((Object)("PermissionController.createUsersPackage - after transfer to lower case(null): " + usersPackage[0]));
                }
                usersPackage[1] = "public";
                for (int i = 2; i < lengthOfPackage; ++i) {
                    if (groups[i - 2] == null) continue;
                    usersPackage[i] = groups[i - 2].toLowerCase();
                }
            } else {
                int lengthOfPackage = groups.length + 1;
                usersPackage = new String[lengthOfPackage];
                usersPackage[0] = "public";
                for (int i = 1; i < lengthOfPackage; ++i) {
                    if (groups[i - 1] == null) continue;
                    usersPackage[i] = groups[i - 1].toLowerCase();
                }
            }
        } else if (!user.equalsIgnoreCase("public")) {
            int lengthOfPackage = 2;
            usersPackage = new String[lengthOfPackage];
            usersPackage[0] = user != null ? user.toLowerCase() : user;
            usersPackage[1] = "public";
        } else {
            int lengthOfPackage = 1;
            usersPackage = new String[lengthOfPackage];
            usersPackage[0] = "public";
        }
        return usersPackage;
    }

    public static Hashtable<String, String> getUnReadableInlineDataIdList(String docid, String user, String[] groups) throws McdbException {
        Hashtable<String, String> inlineDataList = PermissionController.getUnAccessableInlineDataIdList(docid, user, groups, "READ");
        return inlineDataList;
    }

    public static Hashtable<String, String> getUnWritableInlineDataIdList(String docidWithoutRev, String user, String[] groups, boolean withRevision) throws Exception {
        Hashtable<String, String> inlineDataList = PermissionController.getUnAccessableInlineDataIdList(docidWithoutRev, user, groups, "WRITE");
        return inlineDataList;
    }

    private static Hashtable<String, String> getUnAccessableInlineDataIdList(String docid, String user, String[] groups, String permission) throws McdbException {
        Hashtable allIdList;
        Hashtable<String, String> unAccessibleIdList = new Hashtable<String, String>();
        if (user == null) {
            return unAccessibleIdList;
        }
        try {
            allIdList = PermissionController.getAllInlineDataIdList(docid);
        }
        catch (SQLException e) {
            throw new McdbException(e.getMessage());
        }
        Enumeration en = allIdList.keys();
        while (en.hasMoreElements()) {
            PermissionController controller = new PermissionController(docid);
            String subTreeId = (String)en.nextElement();
            String fileId = (String)allIdList.get(subTreeId);
            if (controller.hasPermissionForInlineData(user, groups, permission, fileId)) continue;
            logMetacat.info((Object)("PermissionController.getUnAccessableInlineDataIdList - Put subtree id " + subTreeId + " and " + "inline data file name " + fileId + " into " + "un" + permission + " hash"));
            unAccessibleIdList.put(subTreeId, fileId);
        }
        return unAccessibleIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getAllInlineDataIdList(String docid) throws SQLException {
        Hashtable<String, String> inlineDataList = new Hashtable<String, String>();
        String sql = "SELECT subtreeid, guid FROM xml_access WHERE accessfileid = ? AND subtreeid IS NOT NULL";
        Statement pStmt = null;
        ResultSet rs = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("PermissionControl.getDataSetId");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement(sql);
            pStmt.setString(1, docid);
            pStmt.execute();
            rs = pStmt.getResultSet();
            while (rs.next()) {
                String subTreeId = rs.getString(1);
                String inlineDataId = rs.getString(2);
                if (subTreeId == null || subTreeId.trim().equals("") || inlineDataId == null || inlineDataId.trim().equals("")) continue;
                inlineDataList.put(subTreeId, inlineDataId);
            }
        }
        finally {
            try {
                pStmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return inlineDataList;
    }
}

