/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.BasicNode;
import edu.ucsb.nceas.metacat.QueryGroup;
import edu.ucsb.nceas.metacat.QueryTerm;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class QuerySpecification
extends DefaultHandler {
    private boolean containsExtendedSQL = false;
    private boolean containsPredicates = false;
    private String meta_file_id;
    private String queryTitle;
    private Vector returnDocList;
    private Vector filterDocList;
    private Vector returnFieldList;
    private Vector returnFieldListWithPredicates;
    private Vector ownerList;
    private QueryGroup query = null;
    private StringBuffer xml = new StringBuffer();
    private Stack elementStack;
    private Stack queryStack;
    private String currentValue;
    private String currentPathexpr;
    private String parserName = null;
    private String accNumberSeparator = null;
    private boolean percentageSearch = false;
    private String userName = null;
    private static final String PUBLIC = "public";
    private String[] group = null;
    public static final String ATTRIBUTESYMBOL = "@";
    public static final char PREDICATE_START = '[';
    public static final char PREDICATE_END = ']';
    private StringBuffer textBuffer = new StringBuffer();
    private static Logger logMetacat = Logger.getLogger(QuerySpecification.class);

    public QuerySpecification(Reader queryspec, String parserName, String accNumberSeparator) throws IOException {
        this.returnDocList = new Vector();
        this.filterDocList = new Vector();
        this.elementStack = new Stack();
        this.queryStack = new Stack();
        this.returnFieldList = new Vector();
        this.returnFieldListWithPredicates = new Vector();
        this.ownerList = new Vector();
        this.parserName = parserName;
        this.accNumberSeparator = accNumberSeparator;
        XMLReader parser = this.initializeParser();
        if (parser == null) {
            logMetacat.error((Object)"QuerySpecification() - SAX parser not instantiated properly.");
        }
        try {
            parser.parse(new InputSource(queryspec));
        }
        catch (SAXException se) {
            logMetacat.error((Object)("QuerySpecification() - SAX error parsing data: " + se.getMessage()));
        }
    }

    public QuerySpecification(String queryspec, String parserName, String accNumberSeparator) throws IOException {
        this(new StringReader(queryspec), parserName, accNumberSeparator);
    }

    public QuerySpecification(String accNumberSeparator) throws IOException {
        this.returnDocList = new Vector();
        this.filterDocList = new Vector();
        this.elementStack = new Stack();
        this.queryStack = new Stack();
        this.returnFieldList = new Vector();
        this.returnFieldListWithPredicates = new Vector();
        this.ownerList = new Vector();
        this.accNumberSeparator = accNumberSeparator;
    }

    public void setUserName(String myName) {
        this.userName = myName != null ? myName.toLowerCase() : myName;
    }

    public void setGroup(String[] myGroup) {
        this.group = myGroup;
    }

    public boolean isPercentageSearch() {
        return this.percentageSearch;
    }

    private String createOwnerQuery() {
        String ownerQuery = null;
        if (this.userName != null && !this.userName.equalsIgnoreCase(PUBLIC)) {
            ownerQuery = "SELECT docid FROM xml_documents WHERE ";
            if (this.userName != null && !this.userName.equals("")) {
                ownerQuery = ownerQuery + "lower(user_owner) ='" + this.userName + "'";
            }
        }
        logMetacat.info((Object)("QuerySpecification.createOwerQuery - OwnerQuery: " + ownerQuery));
        return ownerQuery;
    }

    private String createAllowRuleQuery() {
        String allowQuery = null;
        String allowString = this.constructAllowString();
        allowQuery = "SELECT guid from xml_access  WHERE ( " + allowString;
        allowQuery = allowQuery + ")";
        logMetacat.info((Object)("QuerySpecification.createAllowRuleQuery - allow query is: " + allowQuery));
        return allowQuery;
    }

    private String constructAllowString() {
        String allowQuery = "";
        allowQuery = "(lower(principal_name) = 'public'";
        if (this.userName != null && !this.userName.equals("") && !this.userName.equalsIgnoreCase(PUBLIC)) {
            allowQuery = allowQuery + "OR lower(principal_name) = '" + this.userName + "'";
        }
        if (this.group != null) {
            for (int i = 0; i < this.group.length; ++i) {
                String groupUint = this.group[i];
                if (groupUint == null || groupUint.equals("")) continue;
                groupUint = groupUint.toLowerCase();
                allowQuery = allowQuery + " OR lower(principal_name) = '" + groupUint + "'";
            }
        }
        allowQuery = allowQuery + ") AND perm_type = 'allow'" + " AND permission > 3";
        logMetacat.info((Object)("QuerySpecification.constructAllowString - allow string is: " + allowQuery));
        return allowQuery;
    }

    private String createDenyRuleQuery() {
        String denyQuery = null;
        String denyString = this.constructDenyString();
        denyQuery = "SELECT guid from xml_access WHERE ( " + denyString;
        denyQuery = denyQuery + ") ";
        logMetacat.info((Object)("QuerySpecification.createDenyRuleQuery - denyquery is: " + denyQuery));
        return denyQuery;
    }

    private String constructDenyString() {
        String denyQuery = "";
        denyQuery = "(lower(principal_name) = 'public'";
        if (this.userName != null && !this.userName.equals("") && !this.userName.equalsIgnoreCase(PUBLIC)) {
            denyQuery = denyQuery + "OR lower(principal_name) = '" + this.userName + "'";
        }
        if (this.group != null) {
            for (int i = 0; i < this.group.length; ++i) {
                String groupUint = this.group[i];
                if (groupUint == null || groupUint.equals("")) continue;
                groupUint = groupUint.toLowerCase();
                denyQuery = denyQuery + " OR lower(principal_name) = '" + groupUint + "'";
            }
        }
        denyQuery = denyQuery + ") AND perm_type = 'deny'" + " AND perm_order ='allowFirst'" + " AND permission > 3";
        logMetacat.info((Object)("QuerySpecification.constructDenyString - deny string is: " + denyQuery));
        return denyQuery;
    }

    public String getAccessQuery() {
        String accessQuery = null;
        String owner = this.createOwnerQuery();
        String allow = this.createAllowRuleQuery();
        String deny = this.createDenyRuleQuery();
        if (owner != null) {
            accessQuery = " AND (xml_documents.docid IN (" + owner + ")";
            accessQuery = accessQuery + " OR (identifier.guid IN (" + allow + ")" + " AND identifier.guid NOT IN (" + deny + ")))";
        } else {
            accessQuery = " AND (identifier.guid IN (" + allow + ")" + " AND identifier.guid NOT IN (" + deny + "))";
        }
        logMetacat.info((Object)("QuerySpecification.getAccessQuery - access query is: " + accessQuery));
        return accessQuery;
    }

    public boolean containsExtendedSQL() {
        return this.containsExtendedSQL;
    }

    public String getIdentifier() {
        return this.meta_file_id;
    }

    public void setIdentifier(String id) {
        this.meta_file_id = id;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public void setQueryTitle(String title) {
        this.queryTitle = title;
    }

    public Vector getReturnDocList() {
        return this.returnDocList;
    }

    public void setReturnDocList(Vector returnDocList) {
        this.returnDocList = returnDocList;
    }

    public Vector getFilterDocList() {
        return this.filterDocList;
    }

    public void setFilterDocList(Vector filterDocList) {
        this.filterDocList = filterDocList;
    }

    public Vector getReturnFieldList() {
        return this.returnFieldList;
    }

    public void setReturnFieldList(Vector returnFieldList) {
        this.returnFieldList = returnFieldList;
    }

    public Vector getOwnerList() {
        return this.ownerList;
    }

    public void setOwnerList(Vector ownerList) {
        this.ownerList = ownerList;
    }

    public QueryGroup getQueryGroup() {
        return this.query;
    }

    public void setQueryGroup(QueryGroup group) {
        this.query = group;
    }

    public void setContainsExtenedSQL(boolean hasExtenedQuery) {
        this.containsExtendedSQL = hasExtenedQuery;
    }

    private XMLReader initializeParser() {
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader(this.parserName);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
        }
        catch (Exception e) {
            logMetacat.error((Object)("QuerySpecification.getAccessQuery - Error: " + e.getMessage()));
        }
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        logMetacat.debug((Object)("QuerySpecification.startElement - start element " + localName));
        BasicNode currentNode = new BasicNode(localName);
        this.xml.append("<");
        this.xml.append(localName);
        if (atts != null) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                currentNode.setAttribute(atts.getLocalName(i), atts.getValue(i));
                this.xml.append(" ");
                this.xml.append(atts.getLocalName(i));
                this.xml.append("=\"");
                this.xml.append(atts.getValue(i));
                this.xml.append("\"");
            }
        }
        this.xml.append(">");
        this.elementStack.push(currentNode);
        if (currentNode.getTagName().equals("querygroup")) {
            QueryGroup currentGroup = new QueryGroup(currentNode.getAttribute("operator"));
            if (this.query == null) {
                this.query = currentGroup;
            } else {
                QueryGroup parentGroup = (QueryGroup)this.queryStack.peek();
                parentGroup.addChild(currentGroup);
            }
            this.queryStack.push(currentGroup);
        }
        logMetacat.debug((Object)("QuerySpecification.startElement - ending startElement " + localName));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        logMetacat.debug((Object)("QuerySpecification.endElement - endElement " + localName));
        BasicNode leaving = (BasicNode)this.elementStack.pop();
        if (leaving.getTagName().equals("queryterm")) {
            boolean isCaseSensitive = new Boolean(leaving.getAttribute("casesensitive"));
            QueryTerm currentTerm = null;
            currentTerm = this.currentPathexpr == null ? new QueryTerm(isCaseSensitive, leaving.getAttribute("searchmode"), this.currentValue) : new QueryTerm(isCaseSensitive, leaving.getAttribute("searchmode"), this.currentValue, this.currentPathexpr);
            QueryGroup currentGroup = (QueryGroup)this.queryStack.peek();
            currentGroup.addChild(currentTerm);
            this.currentValue = null;
            this.currentPathexpr = null;
        } else if (leaving.getTagName().equals("querygroup")) {
            QueryGroup isCaseSensitive = (QueryGroup)this.queryStack.pop();
        } else if (leaving.getTagName().equals("meta_file_id")) {
            this.meta_file_id = this.textBuffer.toString().trim();
        } else if (leaving.getTagName().equals("querytitle")) {
            this.queryTitle = this.textBuffer.toString().trim();
        } else if (leaving.getTagName().equals("value")) {
            this.currentValue = this.textBuffer.toString().trim();
            this.currentValue = MetacatUtil.normalize(this.currentValue);
        } else if (leaving.getTagName().equals("pathexpr")) {
            this.currentPathexpr = this.textBuffer.toString().trim();
        } else if (leaving.getTagName().equals("returndoctype")) {
            this.returnDocList.add(this.textBuffer.toString().trim());
        } else if (leaving.getTagName().equals("filterdoctype")) {
            this.filterDocList.add(this.textBuffer.toString().trim());
        } else if (leaving.getTagName().equals("returnfield")) {
            this.handleReturnField(this.textBuffer.toString().trim());
        } else if (leaving.getTagName().equals("filterdoctype")) {
            this.filterDocList.add(this.textBuffer.toString().trim());
        } else if (leaving.getTagName().equals("owner")) {
            this.ownerList.add(this.textBuffer.toString().trim());
        }
        String normalizedXML = this.textBuffer.toString().trim();
        logMetacat.debug((Object)("QuerySpecification.endElement - before normalize: " + normalizedXML));
        normalizedXML = MetacatUtil.normalize(normalizedXML);
        logMetacat.debug((Object)("QuerySpecification.endElement - after normalize " + normalizedXML));
        this.xml.append(normalizedXML);
        this.xml.append("</");
        this.xml.append(localName);
        this.xml.append(">");
        this.textBuffer = new StringBuffer();
    }

    public String getNormalizedXMLQuery() {
        return this.xml.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length);
        logMetacat.debug((Object)("QuerySpecification.characters - the text in characters " + text));
        this.textBuffer.append(text);
    }

    public void handleReturnField(String inputString) {
        int attributePos = inputString.indexOf(ATTRIBUTESYMBOL);
        int predicateStart = -1;
        boolean hasPredicate = false;
        while (true) {
            predicateStart = inputString.indexOf(91, predicateStart + 1);
            if (attributePos == -1 || predicateStart == -1) break;
            hasPredicate = true;
            if (attributePos < predicateStart) break;
            int predicateEnd = inputString.indexOf(93, predicateStart);
            if (predicateEnd == -1) {
                logMetacat.warn((Object)("QuerySpecification.handleReturnField - Invalid path: " + inputString));
                return;
            }
            while (attributePos < predicateEnd && (attributePos = inputString.indexOf(ATTRIBUTESYMBOL, attributePos + 1)) != -1) {
            }
        }
        if (hasPredicate) {
            this.containsPredicates = true;
            this.returnFieldListWithPredicates.add(inputString);
        }
        this.containsExtendedSQL = true;
        logMetacat.info((Object)"QuerySpecification.handleReturnField - there are no attributes in the XPATH statement");
        this.returnFieldList.add(inputString);
    }

    public String printSQL(boolean useXMLIndex, List<Object> parameterValues) {
        Enumeration en;
        StringBuffer self = new StringBuffer();
        StringBuffer queryString = new StringBuffer();
        queryString.append("SELECT xml_documents.docid, identifier.guid, docname, doctype, date_created, date_updated, xml_documents.rev ");
        queryString.append("FROM xml_documents, identifier ");
        queryString.append("WHERE xml_documents.docid = identifier.docid AND xml_documents.rev = identifier.rev AND");
        ArrayList<Object> groupValues = new ArrayList<Object>();
        String queryFromQueryGroup = this.query != null ? this.query.printSQL(useXMLIndex, groupValues) : "";
        logMetacat.info((Object)("QuerySpecification.printSQL - Query : " + queryFromQueryGroup));
        if (!queryFromQueryGroup.trim().equals("")) {
            self.append(" xml_documents.docid IN (");
            self.append(queryFromQueryGroup);
            self.append(") ");
            parameterValues.addAll(groupValues);
        }
        if (!this.filterDocList.isEmpty()) {
            boolean firstdoctype = true;
            if (!self.toString().equals("")) {
                self.append(" AND ");
            }
            self.append(" (");
            en = this.filterDocList.elements();
            while (en.hasMoreElements()) {
                String currentDoctype = (String)en.nextElement();
                if (firstdoctype) {
                    firstdoctype = false;
                    self.append(" doctype = ?");
                } else {
                    self.append(" OR doctype = ?");
                }
                parameterValues.add(currentDoctype);
            }
            self.append(") ");
        }
        if (!this.ownerList.isEmpty()) {
            boolean first = true;
            if (!self.toString().equals("")) {
                self.append(" AND ");
            }
            self.append(" (");
            en = this.ownerList.elements();
            while (en.hasMoreElements()) {
                String current = (String)en.nextElement();
                if (current != null) {
                    current = current.toLowerCase();
                }
                if (first) {
                    first = false;
                    self.append(" lower(user_owner) = ?");
                } else {
                    self.append(" OR lower(user_owner) = ?");
                }
                parameterValues.add(current);
            }
            self.append(") ");
        }
        if (this.query != null) {
            logMetacat.info((Object)("QuerySpecification.printSQL - percentage number: " + this.query.getPercentageSymbolCount()));
            if (this.query.getPercentageSymbolCount() == 1) {
                logMetacat.info((Object)"QuerySpecification.printSQL - It is a percentage search");
                this.percentageSearch = true;
            }
        }
        queryString.append(self.toString());
        return queryString.toString();
    }

    public String printExtendedSQL(String doclist, boolean useXMLIndex, List<Object> allValues, List<Object> docListValues) {
        if (useXMLIndex && !this.containsPredicates) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            String query = this.printExtendedSQL(doclist, parameterValues, docListValues);
            allValues.addAll(parameterValues);
            return query;
        }
        StringBuffer self = new StringBuffer();
        boolean firstfield = true;
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String queryFromWithoutPrecidates = this.printExtendedSQL(doclist, parameterValues, docListValues);
        allValues.addAll(parameterValues);
        if (queryFromWithoutPrecidates != null) {
            self.append(queryFromWithoutPrecidates);
            firstfield = false;
        }
        for (int i = 0; i < this.returnFieldListWithPredicates.size(); ++i) {
            if (firstfield) {
                firstfield = false;
            } else {
                self.append(" UNION ");
            }
            String path = (String)this.returnFieldListWithPredicates.elementAt(i);
            allValues.add(path);
            self.append("select xml_nodes.docid, ");
            self.append("? as path, ");
            self.append("xml_nodes.nodedata, ");
            self.append("xml_nodes.parentnodeid, ");
            self.append("xml_nodes.nodetype ");
            self.append("from xml_nodes ");
            self.append("where ");
            ArrayList<Object> nestedParameterValues = new ArrayList<Object>();
            String nestedQuery = QueryTerm.useNestedStatements(path, nestedParameterValues);
            self.append(nestedQuery);
            allValues.addAll(nestedParameterValues);
            self.append(" AND xml_nodes.docid in (");
            self.append(doclist);
            allValues.addAll(docListValues);
            if (this.returnFieldIsAttribute(path)) {
                self.append(")");
                continue;
            }
            self.append(") AND xml_nodes.nodetype = 'TEXT'");
        }
        return self.toString();
    }

    private boolean returnFieldIsAttribute(String path) {
        boolean isAttribute = false;
        if (path != null) {
            int slashIndex = path.lastIndexOf("/");
            if (slashIndex != -1) {
                path = path.substring(slashIndex + 1);
            }
            logMetacat.debug((Object)("QuerySpecification.returnFieldIsAttribute - final path is " + path));
            if (path.charAt(0) == '@') {
                logMetacat.debug((Object)"QuerySpecification.returnFieldIsAttribute - it is an attribute");
                isAttribute = true;
            }
        }
        return isAttribute;
    }

    private String printExtendedSQL(String doclist, List<Object> values, List<Object> docListValues) {
        logMetacat.debug((Object)"QuerySpecification.printExtendedSQL - in printExtendedSQL");
        StringBuffer self = new StringBuffer();
        Vector<String> elementVector = new Vector<String>();
        Vector<String> attributeVector = new Vector<String>();
        boolean usePathIndex = true;
        if (this.returnFieldList.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.returnFieldList.size(); ++i) {
            String path = (String)this.returnFieldList.elementAt(i);
            if (this.returnFieldListWithPredicates.contains(path)) continue;
            if (path != null && path.indexOf(ATTRIBUTESYMBOL) != -1) {
                attributeVector.add(path);
            } else {
                elementVector.add(path);
            }
            try {
                if (SystemUtil.getPathsForIndexing().contains(path)) continue;
                usePathIndex = false;
                continue;
            }
            catch (MetacatUtilException mue) {
                logMetacat.warn((Object)("QuerySpecification.printExtendedSQL - Could not get index paths: " + mue.getMessage()));
            }
        }
        if (elementVector.size() == 0 && attributeVector.size() == 0) {
            return null;
        }
        if (usePathIndex) {
            self.append("select docid, path, nodedata, parentnodeid, null as nodetype ");
            self.append("from xml_path_index where path in ( ");
            boolean firstfield = true;
            for (int i = 0; i < this.returnFieldList.size(); ++i) {
                String returnField = (String)this.returnFieldList.elementAt(i);
                returnField = returnField.replaceAll("'", "''");
                if (firstfield) {
                    firstfield = false;
                    self.append("? ");
                    values.add(returnField);
                    continue;
                }
                self.append(", ? ");
                values.add(returnField);
            }
            self.append(") AND docid in (");
            self.append(doclist);
            values.addAll(docListValues);
            self.append(")");
        } else {
            String path;
            self.append("select xml_nodes.docid, xml_index.path, xml_nodes.nodedata,  ");
            self.append("xml_nodes.parentnodeid, ");
            self.append("xml_nodes.nodetype ");
            self.append("FROM xml_index, xml_nodes WHERE (");
            boolean firstElement = true;
            boolean firstAttribute = true;
            if (elementVector.size() != 0) {
                for (int i = 0; i < elementVector.size(); ++i) {
                    path = (String)elementVector.elementAt(i);
                    if (firstElement) {
                        firstElement = false;
                        self.append(" (xml_index.nodeid=xml_nodes.parentnodeid AND xml_index.path IN ( ");
                        self.append("?");
                        values.add(path);
                        continue;
                    }
                    self.append(", ? ");
                    values.add(path);
                }
                self.append(") AND xml_nodes.nodetype = 'TEXT')");
            }
            if (attributeVector.size() != 0) {
                for (int j = 0; j < attributeVector.size(); ++j) {
                    path = (String)attributeVector.elementAt(j);
                    if (firstAttribute) {
                        firstAttribute = false;
                        if (!firstElement) {
                            self.append(" OR ");
                        }
                        self.append(" (xml_index.nodeid=xml_nodes.nodeid AND ( xml_index.path IN ( ");
                        self.append("?");
                        values.add(path);
                        continue;
                    }
                    self.append(", ? ");
                    values.add(path);
                }
                self.append(") AND xml_nodes.nodetype = 'ATTRIBUTE'))");
            }
            self.append(") AND xml_nodes.docid in (");
            self.append(doclist);
            values.addAll(docListValues);
            self.append(")");
        }
        return self.toString();
    }

    public String getSortedReturnFieldString() {
        String returnFields = "";
        Vector tempVector = new Vector();
        Iterator it = this.returnFieldList.iterator();
        while (it.hasNext()) {
            tempVector.add(it.next());
        }
        Collections.sort(tempVector);
        it = tempVector.iterator();
        while (it.hasNext()) {
            returnFields = returnFields + it.next() + "|";
        }
        return returnFields;
    }

    public static String printRelationSQL(String docid) {
        StringBuffer self = new StringBuffer();
        self.append("select subject, relationship, object, subdoctype, ");
        self.append("objdoctype from xml_relation ");
        self.append("where docid like '").append(docid).append("'");
        return self.toString();
    }

    public static String printGetDocByDoctypeSQL(String docid) {
        StringBuffer self = new StringBuffer();
        self.append("SELECT docid,docname,doctype,");
        self.append("date_created, date_updated ");
        self.append("FROM xml_documents WHERE docid IN (");
        self.append(docid).append(")");
        return self.toString();
    }

    public String toString() {
        return "meta_file_id=" + this.meta_file_id + "\n" + this.query;
    }

    public static String newPathExpressionWithOutAttribute(String pathExpression) {
        if (pathExpression == null) {
            return null;
        }
        int index = pathExpression.lastIndexOf(ATTRIBUTESYMBOL);
        String newExpression = null;
        if (index != 0) {
            newExpression = pathExpression.substring(0, index - 1);
        }
        logMetacat.info((Object)("QuerySpecification.newPathExpressionWithOutAttribute - The path expression without attributes: " + newExpression));
        return newExpression;
    }

    public static String getAttributeName(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(ATTRIBUTESYMBOL);
        int size = path.length();
        String attributeName = null;
        if (index != 1) {
            attributeName = path.substring(index + 1, size);
        }
        logMetacat.info((Object)("QuerySpecification.getAttributeName - The attirbute name from path: " + attributeName));
        return attributeName;
    }
}

