/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.GeoserverUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GeoserverAdmin
extends MetacatAdmin {
    private static GeoserverAdmin geoserverAdmin = null;
    private Logger logMetacat = Logger.getLogger(GeoserverAdmin.class);

    private GeoserverAdmin() throws AdminException {
    }

    public static GeoserverAdmin getInstance() throws AdminException {
        if (geoserverAdmin == null) {
            geoserverAdmin = new GeoserverAdmin();
        }
        return geoserverAdmin;
    }

    public void configureGeoserver(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String bypass = request.getParameter("bypass");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                String username = PropertyService.getProperty("geoserver.username");
                String password = PropertyService.getProperty("geoserver.password");
                String context = PropertyService.getProperty("geoserver.context");
                String dataDir = PropertyService.getProperty("geoserver.GEOSERVER_DATA_DIR");
                String regenerateCache = PropertyService.getProperty("spatial.regenerateCacheOnRestart");
                boolean regenerate = false;
                if (regenerateCache != null) {
                    regenerate = Boolean.parseBoolean(regenerateCache);
                }
                if (dataDir == null || dataDir.length() == 0) {
                    dataDir = SystemUtil.getContextDir() + FileUtil.getFS() + "spatial" + FileUtil.getFS() + "geoserver" + FileUtil.getFS() + "data";
                }
                request.setAttribute("geoserver.username", (Object)username);
                request.setAttribute("geoserver.password", (Object)password);
                request.setAttribute("geoserver.context", (Object)context);
                request.setAttribute("geoserver.GEOSERVER_DATA_DIR", (Object)dataDir);
                request.setAttribute("spatial.regenerateCacheOnRestart", (Object)regenerate);
                RequestUtil.forwardRequest(request, response, "/admin/geoserver-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("GeoserverAdmin.configureGeoserver - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("GeoserverAdmin.configureGeoserver - utility problem while initializing system properties page:" + mue.getMessage());
            }
        }
        if (bypass != null && bypass.equals("true")) {
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                PropertyService.setProperty("configutil.geoserverConfigured", "bypassed");
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "GeoserverAdmin.configureGeoserver - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                }
                processingSuccess.add("Geoserver configuration successfully bypassed");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("GeoserverAdmin.configureGeoserver - utility problem while processing geoservices geoservices page: " + mue.getMessage());
            }
        } else {
            Vector<String> validationErrors = new Vector<String>();
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                validationErrors.addAll(this.validateOptions(request));
                String username = request.getParameter("geoserver.username");
                String password = request.getParameter("geoserver.password");
                String context = request.getParameter("geoserver.context");
                String dataDir = request.getParameter("geoserver.GEOSERVER_DATA_DIR");
                String regenerateCache = request.getParameter("spatial.regenerateCacheOnRestart");
                boolean regenerate = false;
                if (regenerateCache != null) {
                    regenerate = Boolean.parseBoolean(regenerateCache);
                }
                if (context == null || dataDir == null) {
                    validationErrors.add("Context and Data Directory cannot be null");
                } else {
                    PropertyService.setPropertyNoPersist("geoserver.context", context);
                    boolean reconfig = PropertyService.checkAndSetProperty(request, "geoserver.GEOSERVER_DATA_DIR");
                    PropertyService.persistProperties();
                    reconfig = true;
                    if (reconfig) {
                        GeoserverUtil.writeConfig();
                    }
                }
                if (username == null || password == null) {
                    validationErrors.add("User Name and Password cannot be null");
                } else {
                    GeoserverUtil.changePassword(username, password);
                    PropertyService.setPropertyNoPersist("geoserver.username", username);
                    PropertyService.setPropertyNoPersist("geoserver.password", password);
                    PropertyService.setPropertyNoPersist("spatial.regenerateCacheOnRestart", Boolean.toString(regenerate));
                    PropertyService.persistProperties();
                    PropertyService.persistMainBackupProperties();
                }
            }
            catch (MetacatUtilException ue) {
                String errorMessage = "GeoserverAdmin.configureGeoserver - Error updating geoserver password: " + ue.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "GeoserverAdmin.configureGeoserver - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestFormErrors(request, validationErrors);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                } else {
                    PropertyService.setProperty("configutil.geoserverConfigured", "true");
                    processingSuccess.add("Geoserver successfully configured");
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestSuccess(request, processingSuccess);
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                }
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("GeoserverAdmin.configureGeoserver - utility problem while processing geoservices geoservices page: " + mue.getMessage());
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("GeoserverAdmin.configureGeoserver - problem with properties while processing geoservices configuration page: " + gpe.getMessage());
            }
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

