/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.dataone.D1NodeVersionChecker;
import edu.ucsb.nceas.metacat.dataone.DOIService;
import edu.ucsb.nceas.metacat.dataone.SyncAccessPolicy;
import edu.ucsb.nceas.metacat.dataone.SystemMetadataFactory;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrEngineDescriptionHandler;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.DeleteOnCloseFileInputStream;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.XMLUtilities;
import edu.ucsb.nceas.utilities.export.HtmlToPdf;
import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.ZipWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.formats.ObjectFormatInfo;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.mn.tier1.v2.MNCore;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.mn.tier2.v2.MNAuthorization;
import org.dataone.service.mn.tier3.v2.MNStorage;
import org.dataone.service.mn.tier4.v2.MNReplication;
import org.dataone.service.mn.v2.MNPackage;
import org.dataone.service.mn.v2.MNQuery;
import org.dataone.service.mn.v2.MNView;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Ping;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Schedule;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Services;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.Synchronization;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v1_1.QueryField;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ResourceMap;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MNodeService
extends D1NodeService
implements MNAuthorization,
MNCore,
MNRead,
MNReplication,
MNStorage,
MNQuery,
MNView,
MNPackage {
    public static final String UUID_SCHEME = "UUID";
    public static final String DOI_SCHEME = "DOI";
    private static final String UUID_PREFIX = "urn:uuid:";
    private static String XPATH_EML_ID = "/eml:eml/@packageId";
    private Logger logMetacat = Logger.getLogger(MNodeService.class);
    private CNode cn;

    public static MNodeService getInstance(HttpServletRequest request) {
        return new MNodeService(request);
    }

    private MNodeService(HttpServletRequest request) {
        super(request);
        CertificateManager.getInstance().setCertificateLocation(Settings.getConfiguration().getString("D1Client.certificate.file"));
    }

    @Override
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        boolean allowed = false;
        allowed = this.isAdminAuthorized(session);
        String serviceFailureCode = "2902";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        if (!allowed) {
            allowed = this.isAuthoritativeMNodeAdmin(session, pid);
        }
        if (!allowed) {
            throw new NotAuthorized("1320", "The provided identity does not have permission to delete objects on the Node.");
        }
        return super.delete(session, pid);
    }

    /*
     * Unable to fully structure code
     */
    public Identifier update(Session session, Identifier pid, InputStream object, Identifier newPid, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, NotFound, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        serviceFailureCode = "1310";
        sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        localId = null;
        allowed = false;
        isScienceMetadata = false;
        if (session == null) {
            throw new InvalidToken("1210", "No session has been provided");
        }
        subject = session.getSubject();
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("1202", "The provided identifier is invalid.");
        }
        if (!MNodeService.isValidIdentifier(newPid)) {
            throw new InvalidRequest("1202", "The provided identifier is invalid.");
        }
        idExists = true;
        try {
            idExists = IdentifierManager.getInstance().identifierExists(newPid.getValue());
        }
        catch (SQLException e) {
            throw new ServiceFailure("1310", "The requested identifier " + newPid.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
        }
        if (idExists) {
            throw new IdentifierNotUnique("1220", "The requested identifier " + newPid.getValue() + " is already used by another object and" + "therefore can not be used for this object. Clients should choose" + "a new identifier that is unique and retry the operation or " + "use CN.reserveIdentifier() to reserve one.");
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new InvalidRequest("1202", "The object with the provided identifier was not found.");
        }
        catch (SQLException ee) {
            throw new ServiceFailure("1310", "The object with the provided identifier " + pid.getValue() + " can't be identified since - " + ee.getMessage());
        }
        originMemberNode = this.getCapabilities().getIdentifier();
        sysmeta.setOriginMemberNode(originMemberNode);
        sysmeta.setSubmitter(subject);
        now = Calendar.getInstance().getTime();
        sysmeta.setDateSysMetadataModified(now);
        sysmeta.setDateUploaded(now);
        serialVersion = sysmeta.getSerialVersion();
        if (serialVersion == null) {
            sysmeta.setSerialVersion(BigInteger.ZERO);
        }
        if (allowed = this.allowUpdating(session, pid, Permission.WRITE)) {
            if (sysmeta.getObsoletedBy() != null) {
                throw new InvalidSystemMetadata("1300", "Cannot include obsoletedBy when updating object");
            }
            if (sysmeta.getObsoletes() != null && !sysmeta.getObsoletes().getValue().equals(pid.getValue())) {
                throw new InvalidSystemMetadata("1300", "The identifier provided in obsoletes does not match old Identifier");
            }
            existingSysMeta = this.getSystemMetadata(session, pid);
            if (existingSysMeta.getArchived() != null && existingSysMeta.getArchived().booleanValue()) {
                throw new InvalidRequest("1202", "An archived object" + pid.getValue() + " can't be updated");
            }
            existingObsoletedBy = existingSysMeta.getObsoletedBy();
            if (existingObsoletedBy != null) {
                throw new InvalidRequest("1202", "The previous identifier has already been made obsolete by: " + existingObsoletedBy.getValue());
            }
            sidInSys = sysmeta.getSeriesId();
            if (sidInSys != null) {
                if (!MNodeService.isValidIdentifier(sidInSys)) {
                    throw new InvalidSystemMetadata("1300", "The provided series id in the system metadata is invalid.");
                }
                previousSid = existingSysMeta.getSeriesId();
                if (previousSid != null) {
                    if (!sidInSys.getValue().equals(previousSid.getValue())) {
                        try {
                            idExists = IdentifierManager.getInstance().identifierExists(sidInSys.getValue());
                        }
                        catch (SQLException e) {
                            throw new ServiceFailure("1310", "The requested identifier " + sidInSys.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
                        }
                        if (idExists) {
                            throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata doesn't match the previous series id " + previousSid.getValue() + ", so it should NOT exist. However, it was used by another object.");
                        }
                    }
                } else {
                    try {
                        idExists = IdentifierManager.getInstance().identifierExists(sidInSys.getValue());
                    }
                    catch (SQLException e) {
                        throw new ServiceFailure("1310", "The requested identifier " + sidInSys.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
                    }
                    if (idExists) {
                        throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata should NOT exist since the previous series id is null." + "However, it was used by another object.");
                    }
                }
                if (sidInSys.getValue().equals(newPid.getValue())) {
                    throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata shouldn't have the same value of the pid.");
                }
            }
            if (isScienceMetadata = MNodeService.isScienceMetadata(sysmeta)) {
                try {
                    localId = this.insertOrUpdateDocument(object, "UTF-8", pid, session, "update");
                    if (newPid == null) ** GOTO lbl86
                    IdentifierManager.getInstance().createMapping(newPid.getValue(), localId);
                }
                catch (IOException e) {
                    msg = "The Node is unable to create the object. There was a problem converting the object to XML";
                    this.logMetacat.info((Object)msg);
                    throw new ServiceFailure("1310", msg + ": " + e.getMessage());
                }
            } else {
                localId = this.insertDataObject(object, newPid, session);
            }
lbl86:
            // 3 sources

            existingSysMeta.setObsoletedBy(newPid);
            current = existingSysMeta.getSerialVersion();
            current = current.add(BigInteger.ONE);
            existingSysMeta.setSerialVersion(current);
            this.updateSystemMetadata(existingSysMeta);
            sysmeta.setObsoletes(pid);
            this.insertSystemMetadata(sysmeta);
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), subject.getValue(), localId, Event.UPDATE.toString());
            try {
                DOIService.getInstance().registerDOI(sysmeta);
            }
            catch (Exception e) {
                throw new ServiceFailure("1190", "Could not register DOI: " + e.getMessage());
            }
        }
        throw new NotAuthorized("1200", "The provided identity does not have permission to UPDATE the object identified by " + pid.getValue() + " on the Member Node.");
        return newPid;
    }

    @Override
    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        if (session == null) {
            throw new InvalidToken("1110", "Session is required to WRITE to the Node.");
        }
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("1102", "The provided identifier is invalid.");
        }
        sysmeta.setSubmitter(session.getSubject());
        NodeReference originMemberNode = this.getCapabilities().getIdentifier();
        sysmeta.setOriginMemberNode(originMemberNode);
        sysmeta.setArchived(Boolean.valueOf(false));
        Date now = Calendar.getInstance().getTime();
        sysmeta.setDateSysMetadataModified(now);
        sysmeta.setDateUploaded(now);
        sysmeta.setSerialVersion(BigInteger.ZERO);
        if (sysmeta.getObsoletes() != null && sysmeta.getObsoletes().getValue() != null) {
            throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The obsoletes field cannot have a value when creating entries.");
        }
        if (sysmeta.getObsoletedBy() != null && sysmeta.getObsoletedBy().getValue() != null) {
            throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The obsoletedBy field cannot have a value when creating entries.");
        }
        Identifier sid = sysmeta.getSeriesId();
        boolean idExists = false;
        if (sid != null) {
            if (!MNodeService.isValidIdentifier(sid)) {
                throw new InvalidSystemMetadata("1180", "The provided series id is invalid.");
            }
            try {
                idExists = IdentifierManager.getInstance().identifierExists(sid.getValue());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1190", "The series identifier " + sid.getValue() + " in the system metadata couldn't be determined if it is unique since : " + e.getMessage());
            }
            if (idExists) {
                throw new InvalidSystemMetadata("1180", "The series identifier " + sid.getValue() + " is already used by another object and" + "therefore can not be used for this object. Clients should choose" + "a new identifier that is unique and retry the operation or " + "use CN.reserveIdentifier() to reserve one.");
            }
            if (sid.getValue().equals(pid.getValue())) {
                throw new InvalidSystemMetadata("1180", "The series id " + sid.getValue() + " in the system metadata shouldn't have the same value of the pid.");
            }
        }
        Identifier resultPid = super.create(session, pid, object, sysmeta);
        try {
            DOIService.getInstance().registerDOI(sysmeta);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1190", "Could not register DOI: " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return resultPid;
    }

    public boolean replicate(Session session, SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InsufficientResources, UnsupportedType {
        String msg;
        if (session != null && sysmeta != null && sourceNode != null) {
            this.logMetacat.info((Object)("MNodeService.replicate() called with parameters: \n\tSession.Subject      = " + session.getSubject().getValue() + "\n" + "\tidentifier           = " + sysmeta.getIdentifier().getValue() + "\n" + "\tSource NodeReference =" + sourceNode.getValue()));
        }
        boolean result = false;
        String nodeIdStr = null;
        NodeReference nodeId = null;
        Identifier pid = sysmeta.getIdentifier();
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("2153", "The provided identifier in the system metadata is invalid.");
        }
        this.cn = D1Client.getCN();
        InputStream object = null;
        Session thisNodeSession = null;
        Object localSystemMetadata = null;
        ServiceFailure failure = null;
        String localId = null;
        if (session == null || session.getSubject() == null) {
            String msg2 = "No session was provided to replicate identifier " + sysmeta.getIdentifier().getValue();
            this.logMetacat.error((Object)msg2);
            throw new NotAuthorized("2152", msg2);
        }
        try {
            nodeIdStr = PropertyService.getProperty("dataone.nodeId");
            nodeId = new NodeReference();
            nodeId.setValue(nodeIdStr);
        }
        catch (PropertyNotFoundException e1) {
            String msg3 = "Couldn't get dataone.nodeId property: " + e1.getMessage();
            failure = new ServiceFailure("2151", msg3);
            this.logMetacat.error((Object)msg3);
            throw new ServiceFailure("2151", msg3);
        }
        try {
            try {
                localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                try {
                    object = MetacatHandler.read(localId);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Object content not found on this node despite having localId: " + localId));
                    String msg4 = "Can't read the object bytes properly, replica is invalid.";
                    ServiceFailure serviceFailure = new ServiceFailure("2151", msg4);
                    this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)serviceFailure));
                    this.logMetacat.warn((Object)msg4);
                    throw serviceFailure;
                }
            }
            catch (McdbDocNotFoundException e) {
                this.logMetacat.info((Object)"No replica found. Continuing.");
            }
            catch (SQLException ee) {
                throw new ServiceFailure("2151", "Couldn't identify the local id of the object with the specified identifier " + pid.getValue() + " since - " + ee.getMessage());
            }
            if (object == null) {
                D1NodeVersionChecker checker = new D1NodeVersionChecker(sourceNode);
                String nodeVersion = checker.getVersion("MNRead");
                if (nodeVersion != null && nodeVersion.equals("v1")) {
                    org.dataone.client.v1.MNode mNodeV1 = org.dataone.client.v1.itk.D1Client.getMN((NodeReference)sourceNode);
                    object = mNodeV1.getReplica(thisNodeSession, pid);
                } else if (nodeVersion != null && nodeVersion.equals("v2")) {
                    MNode mn = D1Client.getMN((NodeReference)sourceNode);
                    object = mn.getReplica(thisNodeSession, pid);
                } else {
                    throw new ServiceFailure("2151", "The version of MNRead service is " + nodeVersion + " in the source node " + sourceNode.getValue() + " and it is supported. Please check the information in the cn");
                }
                this.logMetacat.info((Object)("MNodeService.getReplica() called for identifier " + pid.getValue()));
            }
        }
        catch (InvalidToken e) {
            String msg5 = "Could not retrieve object to replicate (InvalidToken): " + e.getMessage();
            failure = new ServiceFailure("2151", msg5);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg5);
            throw new ServiceFailure("2151", msg5);
        }
        catch (NotFound e) {
            String msg6 = "Could not retrieve object to replicate (NotFound): " + e.getMessage();
            failure = new ServiceFailure("2151", msg6);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg6);
            throw new ServiceFailure("2151", msg6);
        }
        catch (NotAuthorized e) {
            String msg7 = "Could not retrieve object to replicate (NotAuthorized): " + e.getMessage();
            failure = new ServiceFailure("2151", msg7);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg7);
            throw new ServiceFailure("2151", msg7);
        }
        catch (NotImplemented e) {
            String msg8 = "Could not retrieve object to replicate (mn.getReplica NotImplemented): " + e.getMessage();
            failure = new ServiceFailure("2151", msg8);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg8);
            throw new ServiceFailure("2151", msg8);
        }
        catch (ServiceFailure e) {
            String msg9 = "Could not retrieve object to replicate (ServiceFailure): " + e.getMessage();
            failure = new ServiceFailure("2151", msg9);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg9);
            throw new ServiceFailure("2151", msg9);
        }
        catch (InsufficientResources e) {
            String msg10 = "Could not retrieve object to replicate (InsufficientResources): " + e.getMessage();
            failure = new ServiceFailure("2151", msg10);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg10);
            throw new ServiceFailure("2151", msg10);
        }
        if (object.markSupported()) {
            Checksum givenChecksum = sysmeta.getChecksum();
            Checksum computedChecksum = null;
            try {
                computedChecksum = ChecksumUtil.checksum((InputStream)object, (String)givenChecksum.getAlgorithm());
                object.reset();
            }
            catch (Exception e) {
                String msg11 = "Error computing checksum on replica: " + e.getMessage();
                this.logMetacat.error((Object)msg11);
                ServiceFailure sf = new ServiceFailure("2151", msg11);
                sf.initCause((Throwable)e);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)sf));
                throw sf;
            }
            if (!givenChecksum.getValue().equals(computedChecksum.getValue())) {
                this.logMetacat.error((Object)("Given    checksum for " + pid.getValue() + "is " + givenChecksum.getValue()));
                this.logMetacat.error((Object)("Computed checksum for " + pid.getValue() + "is " + computedChecksum.getValue()));
                msg = "Computed checksum does not match declared checksum";
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                throw new ServiceFailure("2151", msg);
            }
        }
        try {
            if (localId == null) {
                Identifier retPid = super.create(session, pid, object, sysmeta);
                result = retPid.getValue().equals(pid.getValue());
            }
        }
        catch (Exception e) {
            msg = "Could not save object to local store (" + e.getClass().getName() + "): " + e.getMessage();
            failure = new ServiceFailure("2151", msg);
            this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
            this.logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
        this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.COMPLETED, null);
        return result;
    }

    private boolean supportV2Replication(Node node) throws InvalidRequest {
        return this.supportVersionReplication(node, "v2");
    }

    private boolean supportVersionReplication(Node node, String version) throws InvalidRequest {
        boolean support = false;
        if (node == null) {
            throw new InvalidRequest("2153", "There is no capacity information about the node in the replicate.");
        }
        Services services = node.getServices();
        if (services == null) {
            throw new InvalidRequest("2153", "Can't get replica from a node which doesn't have the replicate service.");
        }
        List list = services.getServiceList();
        if (list == null) {
            throw new InvalidRequest("2153", "Can't get replica from a node which doesn't have the replicate service.");
        }
        for (Service service : list) {
            if (service == null || service.getName() == null || !service.getName().equals("MNReplication") || service.getVersion() == null || !service.getVersion().equalsIgnoreCase(version) || !service.getAvailable().booleanValue()) continue;
            support = true;
        }
        return support;
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.get(session, pid);
    }

    public Checksum getChecksum(Session session, Identifier pid, String algorithm) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented {
        Checksum checksum = null;
        String serviceFailure = "1410";
        String notFound = "1420";
        this.checkV1SystemMetaPidExist(pid, serviceFailure, "The checksum for the object specified by " + pid.getValue() + " couldn't be returned ", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        InputStream inputStream = this.get(session, pid);
        try {
            checksum = ChecksumUtil.checksum((InputStream)inputStream, (String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned due to an internal error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned due to an internal error: " + e.getMessage());
        }
        if (checksum == null) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned.");
        }
        return checksum;
    }

    @Override
    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(session, pid);
    }

    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Identifier identifier, Boolean replicaStatus, Integer start, Integer count) throws NotAuthorized, InvalidRequest, NotImplemented, ServiceFailure, InvalidToken {
        NodeReference nodeId = null;
        if (!replicaStatus.booleanValue()) {
            nodeId = new NodeReference();
            try {
                PropertyService.getInstance();
                String currentNodeId = PropertyService.getProperty("dataone.nodeId");
                nodeId.setValue(currentNodeId);
            }
            catch (Exception e) {
                throw new ServiceFailure("1580", e.getMessage());
            }
        }
        return super.listObjects(session, startTime, endTime, objectFormatId, identifier, nodeId, start, count);
    }

    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        String nodeName = null;
        String nodeId = null;
        String subject = null;
        String contactSubject = null;
        String nodeDesc = null;
        String nodeTypeString = null;
        NodeType nodeType = null;
        List mnCoreServiceVersions = null;
        List mnReadServiceVersions = null;
        List mnAuthorizationServiceVersions = null;
        List mnStorageServiceVersions = null;
        List mnReplicationServiceVersions = null;
        boolean nodeSynchronize = false;
        boolean nodeReplicate = false;
        List mnCoreServiceAvailables = null;
        List mnReadServiceAvailables = null;
        List mnAuthorizationServiceAvailables = null;
        List mnStorageServiceAvailables = null;
        List mnReplicationServiceAvailables = null;
        try {
            boolean available;
            String version;
            int i;
            nodeName = Settings.getConfiguration().getString("dataone.nodeName");
            nodeId = Settings.getConfiguration().getString("dataone.nodeId");
            subject = Settings.getConfiguration().getString("dataone.subject");
            contactSubject = Settings.getConfiguration().getString("dataone.contactSubject");
            nodeDesc = Settings.getConfiguration().getString("dataone.nodeDescription");
            nodeTypeString = Settings.getConfiguration().getString("dataone.nodeType");
            nodeType = NodeType.convert((String)nodeTypeString);
            nodeSynchronize = new Boolean(Settings.getConfiguration().getString("dataone.nodeSynchronize"));
            nodeReplicate = new Boolean(Settings.getConfiguration().getString("dataone.nodeReplicate"));
            String serviceName = SystemUtil.getSecureContextURL() + "/" + PropertyService.getProperty("dataone.serviceName");
            Node node = new Node();
            node.setBaseURL(serviceName + "/" + nodeTypeString);
            node.setDescription(nodeDesc);
            node.setState(NodeState.UP);
            Ping canPing = new Ping();
            canPing.setSuccess(Boolean.valueOf(false));
            try {
                Date pingDate = this.ping();
                canPing.setSuccess(Boolean.valueOf(pingDate != null));
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
            node.setPing(canPing);
            NodeReference identifier = new NodeReference();
            identifier.setValue(nodeId);
            node.setIdentifier(identifier);
            Subject s = new Subject();
            s.setValue(subject);
            node.addSubject(s);
            Subject contact = new Subject();
            contact.setValue(contactSubject);
            node.addContactSubject(contact);
            node.setName(nodeName);
            node.setReplicate(nodeReplicate);
            node.setSynchronize(nodeSynchronize);
            Services services = new Services();
            mnCoreServiceVersions = Settings.getConfiguration().getList("dataone.mnCore.serviceVersion");
            mnCoreServiceAvailables = Settings.getConfiguration().getList("dataone.mnCore.serviceAvailable");
            if (mnCoreServiceVersions != null && mnCoreServiceAvailables != null && mnCoreServiceVersions.size() == mnCoreServiceAvailables.size()) {
                for (i = 0; i < mnCoreServiceVersions.size(); ++i) {
                    version = (String)mnCoreServiceVersions.get(i);
                    available = new Boolean((String)mnCoreServiceAvailables.get(i));
                    Service sMNCore = new Service();
                    sMNCore.setName("MNCore");
                    sMNCore.setVersion(version);
                    sMNCore.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNCore);
                }
            }
            mnReadServiceVersions = Settings.getConfiguration().getList("dataone.mnRead.serviceVersion");
            mnReadServiceAvailables = Settings.getConfiguration().getList("dataone.mnRead.serviceAvailable");
            if (mnReadServiceVersions != null && mnReadServiceAvailables != null && mnReadServiceVersions.size() == mnReadServiceAvailables.size()) {
                for (i = 0; i < mnReadServiceVersions.size(); ++i) {
                    version = (String)mnReadServiceVersions.get(i);
                    available = new Boolean((String)mnReadServiceAvailables.get(i));
                    Service sMNRead = new Service();
                    sMNRead.setName("MNRead");
                    sMNRead.setVersion(version);
                    sMNRead.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNRead);
                }
            }
            mnAuthorizationServiceVersions = Settings.getConfiguration().getList("dataone.mnAuthorization.serviceVersion");
            mnAuthorizationServiceAvailables = Settings.getConfiguration().getList("dataone.mnAuthorization.serviceAvailable");
            if (mnAuthorizationServiceVersions != null && mnAuthorizationServiceAvailables != null && mnAuthorizationServiceVersions.size() == mnAuthorizationServiceAvailables.size()) {
                for (i = 0; i < mnAuthorizationServiceVersions.size(); ++i) {
                    version = (String)mnAuthorizationServiceVersions.get(i);
                    available = new Boolean((String)mnAuthorizationServiceAvailables.get(i));
                    Service sMNAuthorization = new Service();
                    sMNAuthorization.setName("MNAuthorization");
                    sMNAuthorization.setVersion(version);
                    sMNAuthorization.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNAuthorization);
                }
            }
            mnStorageServiceVersions = Settings.getConfiguration().getList("dataone.mnStorage.serviceVersion");
            mnStorageServiceAvailables = Settings.getConfiguration().getList("dataone.mnStorage.serviceAvailable");
            if (mnStorageServiceVersions != null && mnStorageServiceAvailables != null && mnStorageServiceVersions.size() == mnStorageServiceAvailables.size()) {
                for (i = 0; i < mnStorageServiceVersions.size(); ++i) {
                    version = (String)mnStorageServiceVersions.get(i);
                    available = new Boolean((String)mnStorageServiceAvailables.get(i));
                    Service sMNStorage = new Service();
                    sMNStorage.setName("MNStorage");
                    sMNStorage.setVersion(version);
                    sMNStorage.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNStorage);
                }
            }
            mnReplicationServiceVersions = Settings.getConfiguration().getList("dataone.mnReplication.serviceVersion");
            mnReplicationServiceAvailables = Settings.getConfiguration().getList("dataone.mnReplication.serviceAvailable");
            if (mnReplicationServiceVersions != null && mnReplicationServiceAvailables != null && mnReplicationServiceVersions.size() == mnReplicationServiceAvailables.size()) {
                for (i = 0; i < mnReplicationServiceVersions.size(); ++i) {
                    version = (String)mnReplicationServiceVersions.get(i);
                    available = new Boolean((String)mnReplicationServiceAvailables.get(i));
                    Service sMNReplication = new Service();
                    sMNReplication.setName("MNReplication");
                    sMNReplication.setVersion(version);
                    sMNReplication.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNReplication);
                }
            }
            node.setServices(services);
            Synchronization synchronization = new Synchronization();
            Schedule schedule = new Schedule();
            Date now = new Date();
            schedule.setYear(PropertyService.getProperty("dataone.nodeSynchronization.schedule.year"));
            schedule.setMon(PropertyService.getProperty("dataone.nodeSynchronization.schedule.mon"));
            schedule.setMday(PropertyService.getProperty("dataone.nodeSynchronization.schedule.mday"));
            schedule.setWday(PropertyService.getProperty("dataone.nodeSynchronization.schedule.wday"));
            schedule.setHour(PropertyService.getProperty("dataone.nodeSynchronization.schedule.hour"));
            schedule.setMin(PropertyService.getProperty("dataone.nodeSynchronization.schedule.min"));
            schedule.setSec(PropertyService.getProperty("dataone.nodeSynchronization.schedule.sec"));
            synchronization.setSchedule(schedule);
            synchronization.setLastHarvested(now);
            synchronization.setLastCompleteHarvest(now);
            node.setSynchronization(synchronization);
            node.setType(nodeType);
            return node;
        }
        catch (PropertyNotFoundException pnfe) {
            String msg = "MNodeService.getCapabilities(): property not found: " + pnfe.getMessage();
            this.logMetacat.error((Object)msg);
            throw new ServiceFailure("2162", msg);
        }
    }

    public boolean synchronizationFailed(Session session, SynchronizationFailed syncFailed) throws NotImplemented, ServiceFailure, NotAuthorized {
        String localId;
        Identifier pid;
        block10: {
            if (syncFailed.getPid() != null) {
                pid = new Identifier();
                pid.setValue(syncFailed.getPid());
                try {
                    boolean allowed = this.isAdminAuthorized(session);
                    if (!allowed) {
                        throw new NotAuthorized("2162", "Not allowed to call synchronizationFailed() on this node.");
                    }
                    break block10;
                }
                catch (InvalidToken e) {
                    throw new NotAuthorized("2162", "Not allowed to call synchronizationFailed() on this node.");
                }
            }
            throw new ServiceFailure("2161", "The identifier cannot be null.");
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new ServiceFailure("2161", "The identifier specified by " + syncFailed.getPid() + " was not found on this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("2161", "Couldn't identify the local id of the identifier specified by " + syncFailed.getPid() + " since " + e.getMessage());
        }
        this.logMetacat.warn((Object)("Synchronization for the object identified by " + pid.getValue() + " failed from " + syncFailed.getNodeId() + " with message: " + syncFailed.getDescription() + ". Logging the event to the Metacat EventLog as a 'syncFailed' event."));
        String principal = "public";
        if (session != null && session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        try {
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "synchronization_failed");
        }
        catch (Exception e) {
            throw new ServiceFailure("2161", "Could not log the error for: " + pid.getValue());
        }
        return true;
    }

    public InputStream getReplica(Session session, Identifier pid) throws NotAuthorized, NotImplemented, ServiceFailure, InvalidToken, NotFound {
        String localId;
        this.logMetacat.info((Object)"MNodeService.getReplica() called.");
        if (session == null) {
            throw new InvalidToken("2183", "No session was provided.");
        }
        this.logMetacat.info((Object)("MNodeService.getReplica() called with parameters: \n\tSession.Subject      = " + session.getSubject().getValue() + "\n" + "\tIdentifier           = " + pid.getValue()));
        InputStream inputStream = null;
        this.handler = new MetacatHandler(new Timer());
        boolean allowed = false;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("2185", "The object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("2181", "The local id of the object specified by " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        Subject targetNodeSubject = session.getSubject();
        try {
            allowed = D1Client.getCN().isNodeAuthorized(null, targetNodeSubject, pid);
        }
        catch (InvalidToken e1) {
            throw new ServiceFailure("2181", "Could not determine if node is authorized: " + e1.getMessage());
        }
        catch (NotFound e1) {
            throw new NotFound("2185", "Could not find the object " + pid.getValue() + " in this node - " + e1.getMessage());
        }
        catch (InvalidRequest e1) {
            throw new ServiceFailure("2181", "Could not determine if node is authorized: " + e1.getMessage());
        }
        this.logMetacat.info((Object)("Called D1Client.isNodeAuthorized(). Allowed = " + allowed + " for identifier " + pid.getValue()));
        if (allowed) {
            try {
                inputStream = MetacatHandler.read(localId);
            }
            catch (Exception e) {
                throw new ServiceFailure("2181", "The object specified by " + pid.getValue() + "could not be returned due to error: " + e.getMessage());
            }
        } else {
            throw new NotAuthorized("2182", "The pid " + pid.getValue() + " is not authorized to be read by the client.");
        }
        if (inputStream == null) {
            throw new ServiceFailure("2181", "The object specified by " + pid.getValue() + " can't be returned from the node.");
        }
        String principal = null;
        if (session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "replicate");
        return inputStream;
    }

    public boolean systemMetadataChanged(Session session, Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken {
        boolean needCheckAuthoriativeNode = true;
        return this.systemMetadataChanged(needCheckAuthoriativeNode, session, pid, serialVersion, dateSysMetaLastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean systemMetadataChanged(boolean needCheckAuthoriativeNode, Session session, Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken {
        SystemMetadata newSysMeta;
        SystemMetadata currentLocalSysMeta;
        block40: {
            if (session == null) {
                throw new InvalidToken("1332", "No session was provided.");
            }
            String serviceFailureCode = "1333";
            Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
            if (sid != null) {
                pid = sid;
            }
            currentLocalSysMeta = null;
            newSysMeta = null;
            CNode cn = D1Client.getCN();
            NodeList nodeList = null;
            Subject callingSubject = null;
            boolean allowed = false;
            callingSubject = session.getSubject();
            nodeList = cn.listNodes();
            for (Node node : nodeList.getNodeList()) {
                List subjectList;
                if (!node.getType().equals((Object)NodeType.CN) || !(subjectList = node.getSubjectList()).contains(callingSubject)) continue;
                allowed = true;
            }
            if (!allowed) {
                String msg = "The subject identified by " + callingSubject.getValue() + " is not authorized to call this service.";
                throw new NotAuthorized("1331", msg);
            }
            try {
                Throwable sf;
                String msg;
                HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
                try {
                    currentLocalSysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                }
                catch (RuntimeException e) {
                    msg = "SystemMetadata for pid " + pid.getValue() + " couldn't be updated because it couldn't be found locally: " + e.getMessage();
                    this.logMetacat.error((Object)msg);
                    sf = new ServiceFailure("1333", msg);
                    sf.initCause((Throwable)e);
                    throw sf;
                }
                if (currentLocalSysMeta == null) {
                    throw new InvalidRequest("1334", "We can't find the system metadata in the node for the id " + pid.getValue());
                }
                if (currentLocalSysMeta.getSerialVersion().longValue() > serialVersion) break block40;
                try {
                    newSysMeta = cn.getSystemMetadata(null, pid);
                }
                catch (NotFound e) {
                    msg = "On updating the local copy of system metadata for pid " + pid.getValue() + ", the CN reports it is not found." + " The error message was: " + e.getMessage();
                    this.logMetacat.error((Object)msg);
                    sf = new InvalidRequest("1334", msg);
                    sf.initCause((Throwable)e);
                    throw sf;
                }
                Identifier newSID = newSysMeta.getSeriesId();
                if (newSID != null) {
                    if (!MNodeService.isValidIdentifier(newSID)) {
                        throw new InvalidRequest("1334", "The series identifier in the new system metadata is invalid.");
                    }
                    Identifier currentSID = currentLocalSysMeta.getSeriesId();
                    if (currentSID != null && currentSID.getValue() != null) {
                        if (!newSID.getValue().equals(currentSID.getValue())) {
                            try {
                                if (IdentifierManager.getInstance().identifierExists(newSID.getValue())) {
                                    throw new InvalidRequest("1334", "The series identifier " + newSID.getValue() + " in the new system metadata has been used by another object.");
                                }
                            }
                            catch (SQLException sql) {
                                throw new ServiceFailure("1333", "Couldn't determine if the SID " + newSID.getValue() + " in the system metadata exists in the node since " + sql.getMessage());
                            }
                        }
                    } else {
                        try {
                            if (IdentifierManager.getInstance().identifierExists(newSID.getValue())) {
                                throw new InvalidRequest("1334", "The series identifier " + newSID.getValue() + " in the new system metadata has been used by another object.");
                            }
                        }
                        catch (SQLException sql) {
                            throw new ServiceFailure("1333", "Couldn't determine if the SID " + newSID.getValue() + " in the system metadata exists in the node since " + sql.getMessage());
                        }
                    }
                }
                try {
                    if (needCheckAuthoriativeNode) {
                        if (this.isAuthoritativeNode(pid)) {
                            this.logMetacat.debug((Object)("MNodeService.systemMetadataChanged - this is the authoritative node for the pid " + pid.getValue()));
                            List replicas = newSysMeta.getReplicaList();
                            newSysMeta = currentLocalSysMeta;
                            newSysMeta.setSerialVersion(new BigInteger(new Long(serialVersion).toString()));
                            newSysMeta.setReplicaList(replicas);
                        } else {
                            this.logMetacat.debug((Object)("MNodeService.systemMetadataChanged - this is NOT the authoritative node for the pid " + pid.getValue()));
                            this.logMetacat.debug((Object)("MNodeService.systemMetadataChanged - the new value of archive is " + newSysMeta.getArchived() + " for the pid " + pid.getValue()));
                            this.logMetacat.debug((Object)("MNodeService.systemMetadataChanged - the local value of archive is " + currentLocalSysMeta.getArchived() + " for the pid " + pid.getValue()));
                            if (newSysMeta.getArchived() != null && newSysMeta.getArchived().booleanValue() && (currentLocalSysMeta.getArchived() != null && !currentLocalSysMeta.getArchived().booleanValue() || currentLocalSysMeta.getArchived() == null)) {
                                this.logMetacat.debug((Object)("MNodeService.systemMetadataChanged - start to archive object " + pid.getValue()));
                                boolean logArchive = false;
                                boolean needUpdateModificationDate = false;
                                try {
                                    this.archiveObject(logArchive, session, pid, newSysMeta, needUpdateModificationDate);
                                }
                                catch (NotFound e) {
                                    throw new InvalidRequest("1334", "Can't find the pid " + pid.getValue() + " for archive.");
                                }
                            } else if ((newSysMeta.getArchived() == null || !newSysMeta.getArchived().booleanValue()) && currentLocalSysMeta.getArchived() != null && currentLocalSysMeta.getArchived().booleanValue()) {
                                throw new InvalidRequest("1334", "The pid " + pid.getValue() + " has been archived and it can't be reset to false.");
                            }
                        }
                    }
                    HazelcastService.getInstance().getSystemMetadataMap().put((Object)newSysMeta.getIdentifier(), (Object)newSysMeta);
                    this.logMetacat.info((Object)("Updated local copy of system metadata for pid " + pid.getValue() + " after change notification from the CN."));
                }
                catch (RuntimeException e) {
                    String msg2 = "SystemMetadata for pid " + pid.getValue() + " couldn't be updated: " + e.getMessage();
                    this.logMetacat.error((Object)msg2);
                    ServiceFailure sf2 = new ServiceFailure("1333", msg2);
                    sf2.initCause((Throwable)e);
                    throw sf2;
                }
                try {
                    String localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                    EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), session.getSubject().getValue(), localId, "updateSystemMetadata");
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("MNodeService.systemMetadataChanged - Could not log 'updateSystemMetadata' event because no localId was found for pid: " + pid.getValue()));
                }
            }
            finally {
                HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
            }
        }
        if (currentLocalSysMeta.getSerialVersion().longValue() <= serialVersion) {
            try {
                DOIService.getInstance().registerDOI(newSysMeta);
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Could not [re]register DOI: " + e.getMessage()), (Throwable)e);
            }
            try {
                MetacatSolrIndex.getInstance().submit(newSysMeta.getIdentifier(), newSysMeta, null, true);
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("Could not submit changed systemMetadata for indexing, pid: " + newSysMeta.getIdentifier().getValue()), (Throwable)e);
            }
        }
        return true;
    }

    private void setReplicationStatus(Session session, Identifier pid, NodeReference nodeId, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, NotAuthorized, InvalidRequest {
        try {
            this.cn = D1Client.getCN();
            this.cn.setReplicationStatus(session, pid, nodeId, status, failure);
        }
        catch (InvalidToken e) {
            String msg = "Could not set the replication status for " + pid.getValue() + " on the CN (InvalidToken): " + e.getMessage();
            this.logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
        catch (NotFound e) {
            String msg = "Could not set the replication status for " + pid.getValue() + " on the CN (NotFound): " + e.getMessage();
            this.logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
    }

    private SystemMetadata makePublicIfNot(SystemMetadata sysmeta, Identifier pid) throws ServiceFailure, InvalidToken, NotFound, NotImplemented, InvalidRequest {
        boolean isPublic = false;
        Subject publicSubject = new Subject();
        publicSubject.setValue("public");
        Session publicSession = new Session();
        publicSession.setSubject(publicSubject);
        AccessRule publicRule = new AccessRule();
        publicRule.addPermission(Permission.READ);
        publicRule.addSubject(publicSubject);
        try {
            isPublic = this.isAuthorized(publicSession, pid, Permission.READ);
        }
        catch (NotAuthorized notAuthorized) {
            // empty catch block
        }
        if (!isPublic) {
            sysmeta.getAccessPolicy().addAllow(publicRule);
        }
        return sysmeta;
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        if (session == null) {
            throw new InvalidToken("2190", "Session is required to generate an Identifier at this Node.");
        }
        Identifier identifier = new Identifier();
        if (scheme.equalsIgnoreCase(UUID_SCHEME)) {
            UUID uuid = UUID.randomUUID();
            identifier.setValue(UUID_PREFIX + uuid.toString());
        } else if (scheme.equalsIgnoreCase(DOI_SCHEME)) {
            try {
                identifier = DOIService.getInstance().generateDOI();
            }
            catch (EZIDException e) {
                ServiceFailure sf = new ServiceFailure("2191", "Could not generate DOI: " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        } else if (fragment != null) {
            String autogenId = DocumentUtil.generateDocumentId(fragment, 0);
            identifier.setValue(autogenId);
        } else {
            String autogenId = DocumentUtil.generateDocumentId(0);
            identifier.setValue(autogenId);
        }
        return identifier;
    }

    public QueryEngineDescription getQueryEngineDescription(Session session, String engine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        if (engine != null && engine.equals("pathquery")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            QueryEngineDescription qed = new QueryEngineDescription();
            qed.setName("pathquery");
            qed.setQueryEngineVersion("1.0");
            qed.addAdditionalInfo("This is the traditional structured query for Metacat");
            Vector<String> pathsForIndexing = null;
            try {
                pathsForIndexing = SystemUtil.getPathsForIndexing();
            }
            catch (MetacatUtilException e) {
                this.logMetacat.warn((Object)"Could not get index paths", (Throwable)e);
            }
            for (String fieldName : pathsForIndexing) {
                QueryField field = new QueryField();
                field.addDescription("Indexed field for path '" + fieldName + "'");
                field.setName(fieldName);
                field.setReturnable(true);
                field.setSearchable(true);
                field.setSortable(false);
                field.setType(String.class.getName());
                qed.addQueryField(field);
            }
            return qed;
        }
        if (engine != null && engine.equals("solr")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("solr")) {
                throw new NotImplemented("0000", "MNodeService.getQueryEngineDescription - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            try {
                QueryEngineDescription qed = MetacatSolrEngineDescriptionHandler.getInstance().getQueryEngineDescritpion();
                return qed;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("Solr server error", e.getMessage());
            }
        }
        throw new NotFound("404", "The Metacat member node can't find the query engine - " + engine);
    }

    public QueryEngineList listQueryEngines(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        QueryEngineList qel = new QueryEngineList();
        List enables = EnabledQueryEngines.getInstance().getEnabled();
        for (String name : enables) {
            qel.addQueryEngine(name);
        }
        return qel;
    }

    public InputStream query(Session session, String engine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        String user = "public";
        String[] groups = null;
        HashSet<Subject> subjects = null;
        if (session != null) {
            user = session.getSubject().getValue();
            subjects = AuthUtils.authorizedClientSubjects((Session)session);
            if (subjects != null) {
                ArrayList<String> groupList = new ArrayList<String>();
                for (Subject subject : subjects) {
                    groupList.add(subject.getValue());
                }
                groups = groupList.toArray(new String[0]);
            }
        } else {
            Subject subject = new Subject();
            subject.setValue("public");
            subjects = new HashSet<Subject>();
            subjects.add(subject);
        }
        if (engine != null && engine.equals("pathquery")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            try {
                DBQuery queryobj = new DBQuery();
                String results = queryobj.performPathquery(query, user, groups);
                ContentTypeByteArrayInputStream ctbais = new ContentTypeByteArrayInputStream(results.getBytes("UTF-8"));
                ctbais.setContentType("text/xml");
                return ctbais;
            }
            catch (Exception e) {
                throw new ServiceFailure("Pathquery error", e.getMessage());
            }
        }
        if (engine != null && engine.equals("solr")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("solr")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            this.logMetacat.info((Object)("The query is ==================================== \n" + query));
            try {
                return MetacatSolrIndex.getInstance().query(query, subjects);
            }
            catch (Exception e) {
                throw new ServiceFailure("Solr server error", e.getMessage());
            }
        }
        return null;
    }

    public Identifier publish(Session session, Identifier originalIdentifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, IOException {
        Identifier newIdentifier;
        block27: {
            String serviceFailureCode = "1030";
            Identifier sid = this.getPIDForSID(originalIdentifier, serviceFailureCode);
            if (sid != null) {
                originalIdentifier = sid;
            }
            SystemMetadata originalSystemMetadata = this.getSystemMetadata(session, originalIdentifier);
            SystemMetadata sysmeta = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                TypeMarshaller.marshalTypeToOutputStream((Object)originalSystemMetadata, (OutputStream)baos);
                sysmeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            newIdentifier = this.generateIdentifier(session, DOI_SCHEME, null);
            sysmeta.setIdentifier(newIdentifier);
            sysmeta.setObsoletes(originalIdentifier);
            sysmeta.setObsoletedBy(null);
            sysmeta = this.makePublicIfNot(sysmeta, originalIdentifier);
            InputStream inputStream = null;
            boolean isScienceMetadata = MNodeService.isScienceMetadata(sysmeta);
            if (isScienceMetadata) {
                InputStream originalObject = this.get(session, originalIdentifier);
                inputStream = this.editScienceMetadata(session, originalObject, originalIdentifier, newIdentifier);
            } else {
                inputStream = this.get(session, originalIdentifier);
            }
            this.update(session, originalIdentifier, inputStream, newIdentifier, sysmeta);
            try {
                InputStream oreInputStream;
                Identifier potentialOreIdentifier;
                block26: {
                    String localId = IdentifierManager.getInstance().getLocalId(originalIdentifier.getValue());
                    potentialOreIdentifier = new Identifier();
                    potentialOreIdentifier.setValue("resourceMap_" + localId);
                    oreInputStream = null;
                    try {
                        oreInputStream = this.get(session, potentialOreIdentifier);
                    }
                    catch (NotFound nf) {
                        this.logMetacat.warn((Object)("No potential ORE map found for: " + potentialOreIdentifier.getValue()));
                        List<Identifier> potentialOreIdentifiers = this.lookupOreFor(originalIdentifier, false);
                        if (potentialOreIdentifiers == null) break block26;
                        potentialOreIdentifier = potentialOreIdentifiers.get(0);
                        try {
                            oreInputStream = this.get(session, potentialOreIdentifier);
                        }
                        catch (NotFound nf2) {
                            this.logMetacat.warn((Object)("No potential ORE map found for: " + potentialOreIdentifier.getValue()));
                        }
                    }
                }
                if (oreInputStream != null) {
                    Identifier newOreIdentifier = MNodeService.getInstance(this.request).generateIdentifier(session, UUID_SCHEME, null);
                    Map resourceMapStructure = ResourceMapFactory.getInstance().parseResourceMap(oreInputStream);
                    Map sciMetaMap = (Map)resourceMapStructure.get(potentialOreIdentifier);
                    List dataIdentifiers = (List)sciMetaMap.get(originalIdentifier);
                    sciMetaMap.remove(originalIdentifier);
                    sciMetaMap.put(newIdentifier, dataIdentifiers);
                    ResourceMap resourceMap = ResourceMapFactory.getInstance().createResourceMap(newOreIdentifier, sciMetaMap);
                    String resourceMapString = ResourceMapFactory.getInstance().serializeResourceMap(resourceMap);
                    SystemMetadata originalOreSysMeta = this.getSystemMetadata(session, potentialOreIdentifier);
                    SystemMetadata oreSysMeta = new SystemMetadata();
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        TypeMarshaller.marshalTypeToOutputStream((Object)originalOreSysMeta, (OutputStream)baos);
                        oreSysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (Exception e) {
                        ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                        sf.initCause((Throwable)e);
                        throw sf;
                    }
                    oreSysMeta.setIdentifier(newOreIdentifier);
                    oreSysMeta.setObsoletes(potentialOreIdentifier);
                    oreSysMeta.setObsoletedBy(null);
                    oreSysMeta.setSize(BigInteger.valueOf(resourceMapString.getBytes("UTF-8").length));
                    oreSysMeta.setChecksum(ChecksumUtil.checksum((byte[])resourceMapString.getBytes("UTF-8"), (String)oreSysMeta.getChecksum().getAlgorithm()));
                    oreSysMeta = this.makePublicIfNot(oreSysMeta, potentialOreIdentifier);
                    ArrayList<String> pidsToSync = new ArrayList<String>();
                    for (Identifier dataId : dataIdentifiers) {
                        SystemMetadata dataSysMeta = this.getSystemMetadata(session, dataId);
                        dataSysMeta = this.makePublicIfNot(dataSysMeta, dataId);
                        this.updateSystemMetadata(dataSysMeta);
                        pidsToSync.add(dataId.getValue());
                    }
                    SyncAccessPolicy sap = new SyncAccessPolicy();
                    try {
                        sap.sync(pidsToSync);
                    }
                    catch (Exception e) {
                        this.logMetacat.warn((Object)"Error attempting to sync access for data objects when publishing package");
                    }
                    this.update(session, potentialOreIdentifier, new ByteArrayInputStream(resourceMapString.getBytes("UTF-8")), newOreIdentifier, oreSysMeta);
                    break block27;
                }
                try {
                    String newLocalId = IdentifierManager.getInstance().getLocalId(newIdentifier.getValue());
                    SystemMetadata systemMetadata = SystemMetadataFactory.createSystemMetadata(newLocalId, true, false);
                }
                catch (Exception e) {
                    this.logMetacat.error((Object)("Could not generate new ORE for published object: " + newIdentifier.getValue()), (Throwable)e);
                }
            }
            catch (McdbDocNotFoundException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (UnsupportedEncodingException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (OREException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (URISyntaxException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (OREParserException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (ORESerialiserException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (NoSuchAlgorithmException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (SQLException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        return newIdentifier;
    }

    public InputStream editScienceMetadata(Session session, InputStream object, Identifier pid, Identifier newPid) throws ServiceFailure, IOException, UnsupportedEncodingException, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        this.logMetacat.debug((Object)"D1NodeService.editScienceMetadata() called.");
        ByteArrayInputStream newObject = null;
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)object);
            String xmlStr = new String(xmlBytes, "UTF-8");
            Document doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)new StringReader(xmlStr));
            Element docNode = doc.getDocumentElement();
            SystemMetadata sysMeta = null;
            try {
                sysMeta = this.getSystemMetadata(session, pid);
            }
            catch (NotAuthorized e) {
                throw new ServiceFailure("1030", "D1NodeService.editScienceMetadata(): This session is not authorized to access the system metadata for " + pid.getValue() + " : " + e.getMessage());
            }
            catch (NotFound e) {
                throw new ServiceFailure("1030", "D1NodeService.editScienceMetadata(): Could not find the system metadata for " + pid.getValue() + " : " + e.getMessage());
            }
            ObjectFormatIdentifier objFormatId = sysMeta.getFormatId();
            String formatId = objFormatId.getValue();
            if (formatId.indexOf("eml") == 0) {
                XMLUtilities.addAttributeNodeToDOMTree((org.w3c.dom.Node)docNode, (String)XPATH_EML_ID, (String)newPid.getValue());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(docNode);
            StreamResult outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
            newObject = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerException e) {
            throw new ServiceFailure("1030", "MNNodeService.editScienceMetadata(): Could not update the ID in the XML document for pid " + pid.getValue() + " : " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("1030", "MNNodeService.editScienceMetadata(): Could not update the ID in the XML document for pid " + pid.getValue() + " : " + e.getMessage());
        }
        return newObject;
    }

    public List<Identifier> lookupOreFor(Identifier guid, boolean includeObsolete) {
        String pid = guid.getValue();
        ArrayList<Identifier> retList = null;
        try {
            InputStream results;
            org.w3c.dom.Node rootNode;
            org.w3c.dom.NodeList nodeList;
            String query = "fl=id,resourceMap&wt=xml&q=-obsoletedBy:[* TO *]+resourceMap:[* TO *]+id:\"" + pid + "\"";
            if (includeObsolete) {
                query = "fl=id,resourceMap&wt=xml&q=resourceMap:[* TO *]+id:\"" + pid + "\"";
            }
            if ((nodeList = XMLUtilities.getNodeListWithXPath((org.w3c.dom.Node)(rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new InputStreamReader(results = this.query(null, "solr", query), "UTF-8"))), (String)"//arr[@name=\"resourceMap\"]/str")) != null && nodeList.getLength() > 0) {
                retList = new ArrayList<Identifier>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String found = nodeList.item(i).getFirstChild().getNodeValue();
                    Identifier oreId = new Identifier();
                    oreId.setValue(found);
                    retList.add(oreId);
                }
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Error checking for resourceMap[s] on pid " + pid + ". " + e.getMessage()), (Throwable)e);
        }
        return retList;
    }

    public InputStream getPackage(Session session, ObjectFormatIdentifier formatId, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        if (formatId == null) {
            throw new InvalidRequest("2873", "The format type can't be null in the getpackage method.");
        }
        if (!formatId.getValue().equals("application/bagit-097")) {
            throw new NotImplemented("", "The format " + formatId.getValue() + " is not supported in the getpackage method");
        }
        String serviceFailureCode = "2871";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        DeleteOnCloseFileInputStream bagInputStream = null;
        BagFactory bagFactory = new BagFactory();
        Bag bag = bagFactory.createBag();
        ArrayList<File> tempFiles = new ArrayList<File>();
        ArrayList<Object> packagePids = new ArrayList<Object>();
        try {
            HashMap<Identifier, String> fileNames = new HashMap<Identifier, String>();
            StringBuffer pidMapping = new StringBuffer();
            SystemMetadata sysMeta = this.getSystemMetadata(session, pid);
            if (ObjectFormatCache.getInstance().getFormat(sysMeta.getFormatId()).getFormatType().equals("RESOURCE")) {
                InputStream oreInputStream = this.get(session, pid);
                Map resourceMapStructure = ResourceMapFactory.getInstance().parseResourceMap(oreInputStream);
                packagePids.addAll(resourceMapStructure.keySet());
                for (Map map : resourceMapStructure.values()) {
                    Set metadataIdentifiers = map.keySet();
                    for (Identifier metadataID : metadataIdentifiers) {
                        try {
                            Entity[] entities;
                            SystemMetadata metadataSysMeta = this.getSystemMetadata(session, metadataID);
                            if (ObjectFormatCache.getInstance().getFormat(metadataSysMeta.getFormatId()).getFormatType().equals("METADATA")) {
                                InputStream metadataStream = this.get(session, metadataID);
                                try {
                                    String format = "default";
                                    DBTransform transformer = new DBTransform();
                                    String documentContent = IOUtils.toString((InputStream)metadataStream, (String)"UTF-8");
                                    String sourceType = metadataSysMeta.getFormatId().getValue();
                                    String targetType = "-//W3C//HTML//EN";
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                                    Hashtable<String, String[]> params = new Hashtable<String, String[]>();
                                    String localId = null;
                                    try {
                                        localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                                    }
                                    catch (McdbDocNotFoundException e) {
                                        throw new NotFound("1020", e.getMessage());
                                    }
                                    params.put("qformat", new String[]{format});
                                    params.put("docid", new String[]{localId});
                                    params.put("pid", new String[]{pid.getValue()});
                                    params.put("displaymodule", new String[]{"printall"});
                                    transformer.transformXMLDocument(documentContent, sourceType, targetType, format, writer, params, null);
                                    ContentTypeByteArrayInputStream resultInputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
                                    File tmpDir = File.createTempFile("package_", "_dir");
                                    tmpDir.delete();
                                    tmpDir.mkdir();
                                    File htmlFile = File.createTempFile("metadata", ".html", tmpDir);
                                    File cssDir = new File(tmpDir, format);
                                    cssDir.mkdir();
                                    File cssFile = new File(tmpDir, format + "/" + format + ".css");
                                    String pdfFileName = metadataID.getValue().replaceAll("[^a-zA-Z0-9\\-\\.]", "_") + "-METADATA.pdf";
                                    File pdfFile = new File(tmpDir, pdfFileName);
                                    String originalCssPath = SystemUtil.getContextDir() + "/style/skins/" + format + "/" + format + ".css";
                                    IOUtils.copy((InputStream)new FileInputStream(originalCssPath), (OutputStream)new FileOutputStream(cssFile));
                                    IOUtils.copy((InputStream)resultInputStream, (OutputStream)new FileOutputStream(htmlFile));
                                    HtmlToPdf.export((String)htmlFile.getAbsolutePath(), (String)pdfFile.getAbsolutePath());
                                    bag.addFileToPayload(pdfFile);
                                    pidMapping.append(metadataID.getValue() + " (pdf)" + "\t" + "data/" + pdfFile.getName() + "\n");
                                    htmlFile.delete();
                                    cssFile.delete();
                                    cssDir.delete();
                                    tempFiles.add(tmpDir);
                                    tempFiles.add(pdfFile);
                                }
                                catch (Exception e) {
                                    this.logMetacat.warn((Object)"Could not transform metadata", (Throwable)e);
                                }
                            }
                            if (!metadataSysMeta.getFormatId().getValue().startsWith("eml://")) continue;
                            Eml200DataPackageParser parser = new Eml200DataPackageParser();
                            InputStream emlStream = this.get(session, metadataID);
                            parser.parse(emlStream);
                            DataPackage dataPackage = parser.getDataPackage();
                            for (Entity entity : entities = dataPackage.getEntityList()) {
                                try {
                                    String fileNameFromMetadata = entity.getName();
                                    String ecogridIdentifier = entity.getEntityIdentifier();
                                    String idFromMetadata = DocumentUtil.getAccessionNumberFromEcogridIdentifier(ecogridIdentifier);
                                    String docid = DocumentUtil.getDocIdFromString(idFromMetadata);
                                    String rev = DocumentUtil.getRevisionStringFromString(idFromMetadata);
                                    String guid = IdentifierManager.getInstance().getGUID(docid, Integer.valueOf(rev));
                                    Identifier dataIdentifier = new Identifier();
                                    dataIdentifier.setValue(guid);
                                    fileNames.put(dataIdentifier, fileNameFromMetadata);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.logMetacat.debug((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logMetacat.debug((Object)e.toString());
                        }
                    }
                    packagePids.addAll(map.keySet());
                    for (List dataPids : map.values()) {
                        packagePids.addAll(dataPids);
                    }
                }
            } else {
                packagePids.add(pid);
            }
            File tempDir = File.createTempFile("temp", Long.toString(System.nanoTime()));
            tempDir.delete();
            tempDir = new File(tempDir.getPath() + "_dir");
            tempDir.mkdir();
            tempFiles.add(tempDir);
            File pidMappingFile = new File(tempDir, "pid-mapping.txt");
            for (Identifier identifier : packagePids) {
                SystemMetadata entrySysMeta = this.getSystemMetadata(session, identifier);
                String objectFormatType = ObjectFormatCache.getInstance().getFormat(entrySysMeta.getFormatId()).getFormatType();
                String fileName = null;
                fileName = identifier.getValue().replaceAll("[^a-zA-Z0-9\\-\\.]", "_") + "-" + objectFormatType;
                if (fileNames.containsKey(identifier)) {
                    fileName = identifier.getValue().replaceAll("[^a-zA-Z0-9\\-\\.]", "_") + "-" + ((String)fileNames.get(identifier)).replaceAll("[^a-zA-Z0-9\\-\\.]", "_");
                } else {
                    String extension = ObjectFormatInfo.instance().getExtension(entrySysMeta.getFormatId().getValue());
                    fileName = fileName + extension;
                }
                File tempFile = new File(tempDir, fileName);
                tempFiles.add(tempFile);
                InputStream entryInputStream = this.get(session, identifier);
                IOUtils.copy((InputStream)entryInputStream, (OutputStream)new FileOutputStream(tempFile));
                bag.addFileToPayload(tempFile);
                pidMapping.append(identifier.getValue() + "\t" + "data/" + tempFile.getName() + "\n");
            }
            IOUtils.write((String)pidMapping.toString(), (OutputStream)new FileOutputStream(pidMappingFile));
            bag.addFileAsTag(pidMappingFile);
            tempFiles.add(pidMappingFile);
            bag = bag.makeComplete();
            String zipName = pid.getValue().replaceAll("\\W", "_");
            File file = new File(tempDir, zipName + ".zip");
            bag.setFile(file);
            ZipWriter zipWriter = new ZipWriter(bagFactory);
            bag.write((Writer)zipWriter, file);
            File file2 = bag.getFile();
            bagInputStream = new DeleteOnCloseFileInputStream(file2);
            file2.deleteOnExit();
            tempFiles.add(file2);
            for (int i = tempFiles.size() - 1; i >= 0; --i) {
                ((File)tempFiles.get(i)).delete();
            }
        }
        catch (IOException e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (OREException e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (URISyntaxException e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (OREParserException e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return bagInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        boolean allowed = false;
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        String serviceFailureCode = "1350";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        try {
            allowed = this.isAuthorized(session, pid, Permission.CHANGE_PERMISSION);
        }
        catch (InvalidRequest e) {
            throw new ServiceFailure("1350", e.getDescription());
        }
        if (allowed) {
            try {
                HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
                this.logMetacat.debug((Object)("MNodeService.archive - lock the identifier " + pid.getValue() + " in the system metadata map."));
                SystemMetadata sysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                boolean needModifyDate = true;
                boolean logArchive = true;
                super.archiveObject(logArchive, session, pid, sysmeta, needModifyDate);
            }
            finally {
                HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
                this.logMetacat.debug((Object)("MNodeService.archive - unlock the identifier " + pid.getValue() + " in the system metadata map."));
            }
        } else {
            throw new NotAuthorized("1320", "The provided identity does not have permission to archive the object on the Node.");
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        if (sysmeta == null) {
            throw new InvalidRequest("4863", "The system metadata object should NOT be null in the updateSystemMetadata request.");
        }
        if (pid == null || pid.getValue() == null) {
            throw new InvalidRequest("4863", "Please specify the id in the updateSystemMetadata request ");
        }
        if (session == null) {
            throw new NotAuthorized("4861", "No Session - could not authorize for updating system metadata.  If you are not logged in, please do so and retry the request.");
        }
        try {
            if (!this.allowUpdating(session, pid, Permission.CHANGE_PERMISSION)) {
                throw new NotAuthorized("4861", "The client -" + session.getSubject().getValue() + "is not authorized for updating the system metadata of the object " + pid.getValue());
            }
        }
        catch (NotFound e) {
            throw new InvalidRequest("4863", "Can't determine if the client has the permission to update the system metacat of the object with id " + pid.getValue() + " since " + e.getDescription());
        }
        boolean success = false;
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
            SystemMetadata currentSysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            if (currentSysmeta == null) {
                throw new InvalidRequest("4863", "We can't find the current system metadata on the member node for the id " + pid.getValue());
            }
            Date currentModiDate = currentSysmeta.getDateSysMetadataModified();
            Date commingModiDate = sysmeta.getDateSysMetadataModified();
            if (commingModiDate == null) {
                throw new InvalidRequest("4863", "The system metadata modification date can't be null.");
            }
            if (currentModiDate != null && commingModiDate.getTime() != currentModiDate.getTime()) {
                throw new InvalidRequest("4863", "Your system metadata modification date is " + commingModiDate.toString() + ". It doesn't match our current system metadata modification date in the member node - " + currentModiDate.toString() + ". Please check if you have got the newest version of the system metadata before the modification.");
            }
            boolean needUpdateModificationDate = true;
            boolean fromCN = false;
            success = this.updateSystemMetadata(session, pid, sysmeta, needUpdateModificationDate, currentSysmeta, fromCN);
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
        }
        if (success) {
            this.cn = D1Client.getCN();
            try {
                if (this.cn == null) {
                    this.logMetacat.warn((Object)"updateSystemMetadata - can't get the instance of the CN. So the system metadata in CN can't be updated.");
                } else {
                    this.cn.synchronize(null, pid);
                }
            }
            catch (BaseException e) {
                e.printStackTrace();
                this.logMetacat.error((Object)("It is a DataONEBaseException and its detail code is " + e.getDetail_code() + " and its code is " + e.getCode()));
                this.logMetacat.error((Object)("Can't update the systemmetadata of pid " + pid.getValue() + " in CNs since " + e.getMessage()));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logMetacat.error((Object)("Can't update the systemmetadata of pid " + pid.getValue() + " in CNs since " + e.getMessage()));
            }
            try {
                DOIService.getInstance().registerDOI(sysmeta);
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)("Could not [re]register DOI: " + e.getMessage()), (Throwable)e);
            }
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAuthoritativeNode(Identifier pid) throws InvalidRequest {
        boolean isAuthoritativeNode = false;
        if (pid == null) throw new InvalidRequest("4869", "The request pid is null");
        if (pid.getValue() == null) throw new InvalidRequest("4869", "The request pid is null");
        SystemMetadata sys = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
        if (sys == null) throw new InvalidRequest("4869", "Coudn't find the system metadata associated with the pid " + pid.getValue());
        NodeReference node = sys.getAuthoritativeMemberNode();
        if (node == null) throw new InvalidRequest("4869", "Coudn't find the authoritative member node in the system metadata associated with the pid " + pid.getValue());
        String nodeValue = node.getValue();
        this.logMetacat.debug((Object)("The authoritative node for id " + pid.getValue() + " is " + nodeValue));
        String currentNodeId = Settings.getConfiguration().getString("dataone.nodeId");
        this.logMetacat.debug((Object)("The node id in metacat.properties is " + currentNodeId));
        if (currentNodeId == null) return isAuthoritativeNode;
        if (currentNodeId.trim().equals("")) return isAuthoritativeNode;
        if (!currentNodeId.equals(nodeValue)) return isAuthoritativeNode;
        this.logMetacat.debug((Object)"They are matching");
        return true;
    }

    private boolean allowUpdating(Session session, Identifier pid, Permission permission) throws NotAuthorized, NotFound, InvalidRequest {
        boolean allow = false;
        if (this.isCNAdmin(session)) {
            allow = true;
        } else if (this.isAuthoritativeNode(pid)) {
            allow = MNodeService.userHasPermission(session, pid, permission);
        } else {
            throw new NotAuthorized("4861", "Client can only call the request on the authoritative memember node.");
        }
        return allow;
    }
}

