/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;

public class GeoserverUtil {
    private static Logger logMetacat = Logger.getLogger(GeoserverUtil.class);

    private GeoserverUtil() {
    }

    public static void changePassword(String username, String password) throws MetacatUtilException {
        try {
            String usersFile = PropertyService.getProperty("geoserver.GEOSERVER_DATA_DIR") + FileUtil.getFS() + "security" + FileUtil.getFS() + "users.properties";
            SortedProperties userProperties = new SortedProperties(usersFile);
            userProperties.load();
            String value = password + ",ROLE_ADMINISTRATOR,enabled";
            userProperties.setProperty(username, value);
        }
        catch (Exception e) {
            throw new MetacatUtilException("Property error while changing default password: " + e.getMessage());
        }
    }

    public static boolean isGeoserverConfigured() throws MetacatUtilException {
        String geoserverConfiguredString = "false";
        try {
            geoserverConfiguredString = PropertyService.getProperty("configutil.geoserverConfigured");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if geoservice are configured: " + pnfe.getMessage());
        }
        return !geoserverConfiguredString.equals("false");
    }

    public static void writeConfig() throws MetacatUtilException {
        try {
            String configFileTemplate = SystemUtil.getContextDir() + FileUtil.getFS() + "web.xml.geoserver";
            String configFileDestination = PropertyService.getProperty("application.deployDir") + FileUtil.getFS() + PropertyService.getProperty("geoserver.context") + FileUtil.getFS() + "WEB-INF" + FileUtil.getFS() + "web.xml";
            String dataDir = PropertyService.getProperty("geoserver.GEOSERVER_DATA_DIR");
            String configContents = FileUtil.readFileToString((String)configFileTemplate, (String)"UTF-8");
            configContents = configContents.replace("_GEOSERVER_DATA_DIR_VALUE_", dataDir);
            FileUtil.writeFile((String)configFileDestination, (Reader)new StringReader(configContents), (String)"UTF-8");
        }
        catch (Exception pnfe) {
            throw new MetacatUtilException("Property error while setting geoserver configuration. Please verify geoserver installation. " + pnfe.getMessage());
        }
    }

    public static String getGeoserverContextURL() throws PropertyNotFoundException {
        return SystemUtil.getServerURL() + "/" + PropertyService.getProperty("geoserver.context");
    }
}

