/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTextNote
implements Component {
    private final ComponentType type;
    private final List<? extends CharSequence> stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextNote(ComponentType componentType, List<? extends CharSequence> list, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = list;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Dimension2D dimension2D, Context2D context2D) {
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth() - 1;
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.fillRect(' ', 2, 1, n - 3, n2 - 2);
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawNoteSimpleUnicode(2, 0, n - 2, n2);
        } else {
            umlCharArea.drawNoteSimple(2, 0, n - 2, n2);
        }
        umlCharArea.drawStringsLR(this.stringsToDisplay, 3, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 7;
    }
}

