/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.dot.BorderMode;
import net.sourceforge.plantuml.cucadiagram.dot.DotCommon;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilder;

class LabelBuilderHtmlHeaderTableForObjectOrClass
extends DotCommon
implements LabelBuilder {
    private final IEntity entity;
    private final String circleAbsolutePath;
    private final int spring;
    private final BorderMode borderMode;
    private final boolean classes;

    LabelBuilderHtmlHeaderTableForObjectOrClass(FileFormat fileFormat, DotData dotData, IEntity iEntity, String string, int n, boolean bl, BorderMode borderMode) {
        super(fileFormat, dotData);
        this.entity = iEntity;
        this.circleAbsolutePath = string;
        this.classes = bl;
        this.borderMode = borderMode;
        this.spring = n;
    }

    public void appendLabel(StringBuilder stringBuilder) throws IOException {
        int n;
        if (this.spring == 0) {
            this.htmlHeaderTableForObjectOrClassOrInterfaceOrEnumNoSpring(stringBuilder, 0);
            return;
        }
        if (this.borderMode == BorderMode.NO_BORDER) {
            stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        } else if (this.borderMode == BorderMode.NO_BORDER_CELLSPACING) {
            stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\">");
        } else if (this.borderMode == BorderMode.BORDER_1_WITHOUT_COLOR) {
            stringBuilder.append("<TABLE BORDER=\"1\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\" ");
            stringBuilder.append(">");
        } else if (this.borderMode == BorderMode.BORDER_1_WITH_COLOR) {
            String string = this.entity.getStereotype() == null ? null : this.entity.getStereotype().getLabel();
            stringBuilder.append("<TABLE BORDER=\"1\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\" ");
            stringBuilder.append("COLOR=" + this.getColorString(ColorParam.classBorder, string) + " BGCOLOR=" + this.getColorString(ColorParam.classBackground, string));
            stringBuilder.append(">");
        } else {
            throw new IllegalStateException();
        }
        stringBuilder.append("<TR>");
        for (n = 0; n < this.spring; ++n) {
            stringBuilder.append("<TD></TD>");
        }
        if (this.circleAbsolutePath != null) {
            this.appendImageAsTD(stringBuilder, this.circleAbsolutePath);
        }
        stringBuilder.append("<TD>");
        this.appendLabelAndStereotype(this.entity, stringBuilder, this.classes);
        stringBuilder.append("</TD>");
        for (n = 0; n < this.spring; ++n) {
            stringBuilder.append("<TD></TD>");
        }
        stringBuilder.append("</TR></TABLE>");
    }

    private void htmlHeaderTableForObjectOrClassOrInterfaceOrEnumNoSpring(StringBuilder stringBuilder, int n) throws IOException {
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"" + n + "\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        if (this.circleAbsolutePath == null) {
            stringBuilder.append("<TD>");
        } else {
            if (this.getData().getDpi() == 96) {
                stringBuilder.append("<TD ALIGN=\"RIGHT\">");
                stringBuilder.append("<IMG SRC=\"" + this.circleAbsolutePath + "\"/></TD>");
            } else {
                this.addTdImageBugB1983(stringBuilder, this.circleAbsolutePath);
            }
            stringBuilder.append("<TD ALIGN=\"LEFT\">");
        }
        this.appendLabelAndStereotype(this.entity, stringBuilder, this.classes);
        stringBuilder.append("</TD></TR></TABLE>");
    }
}

