/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemVersion
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();
    private final BufferedImage image;

    PSystemVersion(boolean bl, List<String> list) throws IOException {
        this.strings.addAll(list);
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("logo.png");
            this.image = ImageIO.read(inputStream);
            inputStream.close();
        } else {
            this.image = null;
        }
    }

    @Override
    public void exportDiagram(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption) throws IOException {
        this.getGraphicStrings().writeImage(outputStream, fileFormatOption);
    }

    public static PSystemVersion createShowVersion() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.version() + "</b> (" + new Date(Version.compileTime()) + ")");
        arrayList.add(" ");
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        arrayList.add(" ");
        Properties properties = System.getProperties();
        arrayList.add(properties.getProperty("java.runtime.name"));
        arrayList.add(properties.getProperty("java.vm.name"));
        arrayList.add(properties.getProperty("java.runtime.version"));
        arrayList.add(properties.getProperty("os.name"));
        arrayList.add("Processors: " + Runtime.getRuntime().availableProcessors());
        return new PSystemVersion(true, arrayList);
    }

    public static PSystemVersion createShowAuthors() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>PlantUML version " + Version.version() + "</b> (" + new Date(Version.compileTime()) + ")");
        arrayList.add(" ");
        arrayList.add("<u>Original idea</u>: Arnaud Roques");
        arrayList.add("<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier");
        arrayList.add("<u>Eclipse Plugin</u>: Claude Durif & Anne Pecoil");
        arrayList.add("<u>Site design</u>: Raphael Cotisson");
        arrayList.add("<u>Logo</u>: Benjamin Croizet");
        arrayList.add(" ");
        arrayList.add("http://plantuml.sourceforge.net");
        arrayList.add(" ");
        return new PSystemVersion(true, arrayList);
    }

    public static PSystemVersion createTestDot() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(GraphvizUtils.getTestDotStrings(true));
        return new PSystemVersion(false, arrayList);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        return new GraphicStrings(this.strings, uFont, HtmlColor.BLACK, HtmlColor.WHITE, this.image, GraphicPosition.BACKGROUND_CORNER, false);
    }

    @Override
    public String getDescription() {
        return "(Version)";
    }
}

