/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram2.ConditionalContext2;
import net.sourceforge.plantuml.activitydiagram2.PendingLink;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagram2
extends CucaDiagram {
    private Collection<IEntity> waitings = new LinkedHashSet<IEntity>();
    private ConditionalContext2 currentContext;
    private String futureLabel = null;
    private final Collection<String> pendingLabels = new HashSet<String>();
    private final Map<String, IEntity> labels = new HashMap<String, IEntity>();
    private final Map<String, IEntity> bars = new HashMap<String, IEntity>();
    private final Collection<PendingLink> pendingLinks = new ArrayList<PendingLink>();

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public String getDescription() {
        return "(" + this.entities().size() + " activities)";
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    public boolean isReachable() {
        return this.waitings.size() > 0;
    }

    public void newActivity(String string, Direction direction) {
        if (this.waitings.size() == 0) {
            throw new IllegalStateException();
        }
        Entity entity = this.createEntity(this.getAutoCode(), string, EntityType.ACTIVITY);
        this.afterAdd(entity, direction);
    }

    public void bar(String string) {
        Direction direction = Direction.DOWN;
        if (this.bars.containsKey(string)) {
            IEntity iEntity = this.bars.get(string);
            Iterator<IEntity> iterator = this.waitings.iterator();
            while (iterator.hasNext()) {
                IEntity iEntity2 = iterator.next();
                if (iEntity2.getType() != EntityType.SYNCHRO_BAR) continue;
                iterator.remove();
            }
            this.afterAdd(iEntity, direction);
            return;
        }
        if (this.waitings.size() == 0) {
            // empty if block
        }
        this.label(string);
        Entity entity = this.createEntity(this.getAutoCode(), string, EntityType.SYNCHRO_BAR);
        this.bars.put(string, entity);
        this.afterAdd(entity, direction);
    }

    private void afterAdd(IEntity iEntity, Direction direction) {
        for (IEntity object : this.waitings) {
            Link link;
            if (direction == Direction.DOWN) {
                link = new Link(object, iEntity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), this.futureLabel, 2);
            } else if (direction == Direction.RIGHT) {
                link = new Link(object, iEntity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), this.futureLabel, 1);
            } else if (direction == Direction.LEFT) {
                link = new Link(iEntity, object, new LinkType(LinkDecor.NONE, LinkDecor.ARROW), this.futureLabel, 1);
            } else if (direction == Direction.UP) {
                link = new Link(iEntity, object, new LinkType(LinkDecor.NONE, LinkDecor.ARROW), this.futureLabel, 2);
            } else {
                throw new UnsupportedOperationException();
            }
            this.addLink(link);
            this.futureLabel = null;
        }
        for (String string : this.pendingLabels) {
            this.labels.put(string, iEntity);
        }
        this.pendingLabels.clear();
        this.waitings.clear();
        this.waitings.add(iEntity);
    }

    public IEntity getLastEntityConsulted() {
        if (this.waitings.size() == 1) {
            return this.waitings.iterator().next();
        }
        return null;
    }

    private String getAutoCode() {
        return "ac" + UniqueSequence.getValue();
    }

    public void start() {
        if (this.waitings.size() != 0) {
            throw new IllegalStateException();
        }
        this.waitings.add(this.createEntity("start", "start", EntityType.CIRCLE_START));
    }

    public void startIf(String string, String string2) {
        Entity entity = this.createEntity(this.getAutoCode(), string, EntityType.BRANCH);
        this.currentContext = new ConditionalContext2(this.currentContext, entity, Direction.DOWN, string2);
        for (IEntity iEntity : this.waitings) {
            this.addLink(new Link(iEntity, entity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), this.futureLabel, 2, null, string, this.getLabeldistance(), this.getLabelangle()));
            string = null;
        }
        this.waitings.clear();
        this.waitings.add(entity);
        this.futureLabel = string2;
    }

    public void endif() {
        this.waitings.addAll(this.currentContext.getPendings());
        this.currentContext = this.currentContext.getParent();
    }

    public void else2(String string) {
        this.currentContext.executeElse(this.waitings);
        this.waitings.clear();
        this.waitings.add(this.currentContext.getBranch());
        this.futureLabel = string;
    }

    public void label(String string) {
        this.pendingLabels.add(string);
        Iterator<PendingLink> iterator = this.pendingLinks.iterator();
        while (iterator.hasNext()) {
            PendingLink pendingLink = iterator.next();
            if (!pendingLink.getGotoLabel().equals(string)) continue;
            if (pendingLink.getLinkLabel() != null) {
                this.futureLabel = pendingLink.getLinkLabel();
            }
            ArrayList<IEntity> arrayList = new ArrayList<IEntity>(this.waitings);
            this.waitings.clear();
            this.waitings.add(pendingLink.getEntityFrom());
            this.waitings.addAll(arrayList);
            iterator.remove();
        }
    }

    public void callGoto(String string) {
        IEntity iEntity = this.labels.get(string);
        for (IEntity iEntity2 : this.waitings) {
            if (iEntity == null) {
                this.pendingLinks.add(new PendingLink(iEntity2, string, this.futureLabel));
                continue;
            }
            Link link = new Link(iEntity2, iEntity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), this.futureLabel, 2);
            link.setConstraint(false);
            this.addLink(link);
        }
        this.futureLabel = null;
        this.waitings.clear();
    }

    public void end(Direction direction) {
        if (this.waitings.size() == 0) {
            throw new IllegalStateException();
        }
        IEntity iEntity = this.getOrCreateEntity("end", EntityType.CIRCLE_END);
        this.afterAdd(iEntity, direction);
    }
}

