/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
implements IEntity {
    private final String code;
    private String display;
    private final String uid;
    private EntityType type;
    private Stereotype stereotype;
    private final List<Member> fields = new ArrayList<Member>();
    private final List<Member> methods = new ArrayList<Member>();
    private final Set<VisibilityModifier> hides;
    private Group container;
    private DrawFile imageFile;
    private Url url2;
    private boolean top;
    private final int index = UniqueSequence.getValue();
    private HtmlColor specificBackcolor;
    private final Set<DrawFile> subImages = new HashSet<DrawFile>();
    private boolean nearDecoration = false;
    private int xposition;

    @Override
    public final boolean isTop() {
        return this.top;
    }

    @Override
    public final void setTop(boolean bl) {
        this.top = bl;
    }

    public Entity(String string, String string2, EntityType entityType, Group group, Set<VisibilityModifier> set) {
        this("cl" + UniqueSequence.getValue(), string, string2, entityType, group, set);
    }

    public Entity(String string, String string2, String string3, EntityType entityType, Group group, Set<VisibilityModifier> set) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        this.hides = set;
        this.uid = string;
        this.type = entityType;
        this.code = string2;
        this.display = string3;
        this.container = group;
        if (group != null && entityType != EntityType.GROUP) {
            group.addEntity(this);
        }
    }

    public void setEntityPackage(Group group) {
        if (group == null) {
            throw new IllegalArgumentException();
        }
        if (this.container != null) {
            throw new IllegalStateException();
        }
        this.container = group;
        group.addEntity(this);
    }

    public void addFieldOrMethod(String string) {
        if (this.isMethod(string)) {
            this.methods.add(new Member(string, true));
        } else {
            this.addField(string);
        }
    }

    public void addField(String string) {
        this.fields.add(new Member(string, false));
    }

    public void addField(Member member) {
        this.fields.add(member);
    }

    private boolean isMethod(String string) {
        return string.contains("(") || string.contains(")");
    }

    @Override
    public List<Member> getMethodsToDisplay() {
        if (this.hides == null || this.hides.size() == 0) {
            return Collections.unmodifiableList(this.methods);
        }
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member : this.methods) {
            if (this.hides.contains((Object)member.getVisibilityModifier())) continue;
            arrayList.add(member);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<Member> getFieldsToDisplay() {
        if (this.hides == null || this.hides.size() == 0) {
            return Collections.unmodifiableList(this.fields);
        }
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member : this.fields) {
            if (this.hides.contains((Object)member.getVisibilityModifier())) continue;
            arrayList.add(member);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    public void muteToType(EntityType entityType) {
        if (this.type != EntityType.ABSTRACT_CLASS && this.type != EntityType.CLASS && this.type != EntityType.ENUM && this.type != EntityType.INTERFACE) {
            throw new IllegalArgumentException("type=" + (Object)((Object)this.type));
        }
        if (entityType != EntityType.ABSTRACT_CLASS && entityType != EntityType.CLASS && entityType != EntityType.ENUM && entityType != EntityType.INTERFACE) {
            throw new IllegalArgumentException("newtype=" + (Object)((Object)entityType));
        }
        this.type = entityType;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final Group getParent() {
        return this.container;
    }

    public String toString() {
        if (this.type == EntityType.GROUP) {
            return this.display + "(" + (Object)((Object)this.getType()) + ")" + this.container;
        }
        return this.display + "(" + (Object)((Object)this.getType()) + ") " + this.xposition + " " + this.getUid();
    }

    public void muteToCluster(Group group) {
        if (this.type == EntityType.GROUP) {
            throw new IllegalStateException();
        }
        this.type = EntityType.GROUP;
        this.container = group;
    }

    public void moveTo(Group group) {
        this.container = group;
        group.addEntity(this);
    }

    @Override
    public final DrawFile getImageFile() {
        return this.imageFile;
    }

    public final void setImageFile(DrawFile drawFile) {
        this.imageFile = drawFile;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    @Override
    public final Url getUrl() {
        return this.url2;
    }

    public final void setUrl(Url url) {
        this.url2 = url;
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        IEntity iEntity = (IEntity)object;
        return this.uid.equals(iEntity.getUid());
    }

    public void addSubImage(DrawFile drawFile) {
        if (drawFile == null) {
            throw new IllegalArgumentException();
        }
        this.subImages.add(drawFile);
    }

    public void addSubImage(Entity entity) {
        this.subImages.addAll(entity.subImages);
    }

    @Override
    public DrawFile getImageFile(File file) throws IOException {
        if (this.imageFile != null && this.imageFile.getPng().getCanonicalFile().equals(file)) {
            return this.imageFile;
        }
        for (DrawFile drawFile : this.subImages) {
            if (!drawFile.getPng().getCanonicalFile().equals(file)) continue;
            return drawFile;
        }
        return null;
    }

    public void cleanSubImage() {
        for (DrawFile drawFile : this.subImages) {
            drawFile.deleteDrawFile();
        }
    }

    @Override
    public final boolean hasNearDecoration() {
        return this.nearDecoration;
    }

    @Override
    public final void setNearDecoration(boolean bl) {
        this.nearDecoration = bl;
    }

    @Override
    public int compareTo(IEntity iEntity) {
        if (this.index > iEntity.getIndex()) {
            return 1;
        }
        if (this.index < iEntity.getIndex()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getXposition() {
        return this.xposition;
    }

    @Override
    public void setXposition(int n) {
        this.xposition = n;
    }
}

