/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.dot.DotCommon;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilder;
import net.sourceforge.plantuml.skin.VisibilityModifier;

class LabelBuilderTableVisibility
extends DotCommon
implements LabelBuilder {
    private final IEntity entity;
    private final boolean isField;
    private final int spring;

    LabelBuilderTableVisibility(FileFormat fileFormat, DotData dotData, IEntity iEntity, boolean bl, int n) {
        super(fileFormat, dotData);
        this.entity = iEntity;
        this.isField = bl;
        this.spring = n;
    }

    public void appendLabel(StringBuilder stringBuilder) throws IOException {
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        boolean bl = this.hasStatic(this.entity.getMethodsToDisplay());
        boolean bl2 = this.getData().getDpi() == 96;
        for (Member member : this.isField ? this.entity.getFieldsToDisplay() : this.entity.getMethodsToDisplay()) {
            String string;
            VisibilityModifier visibilityModifier;
            stringBuilder.append("<TR>");
            if (bl2) {
                stringBuilder.append("<TD WIDTH=\"10\">");
            }
            if ((visibilityModifier = VisibilityModifier.getVisibilityModifier((string = member.getDisplayWithVisibilityChar()).charAt(0), this.isField)) != null) {
                String string2 = this.entity.getStereotype() == null ? null : this.entity.getStereotype().getLabel();
                String string3 = StringUtils.getPlateformDependentAbsolutePath(this.getData().getVisibilityImages(visibilityModifier, string2).getPngOrEps(this.getFileFormat()));
                if (bl2) {
                    stringBuilder.append("<IMG SRC=\"" + string3 + "\"/>");
                } else {
                    this.addTdImageBugB1983(stringBuilder, string3);
                }
                string = string.substring(1);
            }
            if (bl2) {
                stringBuilder.append("</TD>");
            }
            stringBuilder.append("<TD ALIGN=\"LEFT\">");
            stringBuilder.append(this.manageHtmlIBspecial(member, FontParam.CLASS_ATTRIBUTE, bl, this.getColorString(ColorParam.classBackground, null), false));
            stringBuilder.append("</TD>");
            for (int i = 0; i < this.spring; ++i) {
                stringBuilder.append("<TD></TD>");
            }
            stringBuilder.append("</TR>");
        }
        stringBuilder.append("</TABLE>");
    }
}

