/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

class StereographicUSGS
extends Stereographic {
    private static final long serialVersionUID = 948619442800459871L;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-6;
    final double k0;
    final double sinphi0;
    final double cosphi0;
    final double chi1;
    final double sinChi1;
    final double cosChi1;

    protected StereographicUSGS(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, Stereographic.Provider.PARAMETERS);
    }

    StereographicUSGS(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
        super(parameters, descriptor);
        if (Math.abs(this.latitudeOfOrigin) < 1.0E-6) {
            this.latitudeOfOrigin = 0.0;
            this.cosphi0 = 1.0;
            this.sinphi0 = 0.0;
            this.chi1 = 0.0;
            this.cosChi1 = 1.0;
            this.sinChi1 = 0.0;
        } else {
            this.cosphi0 = Math.cos(this.latitudeOfOrigin);
            this.sinphi0 = Math.sin(this.latitudeOfOrigin);
            this.chi1 = 2.0 * Math.atan(this.ssfn(this.latitudeOfOrigin, this.sinphi0)) - 1.5707963267948966;
            this.cosChi1 = Math.cos(this.chi1);
            this.sinChi1 = Math.sin(this.chi1);
        }
        this.k0 = 2.0 * this.msfn(this.sinphi0, this.cosphi0);
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double sinChi = Math.sin(chi);
        double cosChi = Math.cos(chi);
        double cosChi_cosLon = cosChi * Math.cos(x);
        double A = this.k0 / this.cosChi1 / (1.0 + this.sinChi1 * sinChi + this.cosChi1 * cosChi_cosLon);
        x = A * cosChi * Math.sin(x);
        y = A * (this.cosChi1 * sinChi - this.sinChi1 * cosChi_cosLon);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double ct;
        double t;
        boolean rhoIs0;
        block2: {
            double rho = Math.hypot(x, y);
            double ce = 2.0 * Math.atan2(rho * this.cosChi1, this.k0);
            double cosce = Math.cos(ce);
            double since = Math.sin(ce);
            rhoIs0 = Math.abs(rho) < 1.0E-6;
            double chi = rhoIs0 ? this.chi1 : Math.asin(cosce * this.sinChi1 + y * since * this.cosChi1 / rho);
            double tp = Math.tan(0.7853981633974483 + chi / 2.0);
            t = x * since;
            ct = rho * this.cosChi1 * cosce - y * this.sinChi1 * since;
            double halfe = this.excentricity / 2.0;
            double phi0 = chi;
            int i = 15;
            do {
                double esinphi;
                if (Math.abs((phi = 2.0 * Math.atan(tp * Math.pow((1.0 + (esinphi = this.excentricity * Math.sin(phi0))) / (1.0 - esinphi), halfe)) - 1.5707963267948966) - phi0) < 1.0E-10) break block2;
                phi0 = phi;
            } while (--i >= 0);
            throw new ProjectionException(129);
        }
        x = rhoIs0 || Math.abs(t) < 1.0E-6 && Math.abs(ct) < 1.0E-6 ? 0.0 : Math.atan2(t, ct);
        y = phi;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        double delta = Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin);
        if (delta > 40.0) {
            return 0.5;
        }
        if (delta > 15.0) {
            return 0.1;
        }
        return super.getToleranceForAssertions(longitude, latitude);
    }

    final double ssfn(double phi, double sinphi) {
        return Math.tan(0.7853981633974483 + phi / 2.0) * Math.pow((1.0 - (sinphi *= this.excentricity)) / (1.0 + sinphi), this.excentricity / 2.0);
    }

    static final class Spherical
    extends StereographicUSGS {
        private static final long serialVersionUID = -8558594307755820783L;
        private static final double k0 = 2.0;

        Spherical(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
            super(parameters, descriptor);
            this.ensureSpherical();
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double coslon;
            assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
            double coslat = Math.cos(y);
            double sinlat = Math.sin(y);
            double f = 1.0 + this.sinphi0 * sinlat + this.cosphi0 * coslat * (coslon = Math.cos(x));
            if (f < 1.0E-6) {
                throw new ProjectionException(202);
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * (this.cosphi0 * sinlat - this.sinphi0 * coslat * coslon);
            assert (Spherical.checkTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double rho = Math.hypot(x, y);
            if (Math.abs(rho) < 1.0E-6) {
                y = this.latitudeOfOrigin;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                double ct = rho * this.cosphi0 * cosc - y * this.sinphi0 * sinc;
                double t = x * sinc;
                y = Math.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / rho);
                double d = x = Math.abs(ct) < 1.0E-6 && Math.abs(t) < 1.0E-6 ? 0.0 : Math.atan2(t, ct);
            }
            assert (Spherical.checkInverseTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }
}

