/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.config.GroupConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCall
extends AbstractRemotelyCallable<Boolean> {
    String groupName;
    String groupPassword;

    public AuthorizationCall() {
    }

    public AuthorizationCall(String groupName, String groupPassword) {
        this.groupName = groupName;
        this.groupPassword = groupPassword;
    }

    @Override
    public Boolean call() throws Exception {
        GroupConfig groupConfig = this.node.getConfig().getGroupConfig();
        if (!this.groupName.equals(groupConfig.getName())) {
            return Boolean.FALSE;
        }
        if (!this.groupPassword.equals(groupConfig.getPassword())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.groupName = in.readUTF();
        this.groupPassword = in.readUTF();
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        out.writeUTF(this.groupName);
        out.writeUTF(this.groupPassword);
    }
}

