/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.net.InetAddress;
import java.net.Socket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.connector.Ajp13ConnectorRequest;
import org.apache.tomcat.service.connector.Ajp13ConnectorResponse;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.TcpConnector;

public class Ajp13ConnectionHandler
implements TcpConnectionHandler {
    ContextManager contextM;
    public static final byte JK_AJP13_FORWARD_REQUEST = 2;
    public static final byte JK_AJP13_SHUTDOWN = 7;

    protected boolean doShutdown(TcpConnector con, InetAddress serverAddr, InetAddress clientAddr) {
        try {
            con.close();
            if (this.isSameAddress(serverAddr, clientAddr)) {
                this.contextM.stop();
                System.exit(0);
            }
        }
        catch (Exception ignored) {
            System.err.println(ignored);
        }
        System.err.println("Shutdown command ignored");
        return false;
    }

    public Object[] init() {
        Object[] thData = new Object[3];
        Ajp13ConnectorRequest req = new Ajp13ConnectorRequest();
        Ajp13ConnectorResponse res = new Ajp13ConnectorResponse();
        this.contextM.initRequest(req, res);
        thData[0] = req;
        thData[1] = res;
        thData[2] = new TcpConnector();
        return thData;
    }

    private boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void processConnection(TcpConnection connection, Object[] thData) {
        try {
            if (connection == null) {
                return;
            }
            Socket socket = connection.getSocket();
            if (socket == null) {
                return;
            }
            socket.setSoLinger(true, 100);
            TcpConnector con = null;
            Ajp13ConnectorRequest req = null;
            Ajp13ConnectorResponse res = null;
            if (thData != null) {
                req = (Ajp13ConnectorRequest)thData[0];
                res = (Ajp13ConnectorResponse)thData[1];
                con = (TcpConnector)thData[2];
                if (req != null) {
                    req.recycle();
                }
                if (res != null) {
                    res.recycle();
                }
                if (con != null) {
                    con.recycle();
                }
            }
            if (req == null || res == null || con == null) {
                req = new Ajp13ConnectorRequest();
                res = new Ajp13ConnectorResponse();
                con = new TcpConnector();
                this.contextM.initRequest(req, res);
            }
            con.setSocket(socket);
            res.setConnector(con);
            req.setConnector(con);
            boolean moreRequests = true;
            while (moreRequests) {
                MsgBuffer msg = con.getMsgBuffer();
                int err = con.receive(msg);
                if (err < 0) {
                    moreRequests = false;
                    break;
                }
                byte type = msg.getByte();
                switch (type) {
                    case 2: {
                        err = req.decodeRequest(msg);
                        this.contextM.service(req, res);
                        req.recycle();
                        res.recycle();
                        break;
                    }
                    case 7: {
                        if (this.doShutdown(con, socket.getLocalAddress(), socket.getInetAddress())) break;
                        moreRequests = false;
                        break;
                    }
                }
            }
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setServer(Object contextM) {
        this.contextM = (ContextManager)contextM;
    }
}

