/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.util.Hashtable;

public class SQLError {
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_DEADLOCK = "41000";
    public static final String SQL_STATE_CONNECTION_FAIL_DURING_TX = "08007";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    private static Hashtable mysqlToSqlState;
    private static Hashtable sqlStateMessages;

    static String get(String stateCode) {
        return (String)sqlStateMessages.get(stateCode);
    }

    static String mysqlToXOpen(int errno) {
        Integer err = new Integer(errno);
        if (mysqlToSqlState.containsKey(err)) {
            return (String)mysqlToSqlState.get(err);
        }
        return SQL_STATE_GENERAL_ERROR;
    }

    static {
        SQL_STATE_TIMEOUT_EXPIRED = SQL_STATE_TIMEOUT_EXPIRED;
        SQL_STATE_DRIVER_NOT_CAPABLE = SQL_STATE_DRIVER_NOT_CAPABLE;
        SQL_STATE_ILLEGAL_ARGUMENT = SQL_STATE_ILLEGAL_ARGUMENT;
        SQL_STATE_INVALID_COLUMN_NUMBER = SQL_STATE_INVALID_COLUMN_NUMBER;
        SQL_STATE_MEMORY_ALLOCATION_FAILURE = SQL_STATE_MEMORY_ALLOCATION_FAILURE;
        SQL_STATE_GENERAL_ERROR = SQL_STATE_GENERAL_ERROR;
        SQL_STATE_NO_DEFAULT_FOR_COLUMN = SQL_STATE_NO_DEFAULT_FOR_COLUMN;
        SQL_STATE_COLUMN_NOT_FOUND = SQL_STATE_COLUMN_NOT_FOUND;
        SQL_STATE_COLUMN_ALREADY_EXISTS = SQL_STATE_COLUMN_ALREADY_EXISTS;
        SQL_STATE_INDEX_NOT_FOUND = SQL_STATE_INDEX_NOT_FOUND;
        SQL_STATE_INDEX_ALREADY_EXISTS = SQL_STATE_INDEX_ALREADY_EXISTS;
        SQL_STATE_BASE_TABLE_NOT_FOUND = SQL_STATE_BASE_TABLE_NOT_FOUND;
        SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS;
        SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND;
        SQL_STATE_SYNTAX_ERROR = SQL_STATE_SYNTAX_ERROR;
        SQL_STATE_DATETIME_FIELD_OVERFLOW = SQL_STATE_DATETIME_FIELD_OVERFLOW;
        SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE;
        SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST;
        SQL_STATE_DIVISION_BY_ZERO = SQL_STATE_DIVISION_BY_ZERO;
        SQL_STATE_INVALID_AUTH_SPEC = SQL_STATE_INVALID_AUTH_SPEC;
        SQL_STATE_DEADLOCK = SQL_STATE_DEADLOCK;
        SQL_STATE_CONNECTION_FAIL_DURING_TX = SQL_STATE_CONNECTION_FAIL_DURING_TX;
        SQL_STATE_CONNECTION_REJECTED = SQL_STATE_CONNECTION_REJECTED;
        SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE;
        SQL_STATE_CONNECTION_IN_USE = SQL_STATE_CONNECTION_IN_USE;
        SQL_STATE_CONNECTION_NOT_OPEN = SQL_STATE_CONNECTION_NOT_OPEN;
        SQL_STATE_WRONG_NO_OF_PARAMETERS = SQL_STATE_WRONG_NO_OF_PARAMETERS;
        SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED;
        SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = SQL_STATE_NO_ROWS_UPDATED_OR_DELETED;
        SQL_STATE_ERROR_IN_ROW = SQL_STATE_ERROR_IN_ROW;
        SQL_STATE_COMMUNICATION_LINK_FAILURE = SQL_STATE_COMMUNICATION_LINK_FAILURE;
        SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = SQL_STATE_INVALID_CONNECTION_ATTRIBUTE;
        SQL_STATE_PRIVILEGE_NOT_REVOKED = SQL_STATE_PRIVILEGE_NOT_REVOKED;
        SQL_STATE_DATE_TRUNCATED = SQL_STATE_DATE_TRUNCATED;
        SQL_STATE_DISCONNECT_ERROR = SQL_STATE_DISCONNECT_ERROR;
        sqlStateMessages = new Hashtable();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, "Disconnect error");
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, "Data truncated");
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, "Privilege not revoked");
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, "Invalid connection string attribute");
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, "Error in row");
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, "No rows updated or deleted");
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, "More than one row updated or deleted");
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, "Wrong number of parameters");
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, "Unable to connect to data source");
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, "Connection in use");
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, "Connection not open");
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, "Data source rejected establishment of connection");
        sqlStateMessages.put(SQL_STATE_CONNECTION_FAIL_DURING_TX, "Connection failure during transaction");
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, "Communication link failure");
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, "Insert value list does not match column list");
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, "Numeric value out of range");
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, "Datetime field overflow");
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, "Division by zero");
        sqlStateMessages.put(SQL_STATE_DEADLOCK, "Deadlock found when trying to get lock; Try restarting transaction");
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, "Invalid authorization specification");
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, "Syntax error or access violation");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, "Base table or view not found");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, "Base table or view already exists");
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, "Base table not found");
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, "Index already exists");
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, "Index not found");
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, "Column already exists");
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, "Column not found");
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, "No default for column");
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, "General error");
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, "Memory allocation failure");
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, "Invalid column number");
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, "Invalid argument value");
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, "Driver not capable");
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, "Timeout expired");
        mysqlToSqlState = new Hashtable();
        mysqlToSqlState.put(new Integer(1040), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1042), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1043), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1047), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(new Integer(1081), SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(new Integer(1129), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1130), SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(new Integer(1045), SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSqlState.put(new Integer(1037), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(new Integer(1038), SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(new Integer(1064), SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(new Integer(1065), SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(new Integer(1055), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1056), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1057), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1059), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1060), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1061), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1062), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1063), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1066), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1067), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1068), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1069), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1070), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1071), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1072), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1073), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1074), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1075), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1082), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1083), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1084), SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(new Integer(1058), SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSqlState.put(new Integer(1051), SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSqlState.put(new Integer(1054), SQL_STATE_COLUMN_NOT_FOUND);
        mysqlToSqlState.put(new Integer(1205), SQL_STATE_DEADLOCK);
        mysqlToSqlState.put(new Integer(1213), SQL_STATE_DEADLOCK);
    }
}

